/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.launcher.delegate;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.cdt.core.model.ICProject;
import org.eclipse.cdt.core.settings.model.ICConfigurationDescription;
import org.eclipse.cdt.core.settings.model.ICProjectDescription;
import org.eclipse.cdt.debug.core.CDebugUtils;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunch;
import org.eclipse.cdt.dsf.gdb.launching.GdbLaunchDelegate;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.cdt.launch.internal.ui.LaunchUIPlugin;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.cdt.ui.newui.CDTPropertyManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sdb.command.SdbCommand;
import org.tizen.common.util.LocalPortChecker;
import org.tizen.common.util.SWTUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativecommon.build.CommonConfigurationManager;
import org.tizen.nativecommon.build.SmartBuildInterface;
import org.tizen.nativecommon.launch.LaunchUtils;
import org.tizen.nativecommon.launch.TizenLaunchCommand;
import org.tizen.nativecommon.launch.TizenLaunchMessages;
import org.tizen.nativecommon.launch.TizenUIThreadForConfirmMessage;
import org.tizen.nativecommon.launch.ui.TizenLaunchDeviceSelectionDialog;
import org.tizen.nativeplatform.PlatformConfigurationManager;
import org.tizen.nativeplatform.RootstrapProxy;
import org.tizen.nativeplatform.command.launcher.LaunchCommandCancelThread;
import org.tizen.nativeplatform.launcher.LauncherInstances;
import org.tizen.nativeplatform.launcher.command.provider.IDebugCommandProvider;
import org.tizen.nativeplatform.launcher.command.provider.IRunCommandProvider;
import org.tizen.nativeplatform.launcher.delegate.ILaunchConfigurationProcessor;
import org.tizen.nativeplatform.launcher.delegate.LaunchConfigurationProcessor;
import org.tizen.nativeplatform.launcher.factory.PkgFilterFactory;
import org.tizen.nativeplatform.launcher.message.PlatformLaunchMessages;
import org.tizen.nativeplatform.launcher.rpm.IPkgFilter;
import org.tizen.nativeplatform.launcher.wizards.ShowPackageStatusDialog;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.pkg.commander.IPkgCommander;
import org.tizen.nativeplatform.pkg.commander.PkgCommandTarget;
import org.tizen.nativeplatform.pkg.model.PkgStatus;
import org.tizen.nativeplatform.types.CmdTargetTypes;
import org.tizen.nativeplatform.util.CommonPackageUtil;
import org.tizen.nativeplatform.util.IPackageUtil;
import org.tizen.nativeplatform.util.PlatformFileUtil;
import org.tizen.nativeplatform.util.PlatformLaunchUtil;
import org.tizen.nativeplatform.util.PlatformProjectUtil;
import org.tizen.sdblib.Arch;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.PlatformInfo;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.util.DeviceUtil;

public class PlatformLaunchDelegate
extends GdbLaunchDelegate {
    protected IConfiguration selectedConfig;
    protected IDevice currentDevice;
    protected PlatformRootstrap rootstrap;
    protected PkgCommandTarget target = null;
    protected int localDebugPort = -1;
    protected static final int defaultTimeOut = 60000;
    protected Shell shell;
    protected IProject project;
    private boolean result;
    private String programPath;
    protected boolean isLaunchFailed = false;
    protected boolean isCoredump = false;
    protected TizenLaunchCommand tizenCommand = null;
    protected IPackageUtil pkgUtil = LauncherInstances.getPackageUtil();
    protected IPkgFilter pkgFilter = PkgFilterFactory.getFilter(PlatformProjectUtil.getPkgType());
    protected static final String PROCESS_GET_PROCESS_ID_COMMAND = String.valueOf(TizenPlatformConstants.SDK_ROOT_COMMAND) + " process | grep '%s' | grep -v grep | awk '{print $1}'";
    protected static final String GET_PROCESS_ID_COMMAND = " ps -ef | grep '%s' | grep -v grep | awk '{print $2}'";
    protected static final String CHECK_RUNNING_GDBSERVER = String.format(TizenPlatformConstants.CMD_PROCESS, "gdb");
    protected static final String EMULATOR_PATH = InstallPathConfig.getEmulatorPath();
    protected static final String EMULATOR_CLI_BAT = String.valueOf(EMULATOR_PATH) + File.separatorChar + "bin" + File.separatorChar + "ecp-cli.bat";
    protected static final String EMULATOR_CLI_BIN = String.valueOf(EMULATOR_PATH) + File.separatorChar + "bin" + File.separatorChar + "ecp-cli";
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private DsfSession debugSession;

    protected String getPluginID() {
        return "org.tizen.nativeplatform";
    }

    protected void preProcessDebug() {
    }

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        UserLogger.start((String)"platform.launch");
        UserLogger.start((String)"platform.launch", (String)"pre.launch");
        this.isLaunchFailed = false;
        this.shell = LaunchUIPlugin.getShell();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            int totalWorks = 3;
            monitor.beginTask("", totalWorks);
            monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION);
            this.project = this.getProject(config);
            if (!this.isCoredump) {
                this.checkPackageFiles(this.project, this.getBuildConfiguration(this.project));
            }
            this.activateProgressView();
            this.currentDevice = PlatformLaunchUtil.getDefaultLaunchTarget((IProject)this.project);
            this.setRootstrap(config);
            this.verifyBuildConfiguration(config, mode, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.setPkgCommandTarget();
            this.tizenCommand = new TizenLaunchCommand(this.currentDevice, null);
            String targetPlatformVersion = null;
            boolean isPlatformVersion3 = false;
            try {
                PlatformInfo platforminfo;
                if (this.currentDevice != null && (platforminfo = this.currentDevice.getPlatformInfo()) != null) {
                    targetPlatformVersion = platforminfo.getPlatformVersion();
                }
            }
            catch (IOException e) {
                this.logger.error("Failed to get platform version", (Throwable)e);
            }
            if ("3.0".equals(targetPlatformVersion)) {
                isPlatformVersion3 = true;
            }
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            wc.setAttribute("org.tizen.platform.launch.TARGET_PLATFORM_VERSION", isPlatformVersion3);
            config = wc.doSave();
            ILaunchConfigurationProcessor processor = this.getConfigurationProcessor(this.shell, config, this.project, mode, this.target, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (!processor.process()) {
                this.newCoreException(PlatformLaunchMessages.CANNOT_LAUNCH, null);
            }
            if (mode.equals("debug")) {
                IDebugCommandProvider iDebugCommandProvider;
                if (!this.isCoredump && (iDebugCommandProvider = LauncherInstances.getDebugCommandProvider()) != null) {
                    iDebugCommandProvider.winCheckDebugsourceSync(this.shell, this.target.getRootstrap());
                }
                this.setSourceContainer(config);
                this.processPreDebug(config);
                this.setDebugConfigAttributes(config);
                this.verifyPlatformProjectSettings(config);
                IBinaryParser.IBinaryObject exeFile = this.getBinaryObject(config);
                this.launchApplicationForDebug(launch, config, exeFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            } else {
                this.launchApplicationForRun(config, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            if (mode.equals("debug")) {
                this.processPostDebug(config);
            } else {
                if (!launch.isTerminated()) {
                    launch.terminate();
                }
                ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
                launchManager.removeLaunch(launch);
            }
            if (this.isLaunchFailed) {
                config.delete();
                this.isLaunchFailed = false;
            }
            monitor.done();
            UserLogger.end((String)"platform.launch");
        }
    }

    protected void checkPackageFiles(IProject project, IConfiguration config) throws CoreException {
        String[] xmls;
        boolean isEfl;
        File dir;
        String selectedRootstrapArch = RootstrapProxy.getProxy().getSelectedRootstrap().getArchitecture();
        List pkgs = this.pkgUtil.getPackages(project, config, selectedRootstrapArch);
        if (pkgs == null || pkgs.isEmpty()) {
            this.newCoreException("Can not find package(.rpm) file. Try to build again", null);
        }
        if (!(dir = project.getFile(config.getName()).getLocation().toFile()).exists()) {
            this.newCoreException(config + " directory does not exist. Try to build again", null);
        }
        if ((isEfl = CommonPackageUtil.checkXmls((IProject)project)) && (xmls = CommonPackageUtil.getXmls((IProject)project)) == null) {
            this.newCoreException("Can not find .xml file. Try to build again", null);
        }
    }

    protected IConfiguration getBuildConfiguration(IProject project) {
        return PlatformConfigurationManager.getDefaultConfiguration((IProject)project);
    }

    protected ILaunchConfigurationProcessor getConfigurationProcessor(Shell shell, ILaunchConfiguration launchConfig, IProject project, String mode, PkgCommandTarget target, IProgressMonitor monitor) {
        return new LaunchConfigurationProcessor(shell, launchConfig, project, mode, target, monitor);
    }

    protected void setSourceContainer(ILaunchConfiguration configuration) {
    }

    protected void checkChangedConfiguration(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        monitor.subTask("Checking EFL application...");
        try {
            boolean isEflApp = CommonPackageUtil.checkXmls((IProject)this.project);
            if (isEflApp) {
                this.programPath = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
                String appId = PlatformLaunchUtil.getAppId((IProject)this.project, (String)this.programPath);
                this.killIfRunningApplication(appId);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void killIfRunningApplication(String appId) throws CoreException {
        IPkgCommander commander = this.target.getCommander(CmdTargetTypes.DEVICE);
        boolean isRunning = commander.isRunningApp(appId);
        if (isRunning) {
            commander.killApp(appId);
        }
    }

    protected Shell getAvaiableShell() {
        Shell shell = PlatformLaunchUtil.getAvaiableShell();
        return shell;
    }

    public boolean buildForLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 2);
        boolean result = super.buildForLaunch(configuration, mode, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        monitor.done();
        return result;
    }

    protected void processPreDebug(ILaunchConfiguration config) throws CoreException {
    }

    protected void killGdbserver(int forwardingTargetPort) throws CoreException {
        if (forwardingTargetPort == -1) {
            forwardingTargetPort = Integer.parseInt("26102");
        }
        String gdbserverCmd = String.valueOf(TizenPlatformConstants.GDBSERVER_PLATFORM_CMD) + " :" + forwardingTargetPort;
        String resultCommand = String.format(GET_PROCESS_ID_COMMAND, gdbserverCmd.trim());
        try {
            this.tizenCommand.run(resultCommand, null);
            if (this.tizenCommand.getEndLine() != null && StringUtil.isInteger((String)this.tizenCommand.getEndLine().trim())) {
                resultCommand = String.format("kill -9 %s", String.valueOf(this.tizenCommand.getEndLine()) + "; echo $?;");
                try {
                    this.tizenCommand.run(resultCommand, "0");
                }
                catch (Exception e) {
                    this.logger.error(TizenLaunchMessages.GDBSERVER_ALREADY_RUNNING, (Throwable)e);
                    this.newCoreException(TizenLaunchMessages.GDBSERVER_ALREADY_RUNNING, null);
                }
            }
        }
        catch (Exception e1) {
            this.logger.error(PlatformLaunchMessages.FAILED_KILL_GDBSERVER, (Throwable)e1);
        }
    }

    protected void removePortForwarding(int forwardingTargetPort, String forwardingLocalPort) {
        if (forwardingTargetPort != -1) {
            try {
                this.currentDevice.removeForward(Integer.parseInt(forwardingLocalPort), forwardingTargetPort);
            }
            catch (Exception exception) {
                this.logger.error(String.format(PlatformLaunchMessages.FAILED_REMOVE_FORWARD, forwardingLocalPort, forwardingTargetPort));
            }
        }
    }

    protected void processPostDebug(ILaunchConfiguration config) throws CoreException {
        if (this.debugSession != null) {
            while (this.debugSession.isActive()) {
            }
        }
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        int forwardingTargetPort = wc.getAttribute("org.tizen.platform.launch.DEBUG_REALPORT", -1);
        String forwardingLocalPort = wc.getAttribute("org.eclipse.cdt.dsf.gdb.PORT", "26102");
        this.removePortForwarding(forwardingTargetPort, forwardingLocalPort);
        this.killGdbserver(forwardingTargetPort);
    }

    protected void verifyPlatformProjectSettings(ILaunchConfiguration config) throws CoreException {
        IPath hostPath;
        String appPath = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        IRunCommandProvider iRunCommandProvider = LauncherInstances.getRunCommandProvider();
        if (iRunCommandProvider != null && (hostPath = iRunCommandProvider.getHostPath(this.target, appPath)) != null && !PlatformFileUtil.existsFile((String)hostPath.toString())) {
            this.newCoreException(PlatformLaunchMessages.CANNOT_FIND_EXECUTABLE_IN_A_HOST_ROOTSTRAP, null);
        }
    }

    protected void verifyBuildConfiguration(ILaunchConfiguration config, String mode, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("", 1);
        monitor.subTask(TizenLaunchMessages.PREPARE_TO_LAUNCH);
        String buildConfigName = this.getBuildConfigName(config);
        IConfiguration configuration = this.getBuildConfiguration(buildConfigName, this.project);
        String buildTargetArchitecture = CommonConfigurationManager.getArchitecture((IConfiguration)configuration);
        if (this.currentDevice != null) {
            if (this.currentDevice.isEmulator() && this.currentDevice.getArch() == Arch.X86) {
                if (!PlatformConfigurationManager.isEmulatorArch((String)buildTargetArchitecture)) {
                    this.resolveProblematicConfiguration(config, "i386");
                }
            } else if (!PlatformConfigurationManager.isDeviceArch((String)buildTargetArchitecture)) {
                this.resolveProblematicConfiguration(config, "armel");
            }
        }
        monitor.worked(1);
        monitor.done();
    }

    protected void resolveProblematicConfiguration(ILaunchConfiguration config, final String arch) throws CoreException {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                PlatformLaunchDelegate.this.selectedConfig = PlatformLaunchDelegate.this.selectBuildConfiguration(PlatformLaunchDelegate.this.project, arch);
            }
        });
        if (this.selectedConfig == null) {
            this.newCoreException(TizenLaunchMessages.BUILD_CONFIGURATION_DOES_NOT_MATCH_WITH_CURRENT_DEVICE_TYPE, null);
        }
        ICProjectDescription projDes = CDTPropertyManager.getProjectDescription((IProject)this.project);
        ICConfigurationDescription cDesc = projDes.getConfigurationByName(this.selectedConfig.getName());
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute("org.eclipse.cdt.launch.PROJECT_BUILD_CONFIG_ID_ATTR", cDesc.getConfiguration().getId());
        wc.doSave();
    }

    protected IConfiguration selectBuildConfiguration(IProject project, String arch) {
        Shell shell = LaunchUIPlugin.getShell();
        LabelProvider topprovider = new LabelProvider(){

            public String getText(Object element) {
                IConfiguration buildConfig = (IConfiguration)element;
                return buildConfig.getName();
            }
        };
        LabelProvider downprovider = new LabelProvider(){

            public String getText(Object element) {
                IConfiguration buildConfig = (IConfiguration)element;
                return buildConfig.getName();
            }
        };
        TwoPaneElementSelector dlg = new TwoPaneElementSelector(shell, (ILabelProvider)topprovider, (ILabelProvider)downprovider);
        dlg.setTitle("Select a new build configuration");
        dlg.setMessage("Build configuration doesn't match with current active device.\nSelect a new build configuration to launch");
        IConfiguration[] configurations = ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations();
        ArrayList<IConfiguration> adaptableConfigs = new ArrayList<IConfiguration>(0);
        IConfiguration[] iConfigurationArray = configurations;
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            String buildTargetArchitecture;
            IConfiguration c = iConfigurationArray[n2];
            if (c != null && (buildTargetArchitecture = CommonConfigurationManager.getArchitecture((IConfiguration)c)) != null && buildTargetArchitecture.equals(arch)) {
                adaptableConfigs.add(c);
            }
            ++n2;
        }
        dlg.setElements(adaptableConfigs.toArray());
        if (dlg.open() == 0) {
            IConfiguration selectedConfig = (IConfiguration)dlg.getFirstResult();
            return selectedConfig;
        }
        return null;
    }

    protected IConfiguration getBuildConfiguration(String buildConfigName, IProject project) throws CoreException {
        IConfiguration[] configurations;
        IConfiguration configuration = null;
        IConfiguration[] iConfigurationArray = configurations = ManagedBuildManager.getBuildInfo((IResource)project).getManagedProject().getConfigurations();
        int n = configurations.length;
        int n2 = 0;
        while (n2 < n) {
            IConfiguration c = iConfigurationArray[n2];
            if (c.getName().equals(buildConfigName)) {
                configuration = c;
                break;
            }
            ++n2;
        }
        if (configuration == null) {
            this.newCoreException(TizenLaunchMessages.BUILD_CONFIGURATION_DOES_NOT_MATCH_WITH_CURRENT_DEVICE_TYPE, null);
        }
        return configuration;
    }

    protected String getBuildConfigName(ILaunchConfiguration config) throws CoreException {
        String buildConfigName = config.getAttribute("org.tizen.nativeapp.launch.PROJECT_BUILD_CONFIG_NAME_ATTR", "");
        if (buildConfigName.isEmpty()) {
            IConfiguration configuration = ManagedBuildManager.getBuildInfo((IResource)this.project).getDefaultConfiguration();
            return configuration.getName();
        }
        return buildConfigName;
    }

    protected boolean resolveProblematicConfiguration(IProject project, IConfiguration problematicConfig, String arch, String mode) {
        TizenUIThreadForConfirmMessage runnable = new TizenUIThreadForConfirmMessage(project, problematicConfig, arch, mode);
        Display.getDefault().syncExec((Runnable)runnable);
        if (runnable.getResult()) {
            ManagedBuildManager.getBuildInfo((IResource)project).setDefaultConfiguration(runnable.getSuitableConfigName());
            return true;
        }
        return false;
    }

    protected void setRootstrap(ILaunchConfiguration config) throws CoreException {
        String buildConfigName = this.getBuildConfigName(config);
        IConfiguration buildConfig = this.getBuildConfiguration(buildConfigName, this.project);
        String targetID = PlatformConfigurationManager.getBuildTargetName((IConfiguration)buildConfig);
        String rootstrapId = SmartBuildInterface.getInstance().getRootstrapIDFromTargetID(targetID);
        this.rootstrap = RootstrapProxy.getProxy().getRootstrap(rootstrapId);
    }

    private IDevice[] getDeploayableDevices(ILaunchConfiguration config) throws CoreException {
        IDevice[] devices = SmartDevelopmentBridge.getBridge().getDevices();
        ArrayList<IDevice> deployableDevices = new ArrayList<IDevice>();
        Arch configArch = this.getBuildConfigurationArchitecture(config);
        IDevice[] iDeviceArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            IDevice device = iDeviceArray[n2];
            if (device.getArch() == configArch) {
                deployableDevices.add(device);
            }
            ++n2;
        }
        return deployableDevices.toArray(new IDevice[deployableDevices.size()]);
    }

    protected Arch getBuildConfigurationArchitecture(ILaunchConfiguration config) throws CoreException {
        String buildTargetArchitecture = this.getBuildConfigName(config);
        return this.getBuildConfigurationArchitecture(this.project, buildTargetArchitecture);
    }

    protected Arch getBuildConfigurationArchitecture(IProject project, String buildTargetArchitecture) throws CoreException {
        IConfiguration configuration = this.getBuildConfiguration(buildTargetArchitecture, project);
        String arch = PlatformConfigurationManager.getArchitecture((IConfiguration)configuration);
        if (LaunchUtils.isX86((String)arch)) {
            return Arch.X86;
        }
        return Arch.ARM;
    }

    protected void verifyDeviceReachability(ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(TizenLaunchMessages.PREPARE_TO_LAUNCH, 1);
            monitor.subTask(TizenLaunchMessages.PREPARE_TO_LAUNCH);
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            final IDevice[] devices = this.getDeploayableDevices(config);
            IDevice configDevice = null;
            configDevice = LaunchUtils.getDeviceFromLaunchConfiguration((ILaunchConfiguration)config, (IDevice[])devices);
            if (configDevice == null) {
                int device_count = devices.length;
                if (device_count == 0) {
                    this.currentDevice = null;
                } else {
                    if (device_count == 1) {
                        this.currentDevice = devices[0];
                    } else {
                        SWTUtil.syncExec((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                                TizenLaunchDeviceSelectionDialog deviceDialog = new TizenLaunchDeviceSelectionDialog(shell, devices);
                                PlatformLaunchDelegate.this.currentDevice = deviceDialog.open() == 0 ? deviceDialog.getSelectedDevice() : null;
                            }
                        });
                    }
                    if (this.currentDevice != null) {
                        String device_id = LaunchUtils.getDeviceId((IDevice)this.currentDevice);
                        wc.setAttribute("org.tizen.common.launch.device.id", device_id);
                        wc.doSave();
                    }
                }
            } else {
                this.currentDevice = configDevice;
            }
            if (this.currentDevice == null && !this.isCoredump) {
                LaunchUtils.newCoreException((String)TizenLaunchMessages.NO_TARGET, null);
            }
            if (!DeviceUtil.isOnline((IDevice)this.currentDevice) && !this.isCoredump) {
                LaunchUtils.newCoreException((String)TizenLaunchMessages.NO_TARGET, null);
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void launchApplicationForRun(ILaunchConfiguration config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IPkgCommander commander = this.target.getCommander(CmdTargetTypes.DEVICE);
        LaunchCommandCancelThread cancelThread = new LaunchCommandCancelThread(commander, monitor);
        try {
            try {
                monitor.beginTask("", 1);
                monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION);
                cancelThread.start();
                String envCmd = this.getEnvironments(config);
                String execArg = this.getArguments(config);
                commander.executeBinary(String.valueOf(envCmd) + execArg);
            }
            catch (IOException e) {
                this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH, e);
                monitor.worked(1);
                monitor.done();
                cancelThread.setTerminated();
                if (cancelThread.isAlive()) {
                    cancelThread.interrupt();
                }
            }
            catch (Exception e) {
                this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH, e);
                monitor.worked(1);
                monitor.done();
                cancelThread.setTerminated();
                if (cancelThread.isAlive()) {
                    cancelThread.interrupt();
                }
            }
        }
        finally {
            monitor.worked(1);
            monitor.done();
            cancelThread.setTerminated();
            if (cancelThread.isAlive()) {
                cancelThread.interrupt();
            }
        }
    }

    protected void resetGdbserverPortAttr(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", "26102");
        wc.setAttribute("org.eclipse.cdt.dsf.gdb.PORT", "26102");
        wc.setAttribute("org.tizen.platform.launch.DEBUG_REALPORT", -1);
        wc.doSave();
    }

    protected void launchApplicationForDebug(ILaunch launch, ILaunchConfiguration config, IBinaryParser.IBinaryObject exeFile, IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        try {
            this.resetGdbserverPortAttr(config);
            if (!LaunchUtils.setAvailableGdbServerPort((ILaunch)launch, (ILaunchConfiguration)config, (IDevice)this.currentDevice)) {
                return;
            }
            monitor.beginTask("", 2);
            monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION);
            this.launchApplicationWithGDBServer(launch, config, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            this.launchApplicationWithGDBClient(launch, config, exeFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    protected void launchApplicationWithGDBServer(ILaunch launch, ILaunchConfiguration config, IProgressMonitor monitor) throws CoreException {
        try {
            try {
                monitor.beginTask("", 1);
                monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION_WITH_GDBSERVER);
                IRunCommandProvider iRunCommandProvider = LauncherInstances.getRunCommandProvider();
                if (iRunCommandProvider != null) {
                    IPath path = iRunCommandProvider.getHostPath(this.target, "/usr/bin/gdbserver");
                    PlatformLaunchUtil.readyGdbServer((PkgCommandTarget)this.target, (IDevice)this.currentDevice, (TizenLaunchCommand)this.tizenCommand, (IPath)path);
                    String gdbserverRunCommand = this.getGdbserverRunCommand(config);
                    UserLogger.start((String)"platform.launch", (String)"start.gdbserver");
                    this.tizenCommand.run(gdbserverRunCommand, null, true);
                }
            }
            catch (Exception e) {
                this.logger.error(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBSERVER, (Throwable)e);
                this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBSERVER, null);
                monitor.worked(1);
                monitor.done();
            }
        }
        finally {
            monitor.worked(1);
            monitor.done();
        }
    }

    protected void launchApplicationWithGDBClient(ILaunch launch, ILaunchConfiguration config, IBinaryParser.IBinaryObject exeFile, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask("", 2);
            monitor.subTask(TizenLaunchMessages.LAUNCH_APPLICATION_WITH_GDBCLIENT);
            IDebugCommandProvider iDebugCommandProvider = LauncherInstances.getDebugCommandProvider();
            if (iDebugCommandProvider != null) {
                iDebugCommandProvider.createForward(config, this.currentDevice);
            }
            String appPath = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
            IPath programPath = null;
            IRunCommandProvider iRunCommandProvider = LauncherInstances.getRunCommandProvider();
            if (iRunCommandProvider == null) {
                return;
            }
            programPath = this.getDebugHostPath(this.target, appPath);
            try {
                ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
                wc.setAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", programPath.toOSString());
                wc.doSave();
                super.launch(config, "debug", launch, monitor);
                GdbLaunch gdbLaunch = (GdbLaunch)launch;
                this.debugSession = gdbLaunch.getSession();
            }
            catch (Exception e) {
                this.newCoreException(TizenLaunchMessages.CANNOT_LAUNCH_APPLICATION_WITH_GDBCLIENT, e);
            }
        }
        finally {
            monitor.worked(2);
            monitor.done();
        }
    }

    private IPath getDebugHostPath(PkgCommandTarget target, String exePath) {
        Path path = new Path(target.getRootstrap().getPath());
        if (target.getRootstrapCommander() == null) {
            return new Path(exePath);
        }
        String canonicalPath = target.getRootstrapCommander().canonicalizePath(exePath);
        String rootstrapPath = SmartBuildInterface.getInstance().getPlatformRootstrapPath((IPath)path);
        if (rootstrapPath != null && !rootstrapPath.isEmpty()) {
            rootstrapPath = canonicalPath != null && !canonicalPath.isEmpty() ? rootstrapPath.concat(String.valueOf(File.separator) + "usr" + File.separator + "lib" + File.separator + "debug" + File.separator).concat(canonicalPath).concat(".debug") : rootstrapPath.concat("usr" + File.separator + "lib" + File.separator + "debug" + File.separator).concat(exePath).concat(".debug");
        }
        return new Path(rootstrapPath);
    }

    protected void verifyGDBServerRun(IDevice device) throws CoreException {
        SdbCommand sdbCommand = new SdbCommand(device, null, null);
        String output = sdbCommand.returnExecuteCommand(CHECK_RUNNING_GDBSERVER);
        if (output == null || StringUtil.isEmpty((CharSequence)output) || !output.contains("gdbserver")) {
            LaunchUtils.newCoreException((String)TizenLaunchMessages.GDBSERVER_NOT_FOUND, null);
            this.logger.error(TizenLaunchMessages.GDBSERVER_NOT_FOUND);
        }
    }

    protected String getGdbserverRunCommand(ILaunchConfiguration config) throws CoreException, Exception {
        String gdbserverPort = LaunchUtils.getGdbserverPort((ILaunchConfiguration)config);
        String gdbserverCmd = String.valueOf(TizenPlatformConstants.GDBSERVER_PLATFORM_CMD) + " :" + gdbserverPort;
        String execArg = this.getArguments(config);
        String envCmd = this.getEnvironments(config);
        String command = String.valueOf(envCmd) + gdbserverCmd + " " + execArg;
        return command;
    }

    protected void setDebugConfigAttributes(ILaunchConfiguration config) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        wc.setAttribute("org.eclipse.cdt.launch.DEBUGGER_START_MODE", "remote");
        wc.doSave();
    }

    protected int getDebugPort() {
        int debugPortBase = -1;
        debugPortBase = this.currentDevice.isEmulator() ? 26102 : 26202;
        int port = debugPortBase;
        while (port < 65535 && !LocalPortChecker.isPortAvailable((int)port)) {
            port += 10;
        }
        if (LocalPortChecker.isPortAvailable((int)port)) {
            return port;
        }
        return -1;
    }

    protected String[] getEnvironment(ILaunchConfiguration config) throws CoreException {
        try {
            Map map = config.getAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
            ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
            if (map != null) {
                wc.setAttribute(ILaunchManager.ATTR_ENVIRONMENT_VARIABLES, map);
                wc.setAttribute("org.eclipse.cdt.launch.ENVIRONMENT_MAP", null);
                config = wc.doSave();
            }
            boolean append = config.getAttribute("org.eclipse.cdt.launch.ENVIRONMENT_INHERIT", true);
            wc.setAttribute(ILaunchManager.ATTR_APPEND_ENVIRONMENT_VARIABLES, append);
        }
        catch (CoreException coreException) {}
        String[] array = DebugPlugin.getDefault().getLaunchManager().getEnvironment(config);
        if (array == null) {
            return new String[0];
        }
        return array;
    }

    protected String getEnvironments(ILaunchConfiguration config) throws Exception {
        String[] envArray;
        String envs = "";
        String[] stringArray = envArray = this.getEnvironment(config);
        int n = envArray.length;
        int n2 = 0;
        while (n2 < n) {
            String env = stringArray[n2];
            envs = String.valueOf(envs) + "export " + env + " && ";
            ++n2;
        }
        return envs;
    }

    protected String getArguments(ILaunchConfiguration config) throws CoreException {
        String appPath = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        String arguments = org.eclipse.cdt.launch.LaunchUtils.getProgramArguments((ILaunchConfiguration)config);
        String executableWithArguments = "";
        executableWithArguments = arguments != null && !arguments.equals("") ? String.valueOf(appPath) + " " + arguments : appPath;
        return executableWithArguments;
    }

    protected void activateProgressView() {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.eclipse.ui.views.ProgressView");
                }
                catch (PartInitException e) {
                    PlatformLaunchDelegate.this.logger.error("failed to activate ProgressView", (Throwable)e);
                }
            }
        });
    }

    protected void newCoreException(String message, Throwable exception) throws CoreException {
        this.isLaunchFailed = true;
        Status status = new Status(4, "org.tizen.nativeplatform", message, exception);
        throw new CoreException((IStatus)status);
    }

    protected void refreshResources(IProject project) throws CoreException {
        if (!project.isSynchronized(2)) {
            project.refreshLocal(2, null);
        }
    }

    protected IBinaryParser.IBinaryObject getBinaryObject(ILaunchConfiguration config) throws CoreException {
        String appPath = config.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        IRunCommandProvider iRunCommandProvider = LauncherInstances.getRunCommandProvider();
        if (iRunCommandProvider == null) {
            return null;
        }
        IPath hostPath = iRunCommandProvider.getBinaryHostPath(this.target, appPath);
        ICProject cproject = CDebugUtils.verifyCProject((ILaunchConfiguration)config);
        IBinaryParser.IBinaryObject binaryObject = org.eclipse.cdt.launch.LaunchUtils.getBinary((IProject)cproject.getProject(), (IPath)hostPath);
        return binaryObject;
    }

    protected IProject getProject(ILaunchConfiguration config) throws CoreException {
        String projectName = config.getAttribute("org.eclipse.cdt.launch.PROJECT_ATTR", "");
        if (projectName == null || projectName.equals("")) {
            this.newCoreException(PlatformLaunchMessages.CANNOT_FIND_PROJECT_NAME, null);
        }
        return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
    }

    protected boolean openPkgStatusDialog(final List<PkgStatus> buildSystemPkgStatus, final List<PkgStatus> devicePkgStatus) {
        SWTUtil.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ShowPackageStatusDialog statusDlg = new ShowPackageStatusDialog(PlatformLaunchDelegate.this.shell, buildSystemPkgStatus, devicePkgStatus);
                if (statusDlg.open() == 0) {
                    PlatformLaunchDelegate.this.result = true;
                } else {
                    PlatformLaunchDelegate.this.result = false;
                }
            }
        });
        return this.result;
    }

    protected File getGDBClientArgument(IBinaryParser.IBinaryObject exeFile) {
        return exeFile.getPath().toFile();
    }

    protected boolean isSetProgramPath(ILaunchConfiguration wc) throws CoreException {
        String path = wc.getAttribute("org.eclipse.cdt.launch.PROGRAM_NAME", "");
        return !path.isEmpty();
    }

    protected void setPkgCommandTarget() {
        this.target = new PkgCommandTarget(PlatformProjectUtil.getPkgType(), this.currentDevice, this.rootstrap);
    }

    protected void checkCancelProcess(IProgressMonitor monitor) throws CoreException {
        if (monitor.isCanceled()) {
            this.newCoreException(PlatformLaunchMessages.CANCELED_LAUNCH, null);
        }
    }
}

