/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.tizen.common.util.log.UserLogger;
import org.tizen.nativeplatform.IRootstrapManagerProxy;
import org.tizen.nativeplatform.model.Architecture;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.rootstrap.CommonRootstrapManager;
import org.tizen.nativeplatform.rootstrap.IRootstrapManager;
import org.tizen.nativeplatform.rootstrap.RootstrapInstances;
import org.tizen.nativeplatform.rootstrap.util.SnapshotParser;
import org.tizen.sbilib.ide.PluginManager;

public class RootstrapManagerProxy
implements IRootstrapManagerProxy {
    public void addRootstrap(PlatformRootstrap rootstrap) {
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        if (iRootstrapManager != null) {
            iRootstrapManager.addRootstrap(rootstrap);
            PluginManager pm = PluginManager.getInstance();
            if (pm != null) {
                pm.reInit();
            }
        }
    }

    public List<PlatformRootstrap> getRootstraps(int listType) {
        return CommonRootstrapManager.getRootstraps(listType);
    }

    public List<PlatformRootstrap> getRootstraps() {
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        return iRootstrapManager != null ? iRootstrapManager.getRootstraps() : null;
    }

    public PlatformRootstrap getRootstrap(String id) {
        return CommonRootstrapManager.getRootstrap(id);
    }

    public boolean existsRootstrap(String id) {
        return CommonRootstrapManager.existsRootstrap(id);
    }

    public void updateRootstrap(PlatformRootstrap rootstrap) {
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        if (iRootstrapManager != null) {
            iRootstrapManager.updateRootstrap(rootstrap);
        }
    }

    public boolean checkInitialized(String rootId) {
        return CommonRootstrapManager.checkInitialized(rootId);
    }

    public PlatformRootstrap getSelectedRootstrap() {
        return CommonRootstrapManager.getSelectedRootstrap();
    }

    public void removeLatestTempDirForRootstrap() {
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        if (iRootstrapManager != null) {
            iRootstrapManager.removeLatestTempDirForRootstrap();
        }
    }

    public PlatformRootstrap generate(String name, String arch, String version, List<Repository> reposURLs, boolean immediateGen, IPath confFile, IProgressMonitor monitor) throws InterruptedException {
        UserLogger.start((String)"gen.rootstrap");
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        if (iRootstrapManager != null) {
            PlatformRootstrap rootstrap = iRootstrapManager.generateRootstrap(name, arch, version, reposURLs, immediateGen, confFile, monitor);
            UserLogger.end((String)"gen.rootstrap");
            return rootstrap;
        }
        return null;
    }

    public boolean checkInitialized(PlatformRootstrap rootstrap) {
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        return iRootstrapManager != null ? iRootstrapManager.checkInitialized(rootstrap) : false;
    }

    public List<String> getRpmFiles(PlatformRootstrap rootstrap) {
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        return iRootstrapManager != null ? iRootstrapManager.getRpmFiles(rootstrap) : null;
    }

    public List<String> getXmlFiles(PlatformRootstrap rootstrap) {
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        return iRootstrapManager != null ? iRootstrapManager.getXmlFiles(rootstrap) : null;
    }

    public String getRootstrapLocalPath(PlatformRootstrap rootstrap) {
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        return iRootstrapManager != null ? iRootstrapManager.getRootstrapLocalPath(rootstrap) : null;
    }

    public void winCacheModificationTime(PlatformRootstrap rootstrap) {
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        if (iRootstrapManager != null) {
            iRootstrapManager.winCacheModificationTime(rootstrap);
        }
    }

    public void winSyncronizeIfChanges(PlatformRootstrap rootstrap, IProgressMonitor monitor) {
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        if (iRootstrapManager != null) {
            iRootstrapManager.winSyncronizeIfChanges(rootstrap, monitor);
        }
    }

    public void winSyncronize(PlatformRootstrap rootstrap, IProgressMonitor monitor) {
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        if (iRootstrapManager != null) {
            iRootstrapManager.winSyncronize(rootstrap, monitor);
        }
    }

    public boolean generateRootstrap(PlatformRootstrap rootstrap, IProgressMonitor monitor) throws InterruptedException {
        IRootstrapManager iRootstrapManager = RootstrapInstances.getRootstrapManager();
        return iRootstrapManager != null ? iRootstrapManager.generateRootstrap(rootstrap, monitor) : false;
    }

    public List<Architecture> parseSnapshotURL(String url, IProgressMonitor monitor) {
        ArrayList<Architecture> infos = new ArrayList<Architecture>();
        infos.addAll(SnapshotParser.parsePkgUrl(url, monitor));
        return infos;
    }

    public List<Architecture> parseRepositoryURL(String url, IProgressMonitor monitor) {
        ArrayList<Architecture> infos = new ArrayList<Architecture>();
        infos.addAll(SnapshotParser.parsePkgUrl2(url, monitor));
        return infos;
    }
}

