/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.rootstrap.wizard;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.IPageChangedListener;
import org.eclipse.jface.dialogs.PageChangedEvent;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.ui.view.console.ConsoleManager;
import org.tizen.common.util.DialogUtil;
import org.tizen.nativeplatform.command.launcher.HostCommandLauncher;
import org.tizen.nativeplatform.model.PlatformRootstrap;
import org.tizen.nativeplatform.repo.commander.RepoManager;
import org.tizen.nativeplatform.repo.model.Repository;
import org.tizen.nativeplatform.rootstrap.RootstrapInstances;
import org.tizen.nativeplatform.rootstrap.RootstrapListenerManager;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapSettingPage2;
import org.tizen.nativeplatform.rootstrap.wizard.RootstrapWizardData;
import org.tizen.nativeplatform.util.GBSArchitectureChecker;

public class RootstrapModifyRepoWizard
extends Wizard
implements IPageChangedListener {
    protected Shell shell;
    protected PlatformRootstrap generatedRootstrap;
    PlatformRootstrap selectedRootstrap = null;
    protected RootstrapSettingPage2 page2 = null;
    protected final String BUNDLE_NAME = String.valueOf(RootstrapModifyRepoWizard.class.getPackage().getName()) + ".RootstrapWizardUIMessages";
    protected ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);

    public RootstrapModifyRepoWizard(Shell shell, PlatformRootstrap selectedRootstrap) {
        this.shell = shell;
        RootstrapWizardData.clearData();
        this.selectedRootstrap = selectedRootstrap;
        RootstrapWizardData.addArchString("armv7l");
        RootstrapWizardData.addArchString("i586");
    }

    public void addPages() {
        this.page2 = new RootstrapSettingPage2("modify a rootstrap", this.shell, this.selectedRootstrap);
        this.addPage((IWizardPage)this.page2);
        WizardDialog dialog = (WizardDialog)this.getContainer();
        dialog.addPageChangedListener((IPageChangedListener)this);
    }

    public boolean performFinish() {
        List<String> repositoryURLs;
        List repoURLs;
        String arch;
        String rootstrapName = RootstrapWizardData.getRootstrapName();
        boolean result = this.modifyRootstrap(rootstrapName, arch = GBSArchitectureChecker.changeToSupportedArchitecture((String)RootstrapWizardData.getRootstrapArch()), repoURLs = RepoManager.createRepoList(repositoryURLs = RootstrapWizardData.getRepositories()));
        if (result) {
            RootstrapListenerManager.updateRootstrapDescription(this.generatedRootstrap);
        }
        return result;
    }

    private boolean modifyRootstrap(final String name, final String arch, final List<Repository> repoURLs) {
        RootstrapInstances.getRootstrapManager().removeRootstrap(this.selectedRootstrap.getId());
        IWizardContainer container = this.getContainer();
        try {
            try {
                container.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(RootstrapModifyRepoWizard.this.resources.getString("Wizard.Msg.Gen"), -1);
                        HostCommandLauncher.addConsoleListener((ConsoleManager)RootstrapWizardData.getConsoleMgr());
                        RootstrapModifyRepoWizard.this.generatedRootstrap = RootstrapInstances.getRootstrapManager().generateRootstrap(name, arch, "1.0", repoURLs, false, null, monitor);
                        if (RootstrapModifyRepoWizard.this.generatedRootstrap == null) {
                            throw new InterruptedException(RootstrapModifyRepoWizard.this.resources.getString("Wizard.Error.CheckLog"));
                        }
                        RootstrapInstances.getRootstrapManager().afterGenRootstrap(RootstrapModifyRepoWizard.this.generatedRootstrap, false, monitor);
                    }
                });
            }
            catch (Exception e) {
                DialogUtil.openErrorDialog((String)(String.valueOf(this.resources.getString("Wizard.Error.Gen")) + "\n" + e.getMessage()));
                RootstrapInstances.getRootstrapManager().removeLatestTempDirForRootstrap();
                HostCommandLauncher.removeConsoleListener((ConsoleManager)RootstrapWizardData.getConsoleMgr());
                return false;
            }
        }
        finally {
            RootstrapInstances.getRootstrapManager().removeLatestTempDirForRootstrap();
            HostCommandLauncher.removeConsoleListener((ConsoleManager)RootstrapWizardData.getConsoleMgr());
        }
        RootstrapInstances.getRootstrapManager().addRootstrap(this.generatedRootstrap);
        if (RootstrapWizardData.getConsoleMgr() != null) {
            RootstrapWizardData.getConsoleMgr().removeConsole();
        }
        return true;
    }

    public void pageChanged(PageChangedEvent event) {
        WizardPage selectedPage = (WizardPage)event.getSelectedPage();
        RootstrapSettingPage2 page = (RootstrapSettingPage2)selectedPage;
        page.updatePageForRemoteRepo();
    }
}

