/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.pkgmgr.ui;

import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.osgi.framework.Bundle;
import org.tizen.nativeplatform.pkg.model.PkgInfo;
import org.tizen.nativeplatform.pkgmgr.ui.PkgDependencyTab;
import org.tizen.nativeplatform.pkgmgr.ui.PkgDescriptionTab;
import org.tizen.nativeplatform.pkgmgr.ui.PkgInstalledFilesTab;
import org.tizen.nativeplatform.pkgmgr.ui.PropertiesCommonTab;

public class PkgPropertiesDialog
extends Dialog {
    private TabFolder tabFolder;
    private PkgInfo pkgInfo;
    private int tabIndex = 0;
    private int x = 0;
    private int y = 0;
    private final int width = 400;
    private final int height = 400;
    private final String BUNDLE_NAME = String.valueOf(PkgPropertiesDialog.class.getPackage().getName()) + ".PkgMgrUIMessages";
    private ResourceBundle resources = ResourceBundle.getBundle(this.BUNDLE_NAME);

    public PkgPropertiesDialog(Shell parentShell, PkgInfo pkgInfo) {
        super(parentShell);
        this.pkgInfo = pkgInfo;
        Rectangle bounds = parentShell.getBounds();
        this.x = bounds.x + (bounds.width - 400) / 2;
        this.y = bounds.y + (bounds.height - 400) / 2;
    }

    private void setImage(Shell parentShell) {
        Bundle bundle = Platform.getBundle((String)"org.tizen.nativeplatform");
        try {
            parentShell.setImage(new Image((Device)Display.getCurrent(), FileLocator.toFileURL((URL)bundle.getEntry("icons/package_installer.gif")).getPath()));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void setShellStyle(int newShellStyle) {
        int newStyle = newShellStyle;
        super.setShellStyle(newStyle |= 0);
    }

    public boolean close() {
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.CLOSE_LABEL, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.resources.getString("PropDlg.Title"));
        newShell.setLocation(this.x, this.y);
        newShell.setSize(400, 400);
        this.setImage(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(1808));
        container.setLayout((Layout)new GridLayout(1, false));
        this.createTabs(container);
        return null;
    }

    private void createTabs(Composite parent) {
        this.tabFolder = new TabFolder(parent, 2048);
        this.tabFolder.setLayoutData((Object)new GridData(1808));
        this.tabFolder.setLayout((Layout)new GridLayout(1, false));
        PropertiesCommonTab propTab = new PropertiesCommonTab(this.getShell(), this.tabFolder, this.pkgInfo);
        propTab.createTab();
        PkgDependencyTab depTab = new PkgDependencyTab(this.getShell(), this.tabFolder, this.pkgInfo);
        depTab.createTab();
        if (!this.pkgInfo.getInstalledFileList().isEmpty()) {
            PkgInstalledFilesTab filesTab = new PkgInstalledFilesTab(this.getShell(), this.tabFolder, this.pkgInfo);
            filesTab.createTab();
        }
        PkgDescriptionTab descTab = new PkgDescriptionTab(this.getShell(), this.tabFolder, this.pkgInfo);
        descTab.createTab();
        this.tabFolder.setSelection(this.tabIndex);
    }
}

