/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.nativeplatform.preferences;

public class ProxyURLParser {
    private static final String DELIMITER_PROTOCOL = "://";
    private static final String DELIMITER_HOST = ":";
    private static final String SOCKS_PROXY_TYPE = "SOCKS".toLowerCase();
    private static final String HTTP_PROXY_TYPE = "HTTP".toLowerCase();
    private static final String HTTPS_PROXY_TYPE = "HTTPS".toLowerCase();
    public static final int PROXY_TYPE = 0;
    public static final int PROXY_HOST = 1;
    public static final int PROXY_PORT = 2;

    public static String getType(String url) {
        return ProxyURLParser.getParsedUrl(url, 0);
    }

    public static String getHost(String url) {
        return ProxyURLParser.getParsedUrl(url, 1);
    }

    public static String getPort(String url) {
        return ProxyURLParser.getParsedUrl(url, 2);
    }

    public static String getParsedUrl(String url, int index) {
        String[] parsedUrl = ProxyURLParser.getParsedUrl(url);
        if (parsedUrl == null) {
            return null;
        }
        return parsedUrl[index];
    }

    public static String[] getParsedUrl(String url) {
        String[] parsedUrl = new String[]{"", "", ""};
        if (!ProxyURLParser.validate(url)) {
            return null;
        }
        String[] splited = url.split(DELIMITER_PROTOCOL);
        String type = splited[0].toLowerCase();
        String address = splited[1].toLowerCase();
        splited = address.split(DELIMITER_HOST);
        String host = splited[0];
        String port = ProxyURLParser.validatePort(splited[1]);
        parsedUrl[0] = type;
        parsedUrl[1] = host;
        parsedUrl[2] = port;
        return parsedUrl;
    }

    public static boolean validate(String url) {
        String[] splited = url.split(DELIMITER_PROTOCOL);
        if (splited.length != 2) {
            return false;
        }
        String type = splited[0].toLowerCase();
        if (!ProxyURLParser.validateProxyType(type)) {
            return false;
        }
        String address = splited[1];
        if ((splited = address.split(DELIMITER_HOST)).length != 2) {
            return false;
        }
        String port = ProxyURLParser.validatePort(splited[1]);
        return port != null;
    }

    private static String validatePort(String port) {
        char[] chArr;
        StringBuffer sbNewPort = new StringBuffer();
        char[] cArray = chArr = port.toCharArray();
        int n = chArr.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (Character.isDigit(c)) {
                sbNewPort.append(c);
            }
            ++n2;
        }
        return sbNewPort.toString();
    }

    private static boolean validateProxyType(String type) {
        return HTTPS_PROXY_TYPE.equals(type) || SOCKS_PROXY_TYPE.equals(type) || HTTP_PROXY_TYPE.equals(type);
    }
}

