/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.File;
import org.kohsuke.args4j.Argument;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.shell.AbstractCLI;

@TizenSubCommand(name="clean", usage="Clean a build output directory")
public class CleanCLI
extends AbstractCLI {
    @Argument(index=0, required=false, metaVar="<command>")
    String commandName;

    @Override
    public void execute() {
        File webProjectResult;
        File releaseBuildPath;
        File releaseBuildInfo;
        int clean_count = 0;
        if (this.help) {
            this.printUsage();
            return;
        }
        this.log.trace("Execute Clean...");
        File debugBuildPath = new File(this.getRealWorkingPath(), "Debug");
        File debugBuildInfo = new File(debugBuildPath, "build.info");
        if (debugBuildInfo.exists()) {
            if (this.deleteDirectory(debugBuildPath)) {
                ++clean_count;
                this.progressLog.info("native-app (Debug) clean success.");
            } else {
                this.progressLog.error("native-app (Debug) clean failed.");
                throw new UnexpectedException(2, "native-app (Debug) clean failed.");
            }
        }
        if ((releaseBuildInfo = new File(releaseBuildPath = new File(this.getRealWorkingPath(), "Release"), "build.info")).exists()) {
            if (this.deleteDirectory(releaseBuildPath)) {
                ++clean_count;
                this.progressLog.info("native-app (Release) clean success.");
            } else {
                this.progressLog.error("native-app (Release) clean failed.");
                throw new UnexpectedException(2, "native-app (Release) clean failed.");
            }
        }
        if ((webProjectResult = new File(this.getRealWorkingPath(), ".buildResult")).exists()) {
            if (this.deleteDirectory(webProjectResult)) {
                ++clean_count;
                this.progressLog.info("web-app clean success.");
            } else {
                this.progressLog.error("web-app clean failed.");
                throw new UnexpectedException(2, "web-app clean failed.");
            }
        }
        if (clean_count == 0) {
            this.progressLog.info("There is no directory to clean.");
        }
    }

    private boolean deleteDirectory(File path) {
        if (!path.exists()) {
            return false;
        }
        File[] files = path.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.isDirectory()) {
                    this.deleteDirectory(file);
                    continue;
                }
                file.delete();
            }
        }
        return path.delete();
    }
}

