/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.File;
import java.io.IOException;
import org.kohsuke.args4j.Option;
import org.tizen.common.project.util.ProjectValidationUtil;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.createnative.CreateNativeProjectCommand;
import org.tizen.ncli.subcommands.createnative.CreateNativeProjectCommandData;

@TizenSubCommand(name="native-project", usage="Create the tizen native project")
public class CreateNativeProjectCLI
extends AbstractCLI {
    @Option(name="--type", aliases={"-t"}, required=true, metaVar="predefined template name", usage="Specify template name. (Required)")
    private String templateName;
    @Option(name="--name", aliases={"-n"}, required=true, metaVar="project name", usage="Specify project name. (Required)")
    private String projectName;
    @Option(name="--profile", aliases={"-p"}, required=true, metaVar="profile name", usage="Specify profile name. (Required)")
    private String profileName;
    private static final String PACKAGE_NAME_PATTERN = "^[a-zA-Z][a-zA-Z0-9-\\._]{2,49}(?<![\\._\\-])$";

    @Override
    public void execute() {
        if (this.help) {
            this.printUsage();
            return;
        }
        CreateNativeProjectCommand nativeCommand = new CreateNativeProjectCommand();
        CreateNativeProjectCommandData data = nativeCommand.getData();
        if (this.profileName != null) {
            data.setProfileName(this.profileName);
        }
        if (this.templateName != null) {
            data.setTemplateName(this.templateName);
        }
        if (this.projectName != null) {
            boolean ret = this.IsValidProjectName();
            if (!ret) {
                throw new UnexpectedException(2, "invalid project name.");
            }
            data.setProjectName(this.projectName);
        }
        try {
            data.setOutputName(this.getRealWorkingPath().getCanonicalPath() + File.separatorChar + data.getProjectName());
            CreateNativeProjectCommandData finalData = (CreateNativeProjectCommandData)nativeCommand.runCommand();
            if (finalData != null) {
                this.progressLog.info("Project Location: {}", (Object)finalData.getOutputName());
            }
        }
        catch (IOException e) {
            this.log.error(TizenCLIMessages.CR_CANNOT_CREATE_OUTDIR);
            throw new UnexpectedException(2, TizenCLIMessages.CR_CANNOT_CREATE_OUTDIR);
        }
        catch (UnexpectedException e) {
            throw e;
        }
    }

    private boolean IsValidProjectName() {
        if (!ProjectValidationUtil.isValidNameLength((String)this.projectName)) {
            this.progressLog.info("Project naming rule : The project name must be longer than 2 characters");
            return false;
        }
        if (!ProjectValidationUtil.isValidName((String)this.projectName)) {
            this.progressLog.info("Project naming rule : Invalid character used in the project name");
            return false;
        }
        if (!this.projectName.matches(PACKAGE_NAME_PATTERN)) {
            this.progressLog.info("Package naming rule : The package name must start with an alphabetical character and can only contain letters or numbers.");
            return false;
        }
        return true;
    }
}

