/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.packages;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.Factory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.builder.Resource;
import org.tizen.common.builder.ResourceLayer;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.ExecutionContext;
import org.tizen.common.core.command.Executor;
import org.tizen.common.core.command.Policy;
import org.tizen.common.core.command.Prompter;
import org.tizen.common.core.command.policy.PolicyRegistry;
import org.tizen.common.core.command.prompter.NopPrompter;
import org.tizen.common.core.command.zip.ZipCommand;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.Filter;
import org.tizen.common.file.IResource;
import org.tizen.common.file.SimpleFileFilter;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.file.VirtualFileHandler;
import org.tizen.common.file.filter.WildCardFilterFactory;
import org.tizen.common.sign.command.ReadSigningProfileFileCommand;
import org.tizen.common.sign.command.SignCommand;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.util.CollectionUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.StringUtil;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.core.CommandLineExecutor;
import org.tizen.ncli.core.ConsolePrompter;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.packages.PackageCLICommandData;
import org.tizen.ncli.subcommands.packages.PackageWebWidgetCommand;
import org.tizen.ncli.subcommands.packages.WebProject;
import org.w3c.dom.Document;

public class PackageCLICommand
extends AbstractSubCommand<PackageCLICommandData> {
    protected FileHandler fileHandler = new StandardFileHandler();
    protected String projectPath;
    protected String projectName;
    protected String wgtPath = null;
    protected static final String TIZEN_WEB_CONFIG_FILE = "config.xml";
    protected static final String SIGNATURE_FILE = "signature1.xml";
    protected static final String AUTHOR_SIGNATURE_FILE = "author-signature.xml";
    protected static final String BUILD_RESULT_DIR = ".buildResult";
    protected PackageCLICommandData data = new PackageCLICommandData();
    protected SimpleFileFilter filter = new SimpleFileFilter(true);
    protected FactoryWithArgument<Filter, String> filterFactory = new WildCardFilterFactory();
    protected static final String RESOURCE_LAYER_START = "start";
    private String profilesPath;
    private String profileName;
    private Configuration config = new Configuration();
    private String configPath;
    private Document configDoc;
    private List<String> refPaths = null;

    @Override
    protected PackageCLICommandData call() {
        String authorFileName;
        String fileName;
        try {
            this.projectPath = this.workingDir.getCanonicalPath();
        }
        catch (IOException e) {
            this.log.error("Error occured during setting working directory", (Object)e.getMessage());
        }
        this.log.debug("Base project directory: {}", (Object)this.projectPath);
        this.configPath = this.findAndGetFileName(this.workingDir, TIZEN_WEB_CONFIG_FILE);
        if (this.configPath != null) {
            try {
                this.configDoc = WebProject.getDocument(this.configPath);
                if (this.configDoc == null) {
                    this.progressLog.error("Error config file is not exist");
                    return null;
                }
                this.projectName = WebProject.getProjectName(this.configDoc);
                if (this.projectName == null) {
                    this.progressLog.error("Error occured during getting project name from config file");
                    return null;
                }
            }
            catch (Exception e) {
                this.progressLog.error("Error occured during getting project config file", (Object)e.getMessage());
                return null;
            }
            if (WebProject.isWebWidgetProject(this.configDoc) || this.refPaths != null && !this.refPaths.isEmpty()) {
                PackageWebWidgetCommand cmd = new PackageWebWidgetCommand();
                cmd.setWorkingDir(this.workingDir);
                cmd.setProfileName(this.profileName);
                cmd.setReferencePaths(this.refPaths);
                cmd.setOutputPath(this.wgtPath);
                return (PackageCLICommandData)cmd.runCommand();
            }
        } else {
            this.progressLog.error(String.format("Not found tizen web project in %s", this.projectPath));
            return null;
        }
        if (this.wgtPath == null) {
            this.wgtPath = this.projectPath + File.separatorChar + this.projectName + "." + "wgt";
        }
        this.data.setWgtPath(this.wgtPath);
        this.log.debug("Widget path: {}", (Object)this.wgtPath);
        File wgtFile = new File(this.wgtPath);
        if (wgtFile.isFile()) {
            wgtFile.delete();
        }
        if (this.profileName != null) {
            this.profilesPath = this.config.getValue("profiles.path");
            if (this.profilesPath == null) {
                this.profilesPath = this.config.getValue("default.profiles.path");
            }
            if (this.sign() == -1) {
                return null;
            }
        }
        if ((fileName = this.findAndGetFileName(this.workingDir, SIGNATURE_FILE)) == null) {
            this.progressLog.info("Warning: Not found tizen signature file");
        }
        if ((authorFileName = this.findAndGetFileName(this.workingDir, AUTHOR_SIGNATURE_FILE)) == null) {
            this.progressLog.info("Warning: Not found tizen author signature file");
        }
        String[] excludes = this.getDefaultExcludes();
        this.log.debug("Excludes File Pattern: {}", (Object)CollectionUtil.toString((Object)excludes));
        this.progressLog.info("Excludes File Pattern: {}", (Object)CollectionUtil.toString((Object)excludes));
        ResourceLayer startLayer = new ResourceLayer(RESOURCE_LAYER_START, (FileHandler)new VirtualFileHandler());
        Resource[] resources = null;
        try {
            resources = this.getResources(this.projectPath, startLayer, null, excludes);
        }
        catch (IOException e) {
            this.log.error("Error occured during reading resource", (Object)e.getMessage());
            return null;
        }
        this.zipFiles(this.wgtPath, this.projectPath, resources);
        return this.data;
    }

    private int sign() {
        if (this.validateProfilesPath()) {
            CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
            ReadSigningProfileFileCommand readProfile = new ReadSigningProfileFileCommand(this.profilesPath, this.profileName);
            executor.execute(new Command[]{readProfile});
            this.log.info("Profiles file[{}] is read", (Object)this.profilesPath);
            SigningProfile profile = readProfile.getProfile();
            if (profile == null) {
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.SIGN_NO_PROFILES, (Object)this.profileName, (Object)this.profilesPath));
                return -1;
            }
            for (int i = 0; i <= 2; ++i) {
                SigningProfileItem item = profile.getProfileItem(i);
                if (item == null || StringUtil.isEmpty((CharSequence)item.getKeyLocation())) continue;
                String msg = i == 0 ? "Author certficate: " : "Distributor" + i + " certificate : ";
                this.progressLog.info(msg + item.getKeyLocation());
            }
            SignCommand command = new SignCommand(this.projectPath, profile);
            command.setIncludes(null);
            command.setExcludes(this.getDefaultExcludes());
            executor.execute(new Command[]{command});
            return 0;
        }
        return -1;
    }

    private boolean validateProfilesPath() {
        boolean result = false;
        if (this.profilesPath != null) {
            File profiles = new File(this.profilesPath);
            if (profiles.exists()) {
                result = true;
            } else {
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.SIGN_NO_PROFILES, (Object)this.profilesPath));
            }
        } else {
            this.progressLog.info(TizenCLIMessages.SIGN_NO_CONFIG_PROFILES);
        }
        return result;
    }

    public void setOutputPath(String wgtPath) {
        this.wgtPath = wgtPath;
    }

    public String getOutputPath() {
        return this.wgtPath;
    }

    public void setProfileName(String profile) {
        this.profileName = profile;
    }

    public void setReferencePaths(List<String> refPaths) {
        this.refPaths = refPaths;
    }

    public List<String> getReferencePaths() {
        return this.refPaths;
    }

    private String findAndGetFileName(File baseDir, String fileName) {
        File[] filesAndDirs = baseDir.listFiles();
        if (null == filesAndDirs) {
            return null;
        }
        for (File file : filesAndDirs) {
            String name = file.getName();
            if (!name.equals(fileName) || !file.isFile()) continue;
            return file.getAbsolutePath();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Resource[] getResources(String baseDir, ResourceLayer resourceLayer, String[] includes, String[] excludes) throws IOException {
        List files = FileUtil.findFiles((File)new File(baseDir), (String)".*", (boolean)true);
        ArrayList<Resource> resources = new ArrayList<Resource>();
        FileHandler fh = resourceLayer.getFileHandler();
        this.setIncludes(includes);
        this.setExcludes(excludes);
        for (File file : files) {
            String filePath = file.getPath();
            if (!FilenameUtil.equals((String)filePath, (String)baseDir) && !this.filter.accept(baseDir, FilenameUtil.getRelativePath((String)baseDir, (String)filePath))) {
                this.log.debug("Ignore File: {}", (Object)filePath);
                this.progressLog.info("Ignore File: {}", (Object)filePath);
                continue;
            }
            Resource resource = new Resource(resourceLayer, filePath);
            String dir = null;
            dir = file.isFile() ? file.getParent() : filePath;
            if (!fh.is(dir, FileHandler.Attribute.EXISTS)) {
                fh.makeDirectory(dir, true);
            }
            FileInputStream is = null;
            try {
                is = new FileInputStream(file);
                resource.setContents((InputStream)is);
                resources.add(resource);
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{is});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{is});
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    public void setIncludes(String[] includes) {
        this.filter.clearIncludes();
        if (null != includes) {
            for (String include : includes) {
                this.filter.addIncludes(new Filter[]{(Filter)this.filterFactory.create((Object)include)});
            }
        }
    }

    public void setExcludes(String[] excludes) {
        this.filter.clearExcludes();
        if (null != excludes) {
            for (String exclude : excludes) {
                this.filter.addExcludes(new Filter[]{(Filter)this.filterFactory.create((Object)exclude)});
            }
        }
    }

    private void zipFiles(String wgtPath, String baseDir, Resource[] resources) {
        ZipCommand command = new ZipCommand(baseDir, (IResource[])resources, wgtPath);
        Executor executor = new Executor((Factory)new Factory<ExecutionContext>(){

            public ExecutionContext create() {
                return new ExecutionContext(new PolicyRegistry(new Policy[0]), (Prompter)new NopPrompter(), PackageCLICommand.this.fileHandler);
            }
        });
        executor.execute(new Command[]{command});
    }

    protected boolean exists(String path) throws IOException {
        return this.fileHandler.is(path, FileHandler.Attribute.EXISTS);
    }

    protected boolean isValidRoot(String path) throws IOException {
        String projectFilePath = FilenameUtil.addTailingPath((String)path, (String)".project");
        return this.fileHandler.is(projectFilePath, FileHandler.Attribute.EXISTS);
    }

    protected String[] getDefaultExcludes() {
        return new String[]{".manifest.tmp", ".delta.lst"};
    }

    protected void zipFiles(String wgtPath, String baseDir) {
        this.zipFiles(wgtPath, baseDir, null);
    }
}

