/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.packages;

import java.io.File;
import java.util.ArrayList;
import org.tizen.core.gputil.XMLUtil;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WebProject {
    public static Document getDocument(String filePath) {
        File file = new File(filePath);
        return XMLUtil.readXML((File)file);
    }

    public static String getProjectName(Document doc) {
        String query = "/:widget/:name";
        NodeList nameNodeList = XMLUtil.getDOMNodesNS((Document)doc, (String)query);
        if (nameNodeList.item(0) != null) {
            return nameNodeList.item(0).getTextContent();
        }
        return null;
    }

    public static String[] getQueriedStringList(Document doc, String query) {
        NodeList nodeList = XMLUtil.getDOMNodesNS((Document)doc, (String)query);
        if (nodeList == null) {
            return new String[0];
        }
        String[] nodes = new String[nodeList.getLength()];
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i) == null) {
                nodes[i] = null;
                continue;
            }
            try {
                nodes[i] = nodeList.item(i).getTextContent();
                continue;
            }
            catch (DOMException e) {
                nodes[i] = null;
            }
        }
        return nodes;
    }

    public static String[] trimStringArray(String[] stringArray) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (String string : stringArray) {
            if (string == null || string == "") continue;
            stringList.add(string);
        }
        return stringList.toArray(new String[stringList.size()]);
    }

    public static String[] getTizenApplicationIdList(Document doc) {
        return WebProject.getQueriedStringList(doc, "/:widget/tizen:application/@id");
    }

    public static String getTizenApplicationId(Document doc) {
        String[] appIds = WebProject.trimStringArray(WebProject.getTizenApplicationIdList(doc));
        if (appIds.length == 0) {
            return null;
        }
        return appIds[0];
    }

    public static String[] getTizenAppWidgetIdList(Document doc) {
        return WebProject.getQueriedStringList(doc, "/:widget/tizen:app-widget/@id");
    }

    public static String[] getTizenServiceIdList(Document doc) {
        return WebProject.getQueriedStringList(doc, "/:widget/tizen:service/@id");
    }

    public static String getTizenAppWidgetId(Document doc) {
        String[] widgetIds = WebProject.trimStringArray(WebProject.getTizenAppWidgetIdList(doc));
        if (widgetIds.length == 0) {
            return null;
        }
        return widgetIds[0];
    }

    public static String getTizenServiceId(Document doc) {
        String[] serviceIds = WebProject.trimStringArray(WebProject.getTizenServiceIdList(doc));
        if (serviceIds.length == 0) {
            return null;
        }
        return serviceIds[0];
    }

    public static boolean isWebWidgetProject(Document doc) {
        String tizenApplicationId = WebProject.getTizenApplicationId(doc);
        if (tizenApplicationId == null) {
            return false;
        }
        String tizenAppWidgetId = WebProject.getTizenAppWidgetId(doc);
        return tizenAppWidgetId != null;
    }

    public static boolean isWebServiceProject(Document doc) {
        String tizenApplicationId = WebProject.getTizenApplicationId(doc);
        if (tizenApplicationId == null) {
            return false;
        }
        String tizenAppWidgetId = WebProject.getTizenServiceId(doc);
        return tizenAppWidgetId != null;
    }

    public static boolean isWebUIProject(Document doc) {
        String[] tizenApplicationIdList = WebProject.getTizenApplicationIdList(doc);
        if (tizenApplicationIdList.length != 1) {
            return false;
        }
        return !WebProject.isWebWidgetProject(doc) && !WebProject.isWebServiceProject(doc);
    }

    public static void removeTizenAppWidget(Document doc) {
        Node appwidget = XMLUtil.getDOMNodesNS((Document)doc, (String)"/:widget/tizen:app-widget").item(0);
        Node widget = XMLUtil.getDOMNodesNS((Document)doc, (String)"/:widget").item(0);
        widget.removeChild(appwidget);
    }

    public static void genWidgetConfig(Document doc, String targetPath) {
        String[] idList = WebProject.getTizenAppWidgetIdList(doc);
        String prefix = "/:widget/tizen:app-widget";
        String[] xPathList = new String[]{"tizen:widget-content/@src", "tizen:widget-content/tizen:widget-size/@preview"};
        for (String id : idList) {
            String widgetName = id.split("[.]")[2];
            for (String xPath : xPathList) {
                String query = prefix + "[@id = \"" + id + "\"]/" + xPath;
                String path = XMLUtil.getDOMValueNS((Document)doc, (String)query);
                File newPath = new File(targetPath + File.separator + "widget" + File.separator + widgetName + File.separator + path);
                if (path.split("[/]")[0] == "widget" || !newPath.exists()) continue;
                XMLUtil.setDOMValueNS((Document)doc, (String)query, (String)("widget/" + widgetName + "/" + path));
            }
        }
        String projectId = WebProject.getTizenApplicationId(doc);
        if (projectId != null) {
            for (String id : idList) {
                String widgetName = id.split("[.]")[2];
                String newId = projectId + "." + widgetName;
                String query = prefix + "[@id = \"" + id + "\"]/@id";
                XMLUtil.setDOMValueNS((Document)doc, (String)query, (String)newId);
            }
        }
        XMLUtil.writeToFile((Document)doc, (String)(targetPath + File.separator + "config.xml"));
    }

    public static void addWidgetToApp(Document app, Document widget) {
        Node appWidget = XMLUtil.getDOMNodeNS((Document)widget, (String)"/:widget/tizen:app-widget");
        Node appapp = XMLUtil.getDOMNodeNS((Document)app, (String)"/:widget");
        Node appapl = XMLUtil.getDOMNodeNS((Document)app, (String)"/:widget/tizen:application");
        appapp.insertBefore(app.importNode(appWidget, true), appapl);
    }
}

