/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.sign;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.osgi.util.NLS;
import org.kohsuke.args4j.Option;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.shell.AbstractSecurityProfileCLI;

@TizenSubCommand(name="list", usage="Show security profile names")
public class SecurityProfileListCLI
extends AbstractSecurityProfileCLI {
    @Option(name="--name", aliases={"-n"}, usage="Specified profile name for details.")
    private String name;

    @Override
    public void execute() {
        this.log.trace("Begin SecurityProfileListCLI...");
        if (this.help) {
            this.log.trace("Help mode is enabled.");
            this.printUsage();
            return;
        }
        File directory = this.getProfileXMLFile();
        if (directory == null) {
            this.progressLog.error("No exist the default path of security profiles.");
            throw new UnexpectedException(2, "No exist the default path of security profiles.");
        }
        SigningProfileContainer container = null;
        try {
            container = this.readXML(directory);
            this.log.trace("Read XML: {} profile found.", (Object)container.getProfiles().size());
            if (this.name == null) {
                this.printProfileList(container);
            } else {
                this.printProfileInformation(container);
            }
        }
        catch (FileNotFoundException e) {
            this.progressLog.error("Not found a file of security profiles. Please check specified path.");
            throw new UnexpectedException(2, "Not found a file of security profiles. Please check specified path.");
        }
        catch (UnexpectedException e) {
            throw e;
        }
        this.log.trace("Finish SecurityProfileListCLI...");
    }

    private void printProfileList(SigningProfileContainer container) {
        this.progressLog.info("========================================");
        this.progressLog.info("Name");
        this.progressLog.info("========================================");
        for (SigningProfile profile : container.getProfiles()) {
            this.progressLog.info("{}", (Object)profile.getProfileName());
        }
    }

    private void printProfileInformation(SigningProfileContainer container) {
        SigningProfile profile = container.getProfileByName(this.name);
        if (profile == null) {
            this.progressLog.error("There is no '{}' profile in security profiles. Please check the profile list by 'tizen security-profiles list' command.", (Object)this.name);
            throw new UnexpectedException(2, NLS.bind((String)"There is no '{}' profile in security profiles. Please check the profile list by 'tizen security-profiles list' command.", (Object)this.name));
        }
        this.progressLog.info("========================================");
        this.progressLog.info("'{}' profile information", (Object)this.name);
        this.progressLog.info("========================================");
        this.progressLog.info(this.buildInformation(profile));
    }
}

