/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.sign;

import java.io.File;
import java.io.FileNotFoundException;
import org.eclipse.osgi.util.NLS;
import org.kohsuke.args4j.Option;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileContainer;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.shell.AbstractSecurityProfileCLI;

@TizenSubCommand(name="remove", usage="Remove a security profile")
public class SecurityProfileRemoveCLI
extends AbstractSecurityProfileCLI {
    @Option(name="--name", aliases={"-n"}, required=true, usage="Specified profile name. (Required)")
    private String name;

    @Override
    public void execute() {
        this.log.trace("Begin SecurityProfileRemoveCLI...");
        if (this.help) {
            this.log.trace("Help mode is enabled.");
            this.printUsage();
            return;
        }
        File file = this.getProfileXMLFile();
        if (file == null) {
            this.progressLog.error("No exist the default path of security profiles.");
            throw new UnexpectedException(2, "No exist the default path of security profiles.");
        }
        SigningProfileContainer container = null;
        try {
            container = this.readXML(file);
            this.log.trace("Read XML: {} profile found.", (Object)container.getProfiles().size());
        }
        catch (FileNotFoundException e) {
            this.progressLog.error("Not found a file of security profiles. Please check specified path.");
            throw new UnexpectedException(2, "Not found a file of security profiles. Please check specified path.");
        }
        SigningProfile profile = container.getProfileByName(this.name);
        if (profile == null) {
            this.progressLog.error("There is no '{}' profile in security profiles. Please check the profile list by 'tizen security-profiles list' command.", (Object)this.name);
            throw new UnexpectedException(2, NLS.bind((String)"There is no '{}' profile in security profiles. Please check the profile list by 'tizen security-profiles list' command.", (Object)this.name));
        }
        try {
            boolean bRemoved = container.removeProfile(profile);
            if (bRemoved) {
                this.writeXML(container, file);
                this.progressLog.info("Succeed to remove '{}' profile.", (Object)this.name);
            } else {
                this.log.trace("Failed to remove a specified profile.");
            }
        }
        catch (FileNotFoundException e) {
            this.log.error(e.getMessage(), (Throwable)e);
            throw new UnexpectedException(2, e.getMessage());
        }
        this.log.trace("Finish SecurityProfileRemoveCLI...");
    }
}

