/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.target;

import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.sdb.command.SdbCommand;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.core.CLIConstant;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.target.ListApp;
import org.tizen.ncli.util.TargetUtil;
import org.tizen.sdblib.IDevice;

public class ListAppCLICommand
extends AbstractSubCommand<ListApp> {
    private Configuration config;
    private IDevice target = null;
    private String listAppCommand = TizenPlatformConstants.PKG_TOOL + " -l  -t %s";
    private static final String PKG_TYPE = "pkg_type";

    public ListAppCLICommand() {
        this.config = new Configuration();
    }

    @Override
    protected ListApp call() {
        if (this.target != null) {
            this.getAppList(CLIConstant.NATIVE_TPK_EXT);
            this.getAppList(CLIConstant.NATIVE_RPM_EXT);
            this.getAppList(CLIConstant.WEB_PKG_EXT);
        } else {
            this.progressLog.info(TizenCLIMessages.CANNOT_GET_TARGET);
        }
        return null;
    }

    public void setTarget(String targetName) {
        this.target = TargetUtil.getDefault().getTarget(targetName);
    }

    private void getAppList(String pkgtype) {
        this.log.trace("get app list");
        String result = null;
        String listAppCmd = String.format(this.listAppCommand, pkgtype);
        String defaultTimeout = this.config.getValue("default.sdb.timeout");
        int timeout = defaultTimeout == null ? 60000 : Integer.parseInt(defaultTimeout);
        this.log.debug("[List App]: " + listAppCmd);
        SdbCommand sdbCommand = new SdbCommand(this.target, null, null, timeout);
        result = sdbCommand.returnExecuteCommand(listAppCmd);
        this.setAppList(result);
    }

    private void setAppList(String returnExecute) {
        String[] lines;
        for (String line : lines = returnExecute.split("\n")) {
            if (!line.startsWith(PKG_TYPE)) continue;
            this.progressLog.info(line);
        }
    }
}

