/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.command;

import java.util.regex.Pattern;
import org.tizen.sdblib.command.Matcher;
import org.tizen.sdblib.receiver.MultiLineReceiver;

public class PatternExtractor
extends MultiLineReceiver
implements Matcher<String> {
    protected final Pattern pattern;
    protected final String replacement;
    protected String result;

    public PatternExtractor(String regexp) {
        this(regexp, "$1");
    }

    public PatternExtractor(String regexp, String replacement) {
        this(Pattern.compile(regexp), replacement);
    }

    public PatternExtractor(Pattern pattern, String replacement) {
        this.pattern = pattern;
        this.replacement = replacement;
    }

    @Override
    public void processNewLines(String[] lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            java.util.regex.Matcher matcher = this.pattern.matcher(line);
            if (matcher.find()) {
                this.result = matcher.replaceAll(this.replacement);
                return;
            }
            ++n2;
        }
    }

    @Override
    public String getResult() {
        return this.result;
    }
}

