/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.web;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.FactoryWithArgument;
import org.tizen.common.builder.BuildProcess;
import org.tizen.common.builder.IBuilder;
import org.tizen.common.builder.Resource;
import org.tizen.common.builder.ResourceLayer;
import org.tizen.common.builder.core.CopyBuilder;
import org.tizen.common.builder.exception.BuildException;
import org.tizen.common.core.web.BuildWebParameter;
import org.tizen.common.core.web.NullProgressMonitor;
import org.tizen.common.core.web.ProgressMonitor;
import org.tizen.common.file.FileHandler;
import org.tizen.common.file.Filter;
import org.tizen.common.file.IResource;
import org.tizen.common.file.SimpleFileFilter;
import org.tizen.common.file.StandardFileHandler;
import org.tizen.common.file.VirtualFileHandler;
import org.tizen.common.file.filter.WildCardFilterFactory;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.FilenameUtil;
import org.tizen.web.builder.CSSMinifyBuilder;
import org.tizen.web.builder.FontProjectBuilder;
import org.tizen.web.builder.HybridAppCLIBuilder;
import org.tizen.web.builder.JSMinifyBuilder;
import org.tizen.web.builder.UIFWBuilder;
import org.tizen.web.common.WebConstant;

public class BuildWebAppModule {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private BuildWebParameter data;
    private String cwd;
    private String output = ".buildResult";
    private SimpleFileFilter filter = new SimpleFileFilter(true);
    public FactoryWithArgument<Filter, String> filterFactory = new WildCardFilterFactory();
    public List<String> excludes = new ArrayList<String>();
    private String[] DEFAULT_EXCLUDES = WebConstant.DEFAULT_EXCLUDING_RESOURCES;
    private String[] EXTRA_EXCLUDES = new String[]{"*.wgt", ".tizen-ui-builder-tool.xml"};
    private ProgressMonitor monitor = new NullProgressMonitor();
    private boolean force = false;
    private static final String BUILD_WEB_TASK = "Build Web Application";

    public BuildWebAppModule() {
    }

    public BuildWebAppModule(BuildWebParameter data, String cwd, String output, SimpleFileFilter filter, FactoryWithArgument<Filter, String> filterFactory, List<String> excludes) {
        this.data = data;
        this.cwd = cwd;
        this.output = output;
        this.filter = filter;
        this.filterFactory = filterFactory;
        this.excludes = excludes;
    }

    public void setCwd(String cwd) {
        this.cwd = cwd;
    }

    public void setData(BuildWebParameter data) {
        this.data = data;
    }

    public void setMonitor(ProgressMonitor monitor) {
        this.monitor = monitor;
    }

    public void buildResources() throws IOException, BuildException, Exception {
        BuildProcess buildProcess = new BuildProcess();
        this.monitor.beginTask(BUILD_WEB_TASK, 10);
        this.checkPrerequisit(this.force);
        this.output = null != this.data && null != this.data.getOutputName() ? this.cwd + File.separator + this.data.getOutputName() : this.cwd + File.separator + this.output;
        this.data.setOutputName(this.output);
        this.deleteOutput();
        this.addDefaultExclude();
        this.monitor.update(1);
        StandardFileHandler fh = new StandardFileHandler();
        fh.setCurrentWorkingDirectory(this.cwd);
        ResourceLayer startLayer = new ResourceLayer("Initial Resource Layer", (FileHandler)fh);
        Resource[] resources = null;
        resources = this.getBuildResources(startLayer);
        this.log.trace("==!! Get Build Resources !!==");
        if (null != resources) {
            this.log.trace("Total resource count: {}", (Object)resources.length);
        }
        this.generateAllBuilders(buildProcess);
        if (buildProcess.getLastBuilder() != null) {
            this.log.debug("start build process");
            this.monitor.update(1);
            buildProcess.build((IResource[])resources);
            this.monitor.update(2);
            this.checkHybridStructure(buildProcess);
        }
        this.monitor.endTask();
    }

    private void checkPrerequisit(boolean force) throws BuildException {
        if (null != this.cwd && !"".equals(this.cwd.trim())) {
            this.log.trace("Exist config.xml? {}", (Object)FileUtil.isExist((String)(this.cwd + "/config.xml")));
            if (!force && !FileUtil.isExist((String)(this.cwd + "/config.xml"))) {
                this.log.trace(this.cwd + "/config.xml is not exist!");
                throw new BuildException((Throwable)new Exception("The specified directory(" + this.cwd + ") is not vaild"));
            }
        } else {
            throw new BuildException((Throwable)new Exception("Current working directory should be set!"));
        }
    }

    private void deleteOutput() {
        if (FileUtil.isExist((String)this.output)) {
            FileUtil.recursiveDelete((File)new File(this.output));
        }
    }

    private void addDefaultExclude() {
        if (null == this.data) {
            this.data = new BuildWebParameter();
        }
        for (String defaultExclude : this.DEFAULT_EXCLUDES) {
            this.log.trace("add exclude:{}", (Object)defaultExclude);
            this.data.getExcludeList().add(defaultExclude);
        }
        for (String extraExclude : this.EXTRA_EXCLUDES) {
            this.log.trace("add exclude:{}", (Object)extraExclude);
            this.data.getExcludeList().add(extraExclude);
        }
    }

    private boolean isPrerequisiteSatisfy() {
        boolean ret;
        boolean bl = ret = null != this.cwd && !"".equals(this.cwd.trim());
        if (ret) {
            this.log.trace("Exist config.xml? {}", (Object)FileUtil.isExist((String)(this.cwd + "/config.xml")));
            ret = FileUtil.isExist((String)(this.cwd + "/config.xml"));
        }
        return ret;
    }

    private List<Resource> getResources(String cwd, String relativeSrcDir, ResourceLayer layer) throws IOException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        List files = null;
        String absoluteDir = cwd + File.separator + relativeSrcDir;
        files = FileUtil.findFiles((File)new File(absoluteDir), (String)".*", (boolean)true);
        for (File file : files) {
            String fileRelativePath = FilenameUtil.getRelativePath((String)cwd, (String)file.getCanonicalPath());
            if (!FilenameUtil.equals((String)file.getCanonicalPath(), (String)this.cwd) && !this.filter.accept(cwd, fileRelativePath)) {
                this.log.debug("Ignore {}", (Object)fileRelativePath);
                continue;
            }
            this.log.debug("resource path : {}", (Object)fileRelativePath);
            Resource resource = new Resource(layer, fileRelativePath);
            resources.add(resource);
        }
        return resources;
    }

    private Resource[] getBuildResources(ResourceLayer layer) throws IOException {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        this.setExcludes(this.data.getExcludeList());
        this.log.trace("CWD:{}", (Object)this.cwd);
        String cwd = layer.getFileHandler().getCurrentWorkingDirectory();
        this.monitor.update(1);
        resources.addAll(this.getResources(cwd, FilenameUtil.getRelativePath((String)cwd, (String)cwd), layer));
        this.monitor.update(2);
        return resources.toArray(new Resource[resources.size()]);
    }

    public void generateAllBuilders(BuildProcess buildProcess) throws IOException {
        VirtualFileHandler fh = new VirtualFileHandler();
        fh.setCurrentWorkingDirectory(this.cwd);
        if (null != this.data && this.data.isExcludeUIFW()) {
            this.addUIFWBuilder(true, true, buildProcess, (FileHandler)fh);
        }
        this.monitor.update(1);
        if (null != this.data && this.data.hasReference()) {
            this.addHybridBuilder(buildProcess, (FileHandler)fh);
        }
        this.monitor.update(1);
        if (null != this.data && this.data.isOptimize()) {
            this.addOptimizingBuilders(buildProcess, (FileHandler)fh);
        }
        buildProcess.addBuilders(new IBuilder[]{new FontProjectBuilder(this.cwd, (FileHandler)fh)});
        this.addLastbuilder(buildProcess);
        this.monitor.update(1);
    }

    private void addOptimizingBuilders(BuildProcess buildProcess, FileHandler fh) {
        if (buildProcess == null) {
            return;
        }
        JSMinifyBuilder jsMin = new JSMinifyBuilder(fh);
        buildProcess.addBuilders(new IBuilder[]{jsMin});
        CSSMinifyBuilder cssMin = new CSSMinifyBuilder(fh);
        buildProcess.addBuilders(new IBuilder[]{cssMin});
    }

    private void addHybridBuilder(BuildProcess buildProcess, FileHandler fh) throws IOException {
        String refPath = "";
        HybridAppCLIBuilder hybridAppBuilder = new HybridAppCLIBuilder(fh, this.cwd, refPath);
        buildProcess.addBuilders(new IBuilder[]{hybridAppBuilder});
    }

    private void addUIFWBuilder(boolean isExclude, boolean useMin, BuildProcess buildProcess, FileHandler fh) {
        UIFWBuilder uifwBuilder = new UIFWBuilder(isExclude, fh);
        uifwBuilder.setUseMin(useMin);
        buildProcess.addBuilders(new IBuilder[]{uifwBuilder});
    }

    private void addLastbuilder(BuildProcess buildProcess) {
        CopyBuilder toFSBuilder = new CopyBuilder(this.output);
        buildProcess.addBuilders(new IBuilder[]{toFSBuilder});
    }

    protected void checkHybridStructure(BuildProcess buildProcess) throws Exception {
        try {
            IBuilder builder = buildProcess.getBuilder(HybridAppCLIBuilder.class);
            if (builder != null) {
                HybridAppCLIBuilder hybridBuilder = (HybridAppCLIBuilder)builder;
                if (!hybridBuilder.isManifestFound()) {
                    throw new IOException("Couldn't find the manifest file(manifest.xml) in the referenced project.");
                }
                if (!hybridBuilder.isBinaryFound()) {
                    throw new IOException("Couldn't find the binary file. Please make sure if your referenced native project is built successfully.");
                }
            }
        }
        catch (IOException e) {
            throw new Exception(e);
        }
    }

    private void setExcludes(List<String> excludes) {
        if (null != excludes) {
            for (String exclude : excludes) {
                this.filter.addExcludes(new Filter[]{(Filter)this.filterFactory.create((Object)exclude)});
            }
        }
    }
}

