/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.core;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionHandlerFilter;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommands;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.core.CommandInfo;
import org.tizen.ncli.core.SubCommandData;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.core.TizenSubCommandHandler;
import org.tizen.ncli.core.collection.TreeNode;
import org.tizen.ncli.ide.shell.AbstractCLI;

public class CommandLineParser
extends CmdLineParser {
    private static final String CURRENT_CMD_KEY = "CURRENT_CMD";
    private Logger log = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private AbstractCLI current;
    private int usageWidth = 80;

    public CommandLineParser(Object bean) {
        super(bean);
        if (bean instanceof AbstractCLI) {
            this.current = (AbstractCLI)bean;
        }
    }

    public void printUsage(Writer out, ResourceBundle rb, OptionHandlerFilter filter) {
        super.printUsage(out, rb, filter);
    }

    public void parseArgument(String ... args) throws CmdLineException {
        TreeNode<CommandInfo> findTreeNode = null;
        try {
            if (null != this.current) {
                TreeNode<CommandInfo> findPreTreeNode;
                CommandInfo cmdInfo = new CommandInfo(this.current.getClass());
                cmdInfo.setCmdLineParser(this);
                CommandInfo preCmd = SubCommandData.get(CURRENT_CMD_KEY);
                this.log.trace("preCmd:{}", (Object)preCmd);
                SubCommandData.put(CURRENT_CMD_KEY, cmdInfo);
                findTreeNode = SubCommandData.getRootNode().findTreeNode(cmdInfo);
                if (null == preCmd && null == findTreeNode) {
                    findTreeNode = SubCommandData.getRootNode().addChild(cmdInfo);
                } else if (null != preCmd && (findPreTreeNode = SubCommandData.getRootNode().findTreeNode(preCmd)) != null) {
                    findPreTreeNode.addChild(cmdInfo);
                }
                this.log.trace("Sub command call..Setting CURRENT_CMD...{}", (Object)cmdInfo);
            } else {
                this.log.trace("Main call..");
                TreeNode<CommandInfo> rootMain = new TreeNode<CommandInfo>(new CommandInfo(null, "MAIN", null, true));
                SubCommandData.setRootNode(rootMain);
                this.makeSubcommandData(rootMain);
            }
            this.log.trace("parseArgument CLP:{}\tCommand:{}", (Object)this, (Object)this.current);
            super.parseArgument(args);
        }
        catch (CmdLineException e) {
            this.log.trace("CmdLineException occurred.\n{}", (Object)e.getMessage());
            CmdLineParser calleeParser = e.getParser();
            if (this == calleeParser) {
                this.log.trace("Same CmdLineParser");
                this.log.trace("args count: {}", (Object)args.length);
                this.log.trace("make sub command reference infos.");
                try {
                    this.makeSubcommandData(findTreeNode);
                }
                catch (CmdLineException ce) {
                    throw ce;
                }
                catch (Exception e2) {
                    this.log.warn("{}", (Object)e2.getMessage());
                }
            } else {
                this.log.trace("Different CmdLineParser instance");
            }
            throw e;
        }
    }

    protected void printOption(PrintWriter out, OptionHandler handler, int len, ResourceBundle rb, OptionHandlerFilter filter) {
        super.printOption(out, handler, len, rb, filter);
        this.log.trace("PrintOption:handler.setter {}", (Object)handler.setter);
    }

    public void makeSubcommandData(TreeNode<CommandInfo> findTreeNode) throws CmdLineException {
        OptionHandler optionHandler;
        List argumentForSub = this.getArguments();
        if (null != argumentForSub && !argumentForSub.isEmpty() && (optionHandler = (OptionHandler)argumentForSub.get(0)) instanceof TizenSubCommandHandler) {
            this.log.trace("{}", (Object)optionHandler);
            TizenSubCommandHandler tizenSubCmdHandler = (TizenSubCommandHandler)optionHandler;
            SubCommands subCommands = tizenSubCmdHandler.getSubcommand();
            SubCommand[] subCommandArray = subCommands.value();
            for (int i = 0; i < subCommandArray.length; ++i) {
                SubCommand subCommand = subCommandArray[i];
                CommandInfo cmdInfo = this.parseTizenSubCommand(subCommand);
                SubCommandData.put(cmdInfo.getCommandName(), cmdInfo);
                if (null == findTreeNode) continue;
                findTreeNode.addChild(cmdInfo);
            }
        }
    }

    private CommandInfo parseTizenSubCommand(SubCommand subCommand) {
        TizenSubCommand annotation = subCommand.impl().getAnnotation(TizenSubCommand.class);
        this.log.trace("SubCommand:{}", (Object)subCommand.name());
        String subCmdName = subCommand.name();
        CommandInfo cmdInfo = null;
        if (null != annotation) {
            subCmdName = null == annotation.name() ? subCommand.name() : annotation.name();
            cmdInfo = new CommandInfo(subCommand.impl(), subCmdName, annotation.usage(), annotation.common());
            this.log.trace("SubCommandData:" + subCmdName + "\t{}\t{}", (Object)annotation.usage(), (Object)annotation.common());
        } else {
            cmdInfo = new CommandInfo(subCommand.impl(), subCmdName, "", false);
            this.log.trace("SubCommandData w/o annotation:{}", (Object)subCommand.name());
        }
        return cmdInfo;
    }

    public void printUsage(Writer out, ResourceBundle rb) {
        int curLen;
        PrintWriter w = new PrintWriter(out);
        List arguments2 = this.getArguments();
        List options2 = this.getOptions();
        int len = 0;
        for (OptionHandler h : arguments2) {
            if (h.option.hidden()) continue;
            curLen = this.getPrefixLen(h, rb);
            len = Math.max(len, curLen);
        }
        for (OptionHandler h : options2) {
            if (h.option.hidden()) continue;
            curLen = this.getPrefixLen(h, rb);
            len = Math.max(len, curLen);
        }
        this.log.trace("NameMeta Max:{}", (Object)len);
        for (OptionHandler h : arguments2) {
            this.printOption(w, h, len, rb);
        }
        for (OptionHandler h : options2) {
            this.printOption(w, h, len, rb);
        }
        w.flush();
    }

    private void printOption(PrintWriter out, OptionHandler handler, int len, ResourceBundle rb) {
        if (handler.option.usage() == null || handler.option.usage().length() == 0 || handler.option.hidden()) {
            return;
        }
        int widthMetadata = Math.min(len, (this.usageWidth - 4) / 2);
        int widthUsage = this.usageWidth - 4 - widthMetadata;
        List<String> namesAndMetas = this.wrapLines(handler.getNameAndMeta(rb), widthMetadata);
        List<String> usages = this.wrapLines(this.localize(handler.option.usage(), rb), widthUsage);
        for (int i = 0; i < Math.max(namesAndMetas.size(), usages.size()); ++i) {
            String nameAndMeta = i >= namesAndMetas.size() ? "" : namesAndMetas.get(i);
            String usage = i >= usages.size() ? "" : usages.get(i);
            String format = nameAndMeta.length() > 0 ? " %1$-" + widthMetadata + "s  %2$-1s" : " %1$-" + widthMetadata + "s   %2$-1s";
            String output = String.format(format, nameAndMeta, usage);
            out.println(output);
        }
    }

    private List<String> wrapLines(String line, int maxLength) {
        ArrayList<String> rv = new ArrayList<String>();
        for (String restOfLine : line.split("\\n")) {
            while (restOfLine.length() > maxLength) {
                String candidate = restOfLine.substring(0, maxLength);
                int sp = candidate.lastIndexOf(32);
                int lineLength = sp > maxLength * 3 / 4 ? sp : maxLength;
                rv.add(restOfLine.substring(0, lineLength));
                restOfLine = restOfLine.substring(lineLength).trim();
            }
            rv.add(restOfLine);
        }
        return rv;
    }

    private String localize(String s, ResourceBundle rb) {
        if (rb != null) {
            return rb.getString(s);
        }
        return s;
    }

    private int getPrefixLen(OptionHandler h, ResourceBundle rb) {
        if (h.option.usage().length() == 0) {
            return 0;
        }
        return h.getNameAndMeta(rb).length();
    }
}

