/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.target.UninstallCLICommand;

@TizenSubCommand(name="uninstall", usage="Uninstall the package from target")
public class UninstallCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="--target", hidden=true, aliases={"-t"}, usage="Specify the target to uninstall the package.")
    private String target;
    @Option(name="--serial", aliases={"-s"}, usage="Specify the serial to uninstall the package.")
    private String serial;
    @Option(name="--pkgid", aliases={"-p"}, usage="Package Id to uninstall.")
    private String pkgid;

    @Override
    public void execute() {
        this.log.trace("Execute UninstallCLI...");
        if (this.help) {
            this.printUsage();
            return;
        }
        UninstallCLICommand command = new UninstallCLICommand();
        command.setWorkingDir(this.getRealWorkingPath());
        if (this.serial != null) {
            command.setTarget(this.serial);
        } else {
            command.setTargetByName(this.target);
        }
        command.setPkgid(this.pkgid);
        command.runCommand();
    }

    @Override
    public boolean needPrintTime() {
        return true;
    }
}

