/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.repack;

import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.repack.RePackageCLICommandData;
import org.tizen.ncli.util.TempDirUtil;

public abstract class AbstractRePackageCLICommand
extends AbstractSubCommand<RePackageCLICommandData> {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected Configuration config = new Configuration();
    protected File tempDir = null;

    protected File getTempDir() {
        if (this.tempDir == null) {
            try {
                this.tempDir = TempDirUtil.createTempDirectory();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.tempDir = null;
            }
        }
        return this.tempDir;
    }

    protected void removeTempDir() {
        if (this.tempDir != null) {
            if (TempDirUtil.deleteDirectory(this.tempDir)) {
                this.tempDir = null;
            } else {
                this.log.trace("Could not delete temp file: {}", (Object)this.tempDir);
            }
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void finalize() {
        this.removeTempDir();
    }
}

