/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.preferences;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.util.XMLUtil;
import org.tizen.common.util.Assert;
import org.tizen.common.util.StringUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SigningProfileContainer {
    protected static final Logger logger = LoggerFactory.getLogger(SigningProfileContainer.class);
    protected final List<SigningProfile> profiles = new ArrayList<SigningProfile>();
    protected String activeProfileName;

    public String getActiveProfileName() {
        return this.activeProfileName;
    }

    public SigningProfile getActiveProfile() {
        if (this.activeProfileName != null) {
            return this.getProfileByName(this.activeProfileName);
        }
        return null;
    }

    public void setActiveProfile(SigningProfile defaultProfile) {
        if (defaultProfile == null) {
            this.activeProfileName = null;
            return;
        }
        this.activeProfileName = defaultProfile.getProfileName();
        boolean bContain = false;
        for (SigningProfile profile : this.profiles) {
            if (!profile.getProfileName().equals(this.activeProfileName)) continue;
            bContain = true;
            break;
        }
        if (!bContain) {
            this.addProfile(defaultProfile);
        }
    }

    public List<SigningProfile> getProfiles() {
        return this.profiles;
    }

    public boolean containsProfile(String profileName) {
        Assert.notNull((Object)profileName);
        return this.getProfileByName(profileName) != null;
    }

    public int size() {
        return this.profiles.size();
    }

    public SigningProfile getFirstProfile() {
        if (this.profiles.isEmpty()) {
            return null;
        }
        return this.profiles.get(0);
    }

    public boolean renameProfile(String fromProfileName, String toProfileName) {
        Assert.notNull((Object)fromProfileName);
        Assert.notNull((Object)toProfileName);
        SigningProfile profile = this.getProfileByName(fromProfileName);
        if (profile == null) {
            return false;
        }
        profile.setProfileName(toProfileName);
        if (fromProfileName.equals(this.activeProfileName)) {
            this.activeProfileName = toProfileName;
        }
        return true;
    }

    public SigningProfile getProfileByName(String profileName) {
        Assert.notNull((Object)profileName);
        for (SigningProfile profile : this.getProfiles()) {
            if (!profileName.equals(profile.getProfileName())) continue;
            return profile;
        }
        return null;
    }

    public boolean addProfile(SigningProfile profile) {
        Assert.notNull((Object)profile);
        return this.profiles.add(profile);
    }

    public boolean removeProfile(SigningProfile profile) {
        Assert.notNull((Object)profile);
        if (profile.getProfileName().equals(this.activeProfileName)) {
            this.activeProfileName = null;
        }
        return this.profiles.remove(profile);
    }

    public String readProfileXML(InputStream in) {
        Node rootNode;
        block8: {
            Assert.notNull((Object)in);
            Document document = XMLUtil.create(in);
            rootNode = document.getFirstChild();
            if (rootNode instanceof Element) break block8;
            return null;
        }
        try {
            Element rootElement = (Element)rootNode;
            String version = rootElement.getAttribute("version");
            NodeList profileNodes = rootElement.getElementsByTagName("profile");
            ArrayList<SigningProfile> result = new ArrayList<SigningProfile>();
            int i = 0;
            int n = profileNodes.getLength();
            while (i < n) {
                Node profileNode = profileNodes.item(i);
                SigningProfile profile = this.readProfileFromNode(profileNode, version);
                if (profile != null) {
                    result.add(profile);
                }
                ++i;
            }
            this.profiles.clear();
            for (SigningProfile profile : result) {
                this.addProfile(profile);
            }
            return version;
        }
        catch (ParserConfigurationException e) {
            logger.error("Can't parse xml", (Throwable)e);
        }
        catch (SAXException e) {
            logger.error("Can't parse xml", (Throwable)e);
        }
        catch (IOException e) {
            logger.error("Can't parse xml", (Throwable)e);
        }
        return null;
    }

    protected SigningProfile readProfileFromNode(Node node, String version) {
        if (!(node instanceof Element)) {
            return null;
        }
        Element profileElement = (Element)node;
        String profileName = profileElement.getAttribute("name");
        SigningProfile profile = new SigningProfile(profileName);
        NodeList itemNodes = profileElement.getElementsByTagName("profileitem");
        this.preprocessForItemLoad(profile, version);
        int i = 0;
        int n = itemNodes.getLength();
        while (i < n) {
            Node item = itemNodes.item(i);
            profile.readProfileItem(item, version);
            ++i;
        }
        return profile;
    }

    protected void preprocessForItemLoad(SigningProfile profile, String version) {
        if (StringUtil.isEmpty((CharSequence)version)) {
            profile.createProfileItemForDeveloper();
        }
    }

    public void writeProfileXML(OutputStream out) {
        Assert.notNull((Object)out);
        try {
            Document document = XMLUtil.create();
            Element rootElement = document.createElement("profiles");
            Attr attr = document.createAttribute("version");
            attr.setValue("3.0");
            rootElement.setAttributeNode(attr);
            this.writeProfile(document, rootElement);
            document.appendChild(rootElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(out));
        }
        catch (ParserConfigurationException e) {
            logger.error("Can't write a profile", (Throwable)e);
        }
        catch (TransformerConfigurationException e) {
            logger.error("Can't write a profile", (Throwable)e);
        }
        catch (TransformerException e) {
            logger.error("Can't write a profile", (Throwable)e);
        }
    }

    protected void writeProfile(Document doc, Element rootElement) {
        Assert.notNull((Object)doc);
        Assert.notNull((Object)rootElement);
        for (SigningProfile profile : this.profiles) {
            Element profileElement = doc.createElement("profile");
            XMLUtil.setElementAttribute(doc, "name", profile.getProfileName(), profileElement);
            int i = 0;
            while (i <= 2) {
                profile.writeProfileItem(doc, profileElement, i);
                ++i;
            }
            rootElement.appendChild(profileElement);
        }
    }
}

