/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.Option;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.core.Tizen;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.config.ConfigCLICommand;

@TizenSubCommand(name="cli-config", usage="Set up configurations for the tizen CLI")
public class ConfigCLI
extends AbstractCLI {
    private Map<String, String> properties = new HashMap<String, String>();
    @Option(name="--list", aliases={"-l"}, usage="Show config list.")
    public boolean list;
    @Option(name="--global", aliases={"-g"}, usage="Setting global Tizen CLI config.", depends={})
    public boolean global;
    @Option(name="--delete", aliases={"-d"}, usage="Delete config with given key.")
    public boolean delete;
    private String deleteKey = null;

    @Argument(metaVar="<key>=<value>", usage="Setting Tizen CLI config with given key=value pair\n In Windows ,the setting values should be enclosed with doublequotes like as \"<key>=<value>\"")
    private void setConfigProperty(String property) throws CmdLineException {
        if (this.delete) {
            this.deleteKey = property;
        } else {
            this.log.trace("setConfigProperty {}", (Object)property);
            if (null == property || property.startsWith("-")) {
                return;
            }
            String[] arr = property.split("=");
            if (arr.length != 2) {
                throw new CmdLineException("configuration must be specified in the form:<key>=<value>");
            }
            this.properties.put(arr[0], arr[1]);
        }
    }

    @Override
    public void execute() {
        this.log.trace("Execute configCLI...");
        ConfigCLICommand configCommand = new Tizen().config();
        configCommand.setList(this.list);
        configCommand.setGlobal(this.global);
        configCommand.setKeyValue(this.properties);
        configCommand.setDeleteKey(this.deleteKey);
        if (!this.list && !this.delete && this.properties.isEmpty() || this.help) {
            this.printUsage();
            return;
        }
        Configuration tizenCLIConfig = (Configuration)configCommand.runCommand();
        if (this.list) {
            if (this.global) {
                Collection<String> allKeys = tizenCLIConfig.getGlobalKeys();
                for (String key : allKeys) {
                    this.output.format("%1$s=%2$s\n", key, tizenCLIConfig.getGlobalValue(key));
                }
            } else {
                Collection<String> allKeys = tizenCLIConfig.getAllKeys();
                for (String key : allKeys) {
                    this.output.format("%1$s=%2$s\n", key, tizenCLIConfig.getValue(key));
                }
            }
        } else if (this.global) {
            this.progressLog.info("Setting global configuration is succeeded....\n");
        } else {
            this.progressLog.info("Setting configuration is succeeded....\n");
        }
        this.output.flush();
    }
}

