/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.config.Preference;
import org.tizen.common.config.PreferenceProvider;
import org.tizen.common.config.provider.EnvironmentProvider;
import org.tizen.common.config.provider.SystemPropertiesProvider;
import org.tizen.common.core.web.NullProgressMonitor;
import org.tizen.common.core.web.ProgressMonitor;
import org.tizen.ncli.core.config.NCLIConfigLoader;
import org.tizen.ncli.core.config.TizenCLIConfigProvider;

public abstract class AbstractSubCommand<T> {
    protected final Logger log = LoggerFactory.getLogger(AbstractSubCommand.class);
    protected final Logger progressLog = LoggerFactory.getLogger((String)"NCLI_PROGRESS");
    protected File workingDir;
    protected ProgressMonitor progressMonitor = new NullProgressMonitor();

    public AbstractSubCommand() {
        this.initializeConfig();
    }

    public void setWorkingDir(File targetPath) {
        this.workingDir = targetPath;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public T runCommand() {
        T ret = this.call();
        return ret;
    }

    private void initializeConfig() {
        Preference.register((String)"OS", (PreferenceProvider)new EnvironmentProvider());
        Preference.register((String)"JVM", (PreferenceProvider)new SystemPropertiesProvider());
        Preference.register((String)"TIZEN.CLI.GLOBAL", (PreferenceProvider)new TizenCLIConfigProvider(NCLIConfigLoader.loadGlobalConf()));
        Preference.register((String)"TIZEN.CLI.LOCAL", (PreferenceProvider)new TizenCLIConfigProvider(NCLIConfigLoader.loadLocalConf()));
    }

    protected abstract T call();

    public void setProgressMonitor(ProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }
}

