/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.target.InstallCLICommand;

@TizenSubCommand(name="install", usage="Install the package to target")
public class InstallCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="--target", hidden=true, aliases={"-t"}, usage="Specify the target name to install the package.")
    private String target;
    @Option(name="--serial", aliases={"-s"}, usage="Specify the serial to install the package.")
    private String serial;
    @Option(name="--name", aliases={"-n"}, required=true, usage="Specify the package file name to install. (Required)")
    private String name;
    @Option(name="--resource", aliases={"-r"}, usage="Specify the resource file name to install.")
    private String res;

    @Override
    public void execute() {
        this.log.trace("Execute InstallCLI...");
        if (this.help) {
            this.printUsage();
            return;
        }
        InstallCLICommand command = new InstallCLICommand();
        command.setWorkingDir(this.getRealWorkingPath());
        if (this.serial != null) {
            command.setTarget(this.serial);
        } else {
            command.setTargetByName(this.target);
        }
        command.setName(this.name);
        command.setResourceName(this.res);
        command.runCommand();
    }

    @Override
    public boolean needPrintTime() {
        return true;
    }
}

