/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.buildnative;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;

public class BuildInfo {
    private String architecture;
    private String projType;
    private String buildConfig;
    private String toolchain;
    private String profileName;
    private String profileVersion;

    public BuildInfo() {
    }

    public BuildInfo(String profileName, String profileVersion, String id, String architecture, String projType) {
        this.profileName = profileName;
        this.profileVersion = profileVersion;
        this.architecture = architecture;
        this.projType = projType;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    public void setArchitecture(String architecture) {
        this.architecture = architecture;
    }

    public String getProjType() {
        return this.projType;
    }

    public void setProjType(String projType) {
        this.projType = projType;
    }

    public String getBuildConfig() {
        return this.buildConfig;
    }

    public void setBuildConfig(String buildConfig) {
        this.buildConfig = buildConfig;
    }

    public String getToolchain() {
        return this.toolchain;
    }

    public void setToolchain(String toolchain) {
        this.toolchain = toolchain;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getProfileVersion() {
        return this.profileVersion;
    }

    public void setProfileVersion(String profileVersion) {
        this.profileVersion = profileVersion;
    }

    public void writeBuildInfo(String buildInfoPath, Logger log) {
        Properties props = new Properties();
        props.put("profile", this.getProfileName());
        props.put("profile-version", this.getProfileVersion());
        props.put("architecture", this.getArchitecture());
        props.put("toolchain", this.getToolchain());
        props.put("config", this.getBuildConfig());
        props.put("type", this.getProjType());
        File propFile = new File(buildInfoPath);
        if (propFile.exists()) {
            propFile.delete();
        }
        try {
            propFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(buildInfoPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        try {
            props.store(outStream, "Build information");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public boolean readBuildInfo(String buildInfoPath, Logger log) {
        File buildInfoFile = new File(buildInfoPath);
        if (!buildInfoFile.exists()) {
            return false;
        }
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(buildInfoFile);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        Properties props = new Properties();
        try {
            props.load(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.setProjType(props.getProperty("type"));
        this.setProfileName(props.getProperty("profile"));
        this.setProfileVersion(props.getProperty("profile-version"));
        this.setBuildConfig(props.getProperty("config"));
        this.setToolchain(props.getProperty("toolchain"));
        this.setArchitecture(props.getProperty("architecture"));
        return true;
    }
}

