/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.target;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.launch.LaunchMessages;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.HostUtil;
import org.tizen.common.util.IOUtil;
import org.tizen.common.util.OSChecker;
import org.tizen.ncli.core.CLIConstant;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.target.Install;
import org.tizen.ncli.subcommands.target.SdbAppCmdAPI;
import org.tizen.ncli.util.TargetUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.service.SyncResult;
import org.tizen.sdblib.service.SyncService;

public class InstallCLICommand
extends AbstractSubCommand<Install> {
    private IDevice target = null;
    private String name = null;
    private String res = null;
    private String workDir = null;
    private String dirPKG = null;
    private String pkgName = null;
    private String tepName = null;
    private String ext = null;
    private String searchPkgCommand = null;
    private String installCommand = TizenPlatformConstants.PKG_TOOL_INSTALL_OLD_COMMAND;
    private String installTepCommand = TizenPlatformConstants.PKG_TOOL_TEP_INSTALL_OLD_COMMAND;
    private static final String SUCCESS = "ok";
    private final String PKGID = "pkgid[";

    public InstallCLICommand() {
        this.searchPkgCommand = OSChecker.isWindows() ? "dir /b %s" : "ls %s";
    }

    @Override
    protected Install call() {
        block16: {
            try {
                this.workDir = this.workingDir.getCanonicalPath();
            }
            catch (IOException e) {
                this.log.error("Fail to get work directory canonical path");
            }
            if (this.target == null) {
                this.progressLog.info(TizenCLIMessages.CANNOT_GET_TARGET);
                return null;
            }
            if (!this.getPackage()) {
                this.progressLog.info(TizenCLIMessages.INST_FAIL_INVALID_PACKAGE);
                return null;
            }
            SdbAppCmdAPI acapi = new SdbAppCmdAPI(this.target);
            if (acapi.isAvailable()) {
                String pkgfilePath = this.workDir + File.separator + this.pkgName;
                String pkgTepfilePath = null;
                if (this.tepName != null) {
                    pkgTepfilePath = this.workDir + File.separator + this.tepName;
                }
                MultiLineReceiver mlReceiver = new MultiLineReceiver(){

                    public void processNewLines(String[] lines) {
                        for (String line : lines) {
                            line = line.trim();
                            InstallCLICommand.this.log.info(line);
                            InstallCLICommand.this.progressLog.info(line);
                        }
                    }
                };
                try {
                    if (acapi.installPackage(pkgfilePath, pkgTepfilePath, (IShellOutputReceiver)mlReceiver)) {
                        this.progressLog.info(TizenCLIMessages.INST_SUCCESS_PACKAGE);
                        break block16;
                    }
                    this.progressLog.info(TizenCLIMessages.INST_FAIL_PACKAGE);
                }
                catch (IOException e) {
                    this.progressLog.info(TizenCLIMessages.INST_FAIL_PACKAGE);
                }
            } else {
                if (!this.tranferPackage(this.pkgName, this.dirPKG)) {
                    this.progressLog.info(TizenCLIMessages.INST_FAIL_TRANSFER_PACKAGE);
                    return null;
                }
                if (this.tepName != null) {
                    if (this.tranferPackage(this.tepName, this.dirPKG)) {
                        this.progressLog.info(TizenCLIMessages.INST_SUCCESS_PACKAGE);
                    } else {
                        this.progressLog.info(TizenCLIMessages.INST_FAIL_TRANSFER_PACKAGE);
                    }
                }
                if (this.installPackage(this.ext, this.pkgName, this.tepName, this.dirPKG)) {
                    this.progressLog.info(TizenCLIMessages.INST_SUCCESS_PACKAGE);
                } else {
                    this.progressLog.info(TizenCLIMessages.INST_FAIL_PACKAGE);
                }
            }
        }
        return null;
    }

    public void setTarget(String targetSerialId) {
        this.target = TargetUtil.getDefault().getTarget(targetSerialId);
        this.log.debug("[target]: " + (this.target == null ? "null" : targetSerialId));
        if (this.target == null) {
            throw new UnexpectedException(2, "[target]: null");
        }
    }

    public void setTargetByName(String targetName) {
        this.target = TargetUtil.getDefault().getTargetByName(targetName);
        this.log.debug("[target]: " + (this.target == null ? "null" : targetName));
        if (this.target == null) {
            throw new UnexpectedException(2, "[target]: null");
        }
    }

    public void setName(String name) {
        this.name = name;
        this.log.debug("[name]: " + (name == null ? "null" : name));
    }

    public void setResourceName(String res) {
        if (res != null) {
            this.res = !res.equals("*") ? res : res;
        }
        this.log.debug("[res]: " + (res == null ? "null" : res));
    }

    private boolean getPackage() {
        this.log.debug("=get package=");
        boolean result = false;
        this.dirPKG = TizenPlatformConstants.getAppTmpDirectory((IDevice)this.target);
        if (this.name == null) {
            ArrayList<String> tpks = new ArrayList<String>();
            ArrayList<String> wgts = new ArrayList<String>();
            ArrayList<String> teps = new ArrayList<String>();
            this.getPackages(tpks, wgts, teps);
            int tpkCnt = tpks.size();
            int wgtCnt = wgts.size();
            int pkgCnt = tpkCnt + wgtCnt;
            if (pkgCnt == 1) {
                result = true;
                if (tpkCnt == 1) {
                    this.pkgName = (String)tpks.get(0);
                    this.ext = CLIConstant.NATIVE_TPK_EXT;
                    this.tepName = (String)teps.get(0);
                } else {
                    this.pkgName = (String)wgts.get(0);
                    this.ext = CLIConstant.WEB_PKG_EXT;
                }
                this.log.debug("ext: " + this.ext);
                this.log.debug("package: " + this.pkgName);
            } else if (pkgCnt == 0) {
                this.progressLog.info(TizenCLIMessages.INST_NO_PACKAGE);
                this.log.error(TizenCLIMessages.INST_NO_PACKAGE);
            } else {
                this.progressLog.info(TizenCLIMessages.INST_MANY_PACKAGES);
                this.log.error(TizenCLIMessages.INST_MANY_PACKAGES);
            }
        } else {
            String srcFilePath = this.workDir + File.separatorChar + this.name;
            if (FileUtil.isExist((String)srcFilePath)) {
                result = true;
                this.pkgName = this.name;
                this.ext = FileUtil.getFileExtension((String)this.pkgName);
                this.log.debug("ext: " + this.ext);
                this.log.debug("package: " + this.pkgName);
                if (this.res != null) {
                    if (this.res.equals("*")) {
                        String second = FileUtil.getFileNameWithoutExtension((String)this.pkgName);
                        int idx = second.indexOf("-");
                        if (idx != -1) {
                            second = second.substring(0, idx);
                        }
                        second = second + ".tep";
                        if (new File(this.workDir + File.separatorChar + second).exists()) {
                            this.tepName = second;
                        }
                    } else {
                        this.tepName = this.res;
                    }
                }
            } else {
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.INST_NO_NAMED_PACKAGE, (Object)this.name));
            }
        }
        return result;
    }

    private void getPackages(List<String> tpks, List<String> wgts, List<String> teps) {
        this.log.trace("=get packages=");
        String tpk = CLIConstant.NATIVE_TPK_EXT;
        String wgt = CLIConstant.WEB_PKG_EXT;
        String tep = CLIConstant.TEP_EXT;
        String ignore_tpk = "." + CLIConstant.NATIVE_TPK_EXT;
        String ignore_wgt = "." + CLIConstant.WEB_PKG_EXT;
        String ignore_tep = "." + CLIConstant.TEP_EXT;
        String ext = null;
        String getPKGCommand = String.format(this.searchPkgCommand, this.workDir);
        this.log.debug("[Get Packages Command]: " + getPKGCommand);
        String returnPkgs = HostUtil.returnExecute((String)getPKGCommand);
        if (returnPkgs.length() != 0) {
            String[] items;
            for (String item : items = returnPkgs.split(HostUtil.LINE_SEPARATOR)) {
                ext = FileUtil.getFileExtension((String)item);
                if (ext == null) continue;
                if (tpk.equals(ext) && !ignore_tpk.equals(item)) {
                    tpks.add(item);
                    continue;
                }
                if (wgt.equals(ext) && !ignore_wgt.equals(item)) {
                    wgts.add(item);
                    continue;
                }
                if (!tep.equals(ext) || ignore_tep.equals(item)) continue;
                teps.add(item);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tranferPackage(String pkgName, String dirPKG) {
        this.log.trace("=transfer package=");
        this.progressLog.info(LaunchMessages.TRANSFER_PACKAGE);
        boolean result = false;
        SyncService sync = null;
        try {
            sync = this.target.getSyncService();
            String srcFilePath = this.workDir + File.separatorChar + pkgName;
            SyncResult syncSuccess = sync.push(srcFilePath, this.target.getFileEntry(dirPKG));
            if (syncSuccess.isOk()) {
                result = true;
                this.progressLog.info(NLS.bind((String)LaunchMessages.TRANSFERRED_PACKAGE, (Object)srcFilePath, (Object)dirPKG));
            } else {
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.INST_CANNOT_TRANSFER_PACKAGE, (Object)pkgName));
                this.log.error(NLS.bind((String)TizenCLIMessages.INST_CANNOT_TRANSFER_PACKAGE, (Object)pkgName));
            }
            if (sync == null) return result;
        }
        catch (IOException e) {
            try {
                this.log.error("[Fail] Fail to push package.");
                if (sync == null) return result;
            }
            catch (Throwable throwable) {
                if (sync == null) throw throwable;
                IOUtil.tryClose((Object[])new Object[]{sync});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{sync});
            return result;
        }
        IOUtil.tryClose((Object[])new Object[]{sync});
        return result;
    }

    private boolean installPackage(String ext, String srcPath, String tepPath, String dirPKG) {
        String[] lines;
        this.log.trace("=install package=");
        this.progressLog.info(LaunchMessages.INSTALL_PACKAGE);
        boolean result = false;
        String installCmd = null;
        if (this.target.isSecureProtocol()) {
            this.installCommand = "appinstall %s";
            installCmd = String.format(this.installCommand, dirPKG + "/" + srcPath);
        } else {
            installCmd = tepPath == null ? String.format(this.installCommand, ext, dirPKG + "/" + srcPath) : String.format(this.installTepCommand, dirPKG + "/" + srcPath, dirPKG + "/" + tepPath);
            String appCmdProtocolVersion = this.target.getAppCmdProtocolVersion();
            if ("0.1".equals(appCmdProtocolVersion)) {
                installCmd = installCmd + " -G";
            }
        }
        this.log.debug("[Install Command]: " + installCmd);
        String returnResult = TargetUtil.getDefault().returnExecuteCommand(this.target, installCmd);
        this.log.info(returnResult);
        this.progressLog.info("--------------------");
        this.progressLog.info("Platform log view");
        this.progressLog.info("--------------------");
        this.progressLog.info(returnResult);
        for (String line : lines = returnResult.split(HostUtil.LINE_SEPARATOR)) {
            String returnStatus;
            int lastIndex = line.lastIndexOf(91);
            if (lastIndex == -1 || !SUCCESS.equals(returnStatus = line.substring(lastIndex + 1, lastIndex + 3))) continue;
            result = true;
            String pkgid = this.getPkgid(line);
            if (pkgid == null) break;
            this.progressLog.info(NLS.bind((String)TizenCLIMessages.INST_INSTALLED, (Object)pkgid));
            break;
        }
        return result;
    }

    private String getPkgid(String line) {
        int startIndex = line.indexOf("pkgid[");
        int endIndex = line.indexOf(93, startIndex);
        String pkgid = line.substring(startIndex + "pkgid[".length(), endIndex);
        return pkgid;
    }
}

