/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.target;

import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.target.ListTarget;
import org.tizen.ncli.util.TargetUtil;
import org.tizen.sdblib.IDevice;

public class ListTargetCLICommand
extends AbstractSubCommand<ListTarget> {
    private boolean detail = false;
    private static final String EMULATOR = "Emulator";
    private static final String DEVICE = "Device";
    private String detailFormat = "[ID] %s\t[TYPE] %s\t[NAME] %s";
    private String defaultFormat = "[ID] %s";

    @Override
    protected ListTarget call() {
        IDevice[] targets = TargetUtil.getDefault().getTargets();
        int length = targets.length;
        if (length > 0) {
            String targetInfo = null;
            if (this.detail) {
                for (IDevice target : targets) {
                    targetInfo = String.format(this.detailFormat, target.getSerialNumber(), target.isEmulator() ? EMULATOR : DEVICE, target.getDeviceName());
                    this.progressLog.info(targetInfo);
                }
            } else {
                for (IDevice target : targets) {
                    targetInfo = String.format(this.defaultFormat, target.getSerialNumber());
                    this.progressLog.info(targetInfo);
                }
            }
        } else {
            this.progressLog.error(TizenCLIMessages.LIST_NO_DEVICE);
        }
        return null;
    }

    public void setDetail(boolean detail) {
        this.detail = detail;
    }
}

