/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.util;

import org.eclipse.core.runtime.IPath;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sign.util.SigningProfileUtil;
import org.tizen.common.util.FileUtil;
import org.tizen.common.util.StringUtil;

public class SigningPathUtil {
    public static final String CERTIFICATE_GENERATOR = "certificate-generator";
    public static final String CERTIFICATES = "certificates";
    public static final String DEVELOPER = "developer";
    public static final String DISTRIBUTOR = "distributor";
    public static final String AUTHOR_CA = "tizen-developer-ca.cer";
    public static final String DISTRIBUTOR1_P12 = "tizen-distributor-signer.p12";
    public static final String DISTRIBUTOR1_CA = "tizen-distributor-ca.cer";
    public static final String DISTRIBUTOR1_PWD = "tizenpkcs12passfordsigner";
    public static final String SIGNATURE_DIRECTORY = ".sign";
    public static final String DEFAULT_AUTHOR_P12 = "tempMobile.p12";
    public static final String DEFAULT_AUTHOR_PWD = "tempMobile";

    public static String getCertificateGeneratorPath() {
        return FileUtil.appendPath((String)InstallPathConfig.getToolsPath(), (String)CERTIFICATE_GENERATOR);
    }

    public static String getCertificatePath() {
        return FileUtil.appendPath((String)SigningPathUtil.getCertificateGeneratorPath(), (String)CERTIFICATES);
    }

    public static String getDeveloperCertificatePath() {
        return FileUtil.appendPath((String)SigningPathUtil.getCertificatePath(), (String)DEVELOPER);
    }

    public static String getDistributorCertificatePath() {
        return FileUtil.appendPath((String)SigningPathUtil.getCertificatePath(), (String)DISTRIBUTOR);
    }

    public static String getAuthorCAPath() {
        return FileUtil.appendPath((String)SigningPathUtil.getDeveloperCertificatePath(), (String)AUTHOR_CA);
    }

    public static String getDeveloperKeyPath() {
        return FileUtil.appendPath((String)SigningPathUtil.getDistributorCertificatePath(), (String)DISTRIBUTOR1_P12);
    }

    public static String getDeveloperKeyPassword() {
        return DISTRIBUTOR1_PWD;
    }

    public static String getDeveloperCAPath() {
        return FileUtil.appendPath((String)SigningPathUtil.getDistributorCertificatePath(), (String)DISTRIBUTOR1_CA);
    }

    public static String getDefaultTizenAuthorPath() {
        return FileUtil.appendPath((String)SigningPathUtil.getDeveloperCertificatePath(), (String)DEFAULT_AUTHOR_P12);
    }

    public static String getDefaultTizenAuthorPassword() {
        return DEFAULT_AUTHOR_PWD;
    }

    public static String getAuthorKeyStorePath(String keyfilename) {
        IPath certPath = SigningProfileUtil.getAuthorCertStorePath().append(keyfilename);
        if (StringUtil.isEmpty((CharSequence)certPath.getFileExtension())) {
            certPath = certPath.addFileExtension("p12");
        }
        String pkcsKeyStorePath = certPath.toPortableString();
        return pkcsKeyStorePath;
    }

    public static String getSignatureDirectory() {
        return ".sign/";
    }
}

