/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.realm;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import org.tizen.common.verrari.AttributeContainer;
import org.tizen.common.verrari.Condition;
import org.tizen.common.verrari.Realm;
import org.tizen.common.verrari.SearchableRealm;
import org.tizen.common.verrari.realm.JarSearchableRealm;
import org.tizen.common.verrari.realm.StandardRealm;
import org.tizen.common.verrari.realm.TizenWebUIFWRealm;

public class StandardSearchableRealm
extends StandardRealm
implements SearchableRealm {
    public StandardSearchableRealm() {
        this.addRealm(new JarSearchableRealm(){

            @Override
            public String getAttribute(String key) {
                return StandardSearchableRealm.this.getAttribute(key);
            }
        });
        this.addRealm(new TizenWebUIFWRealm());
    }

    @Override
    public Collection<AttributeContainer> search(Condition condition) throws IOException {
        HashSet<AttributeContainer> ret = new HashSet<AttributeContainer>();
        for (Realm realm : this.chain) {
            if (!(realm instanceof SearchableRealm)) continue;
            try {
                SearchableRealm searchable = (SearchableRealm)((Object)realm);
                Collection<AttributeContainer> result = searchable.search(condition);
                if (result == null) continue;
                ret.addAll(result);
            }
            catch (IOException e) {
                this.logger.debug("Realm : {} in {} ", (Object)realm, (Object)e.getMessage());
            }
        }
        return ret;
    }
}

