/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.buildnative.BuildNativeCLICommand;

@TizenSubCommand(name="build-native", usage="Build for the tizen native project")
public class BuildNativeCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="--arch", aliases={"-a"}, metaVar="x86 | arm", usage="Architecture for build result.")
    private String architecture;
    @Option(name="--compiler", aliases={"-c"}, metaVar="gcc | llvm", usage="Compiler for build result\nThis option can be used with compiler version\n ex) gcc-version, llvm-version.")
    private String compiler;
    @Option(name="--configuration", aliases={"-C"}, metaVar="Debug | Release", usage="Configuration for build result.")
    private String configuration;
    @Option(name="--predefine-option", aliases={"-d"}, metaVar="symbol", usage="Pre-defined symbol.")
    private String[] predefineOption;
    @Option(name="--rootstrap", aliases={"-r"}, metaVar="rootstrap name", usage="Rootstap name.")
    private String rootstrap;
    @Option(name="--jobs", aliases={"-j"}, metaVar="the number of jobs", usage="Specifies the number of parallel builds for the native app.")
    private int jobs;
    private static final String DA = "DA";
    private static final String DA_ORIGIN = "Dynamic Analyzer";

    @Override
    public void execute() {
        this.log.trace("Execute BuildNativeCLI...");
        BuildNativeCLICommand command = new BuildNativeCLICommand();
        command.setWorkingDir(this.getRealWorkingPath());
        this.configuration = DA.equals(this.configuration) ? DA_ORIGIN : this.configuration;
        command.setRootstrap(this.rootstrap);
        command.setRequiredOptions(new String[]{this.architecture, this.compiler, this.configuration});
        command.setPredefineOption(this.predefineOption);
        command.setJobsForParallelBuild(this.jobs);
        command.runCommand();
    }

    @Override
    public boolean needPrintTime() {
        return true;
    }
}

