/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringArrayOptionHandler;
import org.kohsuke.args4j.spi.StringOptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.web.BuildWebParameter;
import org.tizen.common.core.web.TextProgressMonitor;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.buildweb.BuildWebCLICommand;

@TizenSubCommand(name="build-web", usage="Make a build output directory for web application")
public class BuildWebCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="--optimize", aliases={"-opt"}, usage="Optimize option.")
    public boolean optimize;
    @Option(name="--output", aliases={"-out"}, metaVar="name", handler=StringOptionHandler.class, usage="Specify output directory name.")
    public String outputName;
    @Option(name="--exclude-uifw", aliases={"-euf"}, usage="Specify whether exclude tizen web ui f/w or not.")
    public boolean excludeUIFW;
    @Option(name="--exclude", aliases={"-e"}, metaVar="<file>", handler=StringArrayOptionHandler.class, usage="Specify exclude file list.")
    public String[] excludeArray;
    private List<String> excludeList;

    @Override
    public void execute() {
        this.log.trace("Execute BuildWebCLI...");
        if (this.help) {
            this.printUsage();
            return;
        }
        BuildWebCLICommand command = new BuildWebCLICommand();
        this.log.trace("getRealWorkingPath:{}", (Object)this.getRealWorkingPath());
        if (null != this.outputName) {
            command.setOutputName(this.outputName);
        }
        if (null != this.excludeArray) {
            this.excludeList = new ArrayList<String>(Arrays.asList(this.excludeArray));
            command.setExcludeList(this.excludeList);
        }
        command.setOptimize(this.optimize);
        command.setExcludeUIFW(this.excludeUIFW);
        command.setWorkingDir(this.getRealWorkingPath());
        command.setProgressMonitor(new TextProgressMonitor(new PrintWriter(System.out)));
        BuildWebParameter commandData = (BuildWebParameter)command.runCommand();
        this.progressLog.info("Output path:{}", (Object)commandData.getOutputName());
        if (null != commandData.getExcludeList()) {
            this.progressLog.info("Excluded: {}", commandData.getExcludeList());
        }
    }

    @Override
    public boolean needPrintTime() {
        return true;
    }
}

