/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands;

import java.io.File;
import java.util.List;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.ListRootstrap;
import org.tizen.ncli.subcommands.buildnative.BuildNativeOption;
import org.tizen.sbilib.for_cli.RootstrapData;
import org.tizen.sbilib.for_cli.RootstrapManager;

public class ListRootstrapCLICommand
extends AbstractSubCommand<ListRootstrap> {
    private final String VIEW_FORMAT = "%-40s %s";
    private final String TITLE_FORMAT = String.format("%-40s %s", "[ROOTSTRAP]", "[INFORMATION]");

    @Override
    protected ListRootstrap call() {
        String sdkPath = InstallPathConfig.getSDKPath();
        String sbiHomePath = sdkPath + File.separator + BuildNativeOption.SBI_HOME_PATH;
        List rootstrapDataList = RootstrapManager.getRootstrapDataList((String)sbiHomePath);
        if (rootstrapDataList != null && !rootstrapDataList.isEmpty()) {
            this.progressLog.info(this.TITLE_FORMAT);
            for (RootstrapData rootstrap : rootstrapDataList) {
                String projectInfo = String.format("%-40s %s", rootstrap.getId(), rootstrap.getPlatformName() + ", " + rootstrap.getArchitecture());
                this.progressLog.info(projectInfo);
            }
        }
        return null;
    }
}

