/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.buildnative;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.core.gputil.IOUtil;
import org.tizen.core.gputil.OSChecker;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.buildnative.BuildInfo;
import org.tizen.ncli.subcommands.buildnative.BuildNativeData;
import org.tizen.ncli.subcommands.buildnative.BuildNativeOption;
import org.tizen.sbilib.for_cli.RootstrapData;
import org.tizen.sbilib.for_cli.SBIProcess;
import org.tizen.sbilib.for_cli.SbiData;
import org.tizen.sbilib.for_cli.ToolchainData;
import org.tizen.tpklib.lib.PathUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class BuildNativeCLICommand
extends AbstractSubCommand<BuildNativeData> {
    private Configuration config = new Configuration();
    private BuildNativeData data = new BuildNativeData();
    private String rootstrapName;
    private String[] predefineOption;
    private int jobs;

    private boolean validateRequiredOptions() {
        boolean result = true;
        BuildNativeOption.BuildNativeRequiredOption[] options = BuildNativeOption.BuildNativeRequiredOption.values();
        BuildNativeOption.BuildNativeRequiredOption option = null;
        String value = null;
        String[] candidates = null;
        boolean isValid = false;
        File buildDir = null;
        String projectPropPath = null;
        String buildPropPath = null;
        String manifestPath = null;
        if (this.workingDir == null) {
            buildDir = new File("Build");
            projectPropPath = "project_def.prop";
            buildPropPath = "build_def.prop";
            manifestPath = "tizen-manifest.xml";
        } else {
            buildDir = new File(this.workingDir, "Build");
            projectPropPath = this.workingDir.toString() + File.separator + "project_def.prop";
            buildPropPath = this.workingDir.toString() + File.separator + "build_def.prop";
            manifestPath = this.workingDir.toString() + File.separator + "tizen-manifest.xml";
            this.data.setWorkingDir(this.workingDir.toString());
        }
        if (!buildDir.isDirectory()) {
            this.log.trace(buildDir.toString() + " is not exist");
            this.progressLog.info("The specified build directory(" + this.workingDir.toString() + ") is not vaild");
            return false;
        }
        this.data.setSbiWorkingDir(buildDir);
        File projectPropFile = new File(projectPropPath);
        if (!projectPropFile.exists()) {
            this.log.trace(projectPropPath + " is not exist");
            this.progressLog.info("The specified build directory(" + this.workingDir.toString() + ") is not vaild");
            return false;
        }
        this.data.setProjectPropPath(projectPropPath);
        File buildPropFile = new File(buildPropPath);
        if (buildPropFile.exists()) {
            this.data.setBuildPropPath(buildPropPath);
        } else {
            this.data.setBuildPropPath(null);
        }
        File manifestFile = new File(manifestPath);
        if (manifestFile.exists()) {
            this.data.setManifestPath(manifestPath);
        } else {
            this.data.setManifestPath(null);
        }
        for (int i = 0; i < options.length; ++i) {
            block13: {
                block11: {
                    block12: {
                        isValid = false;
                        option = options[i];
                        value = option.getValue();
                        candidates = option.getCandidates();
                        if (!option.getName().equals("compiler")) break block11;
                        if (!value.equals("gcc") && !value.startsWith("gcc-")) break block12;
                        isValid = true;
                        break block13;
                    }
                    if (!value.equals("llvm") && !value.startsWith("llvm-")) break block13;
                    isValid = true;
                    break block13;
                }
                for (int j = 0; j < candidates.length; ++j) {
                    if (!value.equals(candidates[j])) continue;
                    isValid = true;
                    break;
                }
            }
            if (isValid) continue;
            StringBuilder strBuilder = new StringBuilder();
            for (int j = 0; j < candidates.length; ++j) {
                strBuilder.append(" \"" + candidates[j] + "\"");
            }
            result = false;
            this.progressLog.info(NLS.bind((String)TizenCLIMessages.INVALID_ARG, (Object)((Object)option), (Object)strBuilder.toString().trim()));
            break;
        }
        return result;
    }

    private boolean setCommandArgs() {
        boolean result = true;
        String sdkPath = InstallPathConfig.getSDKPath();
        if (sdkPath == null) {
            this.log.debug("Cannot get SDKPath");
            result = false;
        } else {
            this.data.setSdkPath(sdkPath);
            this.data.setSbiHomePath(sdkPath + File.separator + BuildNativeOption.SBI_HOME_PATH);
            this.convertOptionForSbi();
            result = this.getBuildInfoFromBuildProp();
            if (result) {
                this.getManifestInfo();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getBuildInfoFromBuildProp() {
        Properties prop = new Properties();
        File propFile = new File(this.data.getProjectPropPath());
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(propFile);
            prop.load(inputStream);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IOUtil.tryClose((Object[])new Object[]{inputStream});
                throw throwable;
            }
            IOUtil.tryClose((Object[])new Object[]{inputStream});
        }
        IOUtil.tryClose((Object[])new Object[]{inputStream});
        String type = prop.getProperty("type");
        String profile = prop.getProperty("profile");
        if (type == null || profile == null) {
            this.log.debug("Cannot get profile (type: " + type + " profile: " + profile + ")");
            return false;
        }
        this.data.setSbiType(type);
        StringTokenizer st = new StringTokenizer(profile, "-");
        if (!st.hasMoreTokens()) {
            return false;
        }
        String str = st.nextToken();
        str = str.substring(0, 1).toUpperCase() + str.substring(1);
        this.data.setSbiProfile(str);
        if (!st.hasMoreTokens()) {
            return false;
        }
        this.data.setSbiProfileVersion(st.nextToken());
        return true;
    }

    private boolean getManifestInfo() {
        if (this.data.getManifestPath() == null) {
            return false;
        }
        File file = new File(this.data.getManifestPath());
        if (!file.exists()) {
            return false;
        }
        Document menifestDoc = XMLUtil.readXML((File)file);
        String pack = XMLUtil.getDOMValueNS((Document)menifestDoc, (String)"/:manifest/@package");
        this.data.setSbiPackage(pack);
        Node appNode = XMLUtil.getDOMNodeNS((Document)menifestDoc, (String)"/:manifest/:ui-application");
        if (appNode == null) {
            appNode = XMLUtil.getDOMNodeNS((Document)menifestDoc, (String)"/:manifest/:service-application");
        }
        if (appNode == null) {
            appNode = XMLUtil.getDOMNodeNS((Document)menifestDoc, (String)"/:manifest/:watch-application");
        }
        if (appNode == null) {
            appNode = XMLUtil.getDOMNodeNS((Document)menifestDoc, (String)"/:manifest/:widget-application");
        }
        if (appNode != null && appNode instanceof Element) {
            String id = XMLUtil.getDOMValueNS((Element)((Element)appNode), (String)"@appid");
            this.data.setSbiAppId(id);
            String exec = XMLUtil.getDOMValueNS((Element)((Element)appNode), (String)"@exec");
            this.data.setSbiExecName(exec);
        }
        return true;
    }

    private void convertOptionForSbi() {
        BuildNativeOption.BuildNativeRequiredOption[] options = BuildNativeOption.BuildNativeRequiredOption.values();
        for (int i = 0; i < options.length; ++i) {
            BuildNativeOption.BuildNativeRequiredOption option = options[i];
            if (option.name().equalsIgnoreCase("architecture")) {
                if (option.getValue().equals("arm")) {
                    this.data.setSbiArchitecture("armel");
                } else if (option.getValue().equals("x86")) {
                    this.data.setSbiArchitecture("i386");
                } else {
                    this.log.debug("invalid architecture option : " + option.name());
                }
                this.log.debug("architecture : " + this.data.getSbiArchitecture());
                continue;
            }
            if (option.name().equalsIgnoreCase("compiler")) {
                if (option.getValue().equals("gcc")) {
                    this.data.setSbiToolchain(option.getValue());
                } else if (option.getValue().equals("llvm")) {
                    this.data.setSbiToolchain(option.getValue());
                } else {
                    this.data.setSbiToolchain(option.getValue().toUpperCase());
                }
                this.log.debug("compiler : " + this.data.getSbiToolchain());
                continue;
            }
            if (option.name().equalsIgnoreCase("configuration")) {
                this.data.setSbiConfig(option.getValue());
                this.log.debug("configuration : " + this.data.getSbiConfig());
                continue;
            }
            this.log.debug("invalid option : " + option.name());
        }
    }

    private SBIProcess genSBIProcess(String sdkPath, String projDir, String sbiHomePath, String profileName, String profileVersion, String arch, String toolchainName, String projType) {
        ToolchainData platformDefGccToolchain;
        RootstrapData.ToolchainData tool;
        RootstrapData rootstrap = null;
        List rootstrapList = SBIProcess.loadRootstrapList((String)sbiHomePath);
        if (this.rootstrapName == null) {
            rootstrap = SBIProcess.findRootstrap((List)rootstrapList, (String)profileName, (String)profileVersion, (String)arch);
        } else {
            rootstrap = SBIProcess.findRootstrap((List)rootstrapList, (String)this.rootstrapName);
            if (rootstrap != null) {
                String[] platform;
                arch = rootstrap.getArchitecture();
                this.data.setSbiArchitecture(arch);
                if (rootstrap.getPlatformName() != null && (platform = rootstrap.getPlatformName().split(" ")).length >= 1) {
                    this.data.setSbiProfile(platform[0]);
                    if (platform.length >= 2) {
                        this.data.setSbiProfileVersion(platform[1]);
                    }
                }
            }
        }
        if (rootstrap == null) {
            this.log.trace(TizenCLIMessages.BN_CANNOT_MAKE_BUILD_COMMAND);
            this.progressLog.error("Need more build informations. please check a tizen-sdk/tools/ide/ncli.log file");
            throw new UnexpectedException(2, TizenCLIMessages.BN_CANNOT_MAKE_BUILD_COMMAND);
        }
        List toolchainList = SBIProcess.loadToolchainList((String)sbiHomePath);
        ToolchainData toolchain = null;
        if (toolchainName.equalsIgnoreCase("gcc")) {
            String version = rootstrap.getDefaultToolchain((String)"gcc").version;
            if (version != null) {
                toolchainName = "GCC-" + version;
            }
            toolchain = SBIProcess.findToolchain((List)toolchainList, (String)toolchainName, (String)arch, (String)projType);
        } else if (toolchainName.equalsIgnoreCase("llvm")) {
            toolchainName = "LLVM";
            toolchain = SBIProcess.findLatestToolchain((List)toolchainList, (String)toolchainName, (String)arch, (String)projType);
            toolchainName = toolchain.getName();
        } else {
            toolchain = SBIProcess.findToolchain((List)toolchainList, (String)toolchainName, (String)arch, (String)projType);
        }
        if (toolchain == null) {
            this.log.trace(TizenCLIMessages.BN_CANNOT_MAKE_BUILD_COMMAND);
            this.progressLog.error("Need more build informations. please check a tizen-sdk/tools/ide/ncli.log file");
            throw new UnexpectedException(2, TizenCLIMessages.BN_CANNOT_MAKE_BUILD_COMMAND);
        }
        HashMap<String, String> macros = new HashMap<String, String>();
        if (OSChecker.isWindows()) {
            sbiHomePath = sbiHomePath.replace('\\', '/').replace(" ", "\\ ");
        }
        macros.put("SBI_HOME", sbiHomePath);
        if (toolchainName.startsWith("LLVM") && (tool = rootstrap.getDefaultToolchain("gcc")) != null && (platformDefGccToolchain = SBIProcess.findToolchain((List)toolchainList, (String)(tool.name + "-" + tool.version), (String)arch, (String)projType)) != null) {
            macros.put("PLATFORM_DEFAULT_GCC_PATH", platformDefGccToolchain.getPath());
        }
        rootstrap.processMacro(macros);
        rootstrap.processMacro(macros, "#{", "}");
        toolchain.processMacro(macros);
        toolchain.processMacro(macros, "#{", "}");
        this.progressLog.info("[ARCHITECTURE] " + this.data.getSbiArchitecture());
        this.progressLog.info("[COMPILER] " + toolchainName);
        this.progressLog.info("[CONFIGURATION] " + this.data.getSbiConfig());
        boolean result = false;
        SBIProcess sbi = null;
        sbi = new SBIProcess(InstallPathConfig.getSDKPath());
        sbi.setToolchainData(toolchain);
        sbi.setRootstrapData(rootstrap);
        File sbiBuildConfFile = new File(projDir + "/Build/SBI.xml");
        if (sbiBuildConfFile.exists()) {
            result = sbi.analisysBuildScript(sbiBuildConfFile, (SbiData)this.data, "1.0");
        }
        if (!result && (sbiBuildConfFile = new File(sdkPath + "/tools/ide/resources/native/Build/SBI.xml")).exists()) {
            result = sbi.analisysBuildScript(sbiBuildConfFile, (SbiData)this.data);
        }
        if (result) {
            return sbi;
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected BuildNativeData call() {
        if (!this.data.hasRequiredOptions) {
            this.progressLog.info(TizenCLIMessages.CANNOT_GET_OPTIONS);
            throw new UnexpectedException(2, TizenCLIMessages.CANNOT_GET_OPTIONS);
        }
        if (!this.validateRequiredOptions()) {
            this.log.trace(TizenCLIMessages.INVALID_ARGS);
            throw new UnexpectedException(2, TizenCLIMessages.INVALID_ARGS);
        }
        if (!this.setCommandArgs()) {
            this.log.trace(TizenCLIMessages.BN_CANNOT_MAKE_BUILD_COMMAND);
            this.progressLog.info("Need more build informations. please check a tizen-sdk/tools/ide/ncli.log file");
            throw new UnexpectedException(2, TizenCLIMessages.BN_CANNOT_MAKE_BUILD_COMMAND);
        }
        String sdkPath = this.data.getSdkPath();
        String projDir = this.data.getWorkingDir();
        String sbiHomePath = this.data.getSbiHomePath();
        SBIProcess sbi = this.genSBIProcess(sdkPath, projDir, sbiHomePath, this.data.getSbiProfile(), this.data.getSbiProfileVersion(), this.data.getSbiArchitecture(), this.data.getSbiToolchain(), this.data.getSbiType());
        this.data.setSbiToolchain(sbi.getToolchainData().getName());
        int exitCode = BuildNativeCLICommand.executeWithLog(sbi, this.progressLog, this.data.getWorkingDir(), this.data.getBuildPropPath(), this.data.getSbiHomePath(), this.jobs);
        if (exitCode != 0) {
            this.log.trace(TizenCLIMessages.BN_BUILD_FAIL);
            throw new UnexpectedException(exitCode, TizenCLIMessages.BN_BUILD_FAIL);
        }
        this.setBuildInfo();
        return this.data;
    }

    private void setBuildInfo() {
        String projectPath = new File(this.data.getProjectPropPath()).getParent();
        String outputPath = PathUtil.addPath((String[])new String[]{projectPath, this.data.getSbiConfig()});
        if (!new File(outputPath).exists()) {
            this.log.error(TizenCLIMessages.BN_CANNOT_WRITE_BUILD_TARGET_INFO);
            return;
        }
        BuildInfo buildInfo = new BuildInfo(this.data.getSbiProfile(), this.data.getSbiProfileVersion(), null, this.data.getSbiArchitecture(), this.data.getSbiType());
        buildInfo.setBuildConfig(this.data.getSbiConfig());
        buildInfo.setToolchain(this.data.getSbiToolchain());
        buildInfo.writeBuildInfo(PathUtil.addPath((String[])new String[]{outputPath, "build.info"}), this.log);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int executeWithLog(SBIProcess sbi, Logger logger, String projDir, String buildPropPath, String sbiHomePath, int jobs) {
        int sbi_result = 0;
        if (sbi == null) {
            return -1;
        }
        if (!sbi.isValidate()) {
            return -1;
        }
        ProcessBuilder pb = sbi.genProcessBuilder(null);
        Map<String, String> env = pb.environment();
        Configuration config = new Configuration();
        config.getEnvValueFromCLIConfig(env);
        String preproc = null;
        String postproc = null;
        String preproc_msg = null;
        String postproc_msg = null;
        if (buildPropPath != null && new File(buildPropPath).exists()) {
            Properties prop = new Properties();
            try {
                prop.load(new FileInputStream(buildPropPath));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            finally {
                preproc_msg = prop.getProperty("PREBUILD_DESC");
                preproc = prop.getProperty("PREBUILD_COMMAND");
                postproc_msg = prop.getProperty("POSTBUILD_DESC");
                postproc = prop.getProperty("POSTBUILD_COMMAND");
            }
        }
        sbi.getMacros().put("_PARAM1_", jobs > 0 ? String.valueOf(jobs) : "");
        sbi.getMacros().put("_PARAM2_", preproc);
        sbi.getMacros().put("_PARAM3_", "PreBuild Desc : " + preproc_msg);
        sbi.getMacros().put("_PARAM4_", postproc);
        sbi.getMacros().put("_PARAM5_", "PostBuild Desc : " + postproc_msg);
        sbi_result = sbi.procAction("build", projDir, pb, logger);
        return sbi_result;
    }

    public void setRootstrap(String rootstrap) {
        this.rootstrapName = rootstrap;
    }

    public void setRequiredOptions(String[] input) {
        BuildNativeOption.BuildNativeRequiredOption[] requiredOptions = BuildNativeOption.BuildNativeRequiredOption.values();
        for (int i = 0; i < requiredOptions.length; ++i) {
            BuildNativeOption.BuildNativeRequiredOption requiredOption = requiredOptions[i];
            String str = input[i];
            if (str == null) {
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.BN_NO_BUILD_INPUT, (Object)requiredOption.getName()));
                str = this.config.getValue(requiredOption.getKey());
            }
            if (str == null) {
                this.progressLog.info(requiredOption.getErrorMessage());
                this.data.hasRequiredOptions = false;
                continue;
            }
            requiredOption.setValue(str);
        }
    }

    public void setPredefineOption(String[] predefineOption) {
        this.predefineOption = predefineOption;
    }

    public void setJobsForParallelBuild(int jobs) {
        this.jobs = jobs;
    }
}

