/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.config;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.tizen.common.config.Preference;
import org.tizen.common.config.PreferenceProvider;
import org.tizen.common.util.Assert;
import org.tizen.common.util.IOUtil;
import org.tizen.core.gputil.PropertiesUtil;
import org.tizen.ncli.config.ConfigConstant;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.core.config.NCLIConfigLoader;
import org.tizen.ncli.core.config.TizenCLIConfigProvider;
import org.tizen.ncli.subcommands.AbstractSubCommand;

public class ConfigCLICommand
extends AbstractSubCommand<Configuration> {
    private boolean list = false;
    private boolean global = false;
    private String deleteKey = null;
    private Map<String, String> properties = new HashMap<String, String>();

    public void setConfig(String key, String value) {
        this.properties.put(key, value);
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public void setGlobal(boolean global) {
        this.global = global;
    }

    public void setDeleteKey(String key) {
        this.deleteKey = key;
    }

    public void setKeyValue(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public Configuration call() {
        if (this.list) {
            return new Configuration();
        }
        if (this.deleteKey != null) {
            this.deleteKey(this.deleteKey);
        } else if (this.global) {
            this.log.trace("global config set call() - {}", this.properties);
            Set<String> keySet = this.properties.keySet();
            for (String key : keySet) {
                if (!this.isDefaultKey(key)) continue;
                this.properties.remove(key);
                this.progressLog.warn("\"{}\" is a default configurations, so cannot set as a global.", (Object)key);
            }
            File file = NCLIConfigLoader.getGlobalConfigFile();
            Properties load = NCLIConfigLoader.loadGlobalConf();
            this.writeProperties2File(file, load);
            Preference.register((String)"TIZEN.CLI.GLOBAL", (PreferenceProvider)new TizenCLIConfigProvider(NCLIConfigLoader.loadGlobalConf()));
        } else {
            this.log.trace("local config set call() - {}", this.properties);
            File file = NCLIConfigLoader.getLocalConfigFile();
            Properties load = NCLIConfigLoader.loadLocalConf();
            if (this.writeProperties2File(file, load)) {
                Preference.register((String)"TIZEN.CLI.LOCAL", (PreferenceProvider)new TizenCLIConfigProvider(NCLIConfigLoader.loadLocalConf()));
            } else {
                this.log.error("Fail to write configuration file!");
            }
        }
        return new Configuration();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private boolean writeProperties2File(File file, Properties load) {
        Assert.notNull((Object)file, (String)"There is no file to write.File is Null!");
        Assert.notNull((Object)load, (String)"There is no properties to store.");
        this.updateProperties(load);
        FileOutputStream ous = null;
        try {
            ous = new FileOutputStream(file);
            load.store(ous, "This is generated by Tizen CLI!");
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            boolean bl = false;
            IOUtil.tryClose((Object[])new Object[]{ous});
            return bl;
        }
        catch (IOException ie) {
            ie.printStackTrace();
            boolean bl = false;
            {
                catch (Throwable throwable) {
                    IOUtil.tryClose((Object[])new Object[]{ous});
                    throw throwable;
                }
            }
            IOUtil.tryClose((Object[])new Object[]{ous});
            return bl;
        }
        IOUtil.tryClose((Object[])new Object[]{ous});
        return true;
    }

    private void updateProperties(Properties load) {
        Set<String> keySet = this.properties.keySet();
        for (String key : keySet) {
            String value = this.properties.get(key);
            load.setProperty(key, value);
            this.log.trace("key :{} , value :{}", (Object)key, (Object)value);
        }
    }

    private void deleteKey(String key) {
        File file = this.getPropertiesFile();
        Properties load = NCLIConfigLoader.loadConf(file, false);
        if (this.isDefaultKey(key)) {
            this.log.warn("Cannot remove default key.");
            return;
        }
        load.remove(key);
        try {
            PropertiesUtil.saveProperties((File)file, (Properties)load);
        }
        catch (IOException e) {
            this.log.error(e.getMessage());
            e.printStackTrace();
        }
    }

    private File getPropertiesFile() {
        if (this.global) {
            return NCLIConfigLoader.getGlobalConfigFile();
        }
        return NCLIConfigLoader.getLocalConfigFile();
    }

    private boolean isDefaultKey(String key) {
        return ConfigConstant.DEFAULT_CONFIGURATION_KEY_VALUE.keySet().contains(key);
    }
}

