/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.packages;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.core.application.Version;
import org.tizen.nativecommon.build.NativeSigner;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.buildnative.BuildInfo;
import org.tizen.ncli.subcommands.buildnative.BuildNativeOption;
import org.tizen.ncli.subcommands.packages.NativeProject;
import org.tizen.ncli.subcommands.packages.PackageNativeCLICommandData;
import org.tizen.sbilib.for_cli.RootstrapData;
import org.tizen.sbilib.for_cli.RootstrapManager;
import org.tizen.sbilib.for_cli.ToolchainData;
import org.tizen.sbilib.for_cli.ToolchainManager;
import org.tizen.tpklib.TPK;
import org.tizen.tpklib.core.sign.ISigner;
import org.tizen.tpklib.exception.TPKException;
import org.tizen.tpklib.lib.PathUtil;
import org.w3c.dom.Document;

public class PackageNativeCLICommand
extends AbstractSubCommand<PackageNativeCLICommandData> {
    private PackageNativeCLICommandData data = new PackageNativeCLICommandData();
    private Configuration config = new Configuration();
    private String profilesPath;
    private String profileName;
    private String cprojectPath;
    private String projectFilePath;
    private String manifestPath;
    private Document projectDoc;
    private Document manifestDoc;
    private String projectPath;
    private String workingProjectConfigurationPath;
    private String buildConfiguration;
    private String arch;
    private String projectName;
    private String projectType;
    private String tpkPath = null;
    private String artifactName;
    private String packageName;
    private String packageVersion;
    private boolean isStrip = false;
    private List<String> refPaths = null;

    @Override
    protected PackageNativeCLICommandData call() {
        if (this.setEnv()) {
            try {
                this.buildConfiguration = this.workingDir.getName();
                this.projectDoc = NativeProject.getDocument(this.projectFilePath);
                this.manifestDoc = NativeProject.getDocument(this.manifestPath);
            }
            catch (Exception e) {
                this.progressLog.error("Error occured during getting project file", (Object)e.getMessage());
                return null;
            }
            BuildInfo buildInfo = this.getBuildInfo();
            if (buildInfo == null) {
                this.progressLog.error("Packaging error : Cannot find build information. \"build.info\" file does not exist.");
                return null;
            }
            this.arch = buildInfo.getArchitecture();
            this.packageName = NativeProject.getPackageName(this.manifestDoc);
            this.projectName = NativeProject.getProjectName(this.projectDoc);
            this.artifactName = NativeProject.getArtifactName(this.manifestDoc).toLowerCase();
            this.packageVersion = NativeProject.getVersion(this.manifestDoc);
            if (this.artifactName == null) {
                this.artifactName = this.projectName.toLowerCase();
            }
            if (this.projectType.equalsIgnoreCase("sharedLib")) {
                this.artifactName = "lib" + this.artifactName + ".so";
            }
            String stripper = null;
            if (this.isStrip) {
                ToolchainData.ToolData tool;
                String sdkPath = InstallPathConfig.getSDKPath();
                String sbiHomePath = null;
                if (sdkPath == null) {
                    this.log.debug("Cannot get SDKPath");
                    throw new UnexpectedException(2, "Cannot get SDKPath.");
                }
                sbiHomePath = sdkPath + File.separator + BuildNativeOption.SBI_HOME_PATH;
                this.isStrip = false;
                String toolchainName = buildInfo.getToolchain();
                String projType = buildInfo.getProjType();
                List toolchainList = ToolchainManager.getToolchainDataList((String)sbiHomePath);
                ToolchainData toolchain = ToolchainManager.getToolchain((List)toolchainList, (String)toolchainName, (String)this.arch, (String)new String("org.tizen.nativecore.buildArtefactType." + projType));
                if (toolchain != null && (tool = toolchain.getTool("strip")) != null && (stripper = tool.path) != null && !stripper.isEmpty()) {
                    if (toolchainName.startsWith("LLVM")) {
                        ToolchainData toolchain2;
                        RootstrapData.ToolchainData defToolchainData;
                        String profileName = buildInfo.getProfileName();
                        String profileVer = buildInfo.getProfileVersion();
                        List rootstapList = RootstrapManager.getRootstrapDataList((String)sbiHomePath);
                        RootstrapData rootstrap = RootstrapManager.getRootstrap((List)rootstapList, (String)(profileName + " " + profileVer), (String)this.arch);
                        if (rootstrap != null && (defToolchainData = rootstrap.getDefaultToolchain("gcc")) != null && (toolchain2 = ToolchainManager.getToolchain((List)toolchainList, (String)(defToolchainData.name + "-" + defToolchainData.version), (String)this.arch, (String)new String("org.tizen.nativecore.buildArtefactType." + projType))) != null) {
                            String defGccPath = toolchain2.getPath();
                            stripper = stripper.replace("#{PLATFORM_DEFAULT_GCC_PATH}", defGccPath);
                        }
                    }
                    if (new File(stripper = stripper.replace("#{SBI_HOME}", sbiHomePath)).exists()) {
                        this.isStrip = true;
                    } else {
                        this.progressLog.info(String.format("Cannot found strip tool in '%s'.", stripper));
                    }
                }
                if (!this.isStrip) {
                    this.progressLog.info(String.format("Not supported strip option with '%s' build configuration", this.buildConfiguration));
                }
            }
            List<String> exclude = this.data.getResExclude();
            Map<String, String> include = this.data.getResInclude();
            TPK tpk = TPK.getInstance();
            tpk.setOutputStream((OutputStream)System.out);
            tpk.setErrorStream((OutputStream)System.out);
            try {
                Version version;
                NativeSigner signer = new NativeSigner(null);
                boolean isSign = false;
                if (this.profileName != null && !this.profileName.isEmpty()) {
                    isSign = true;
                    this.setProfilesPath();
                }
                boolean needEmptyDirectory = true;
                if (buildInfo.getProfileVersion() != null && (version = new Version(buildInfo.getProfileVersion())).isSameOrBiggerThanVersion3()) {
                    needEmptyDirectory = false;
                }
                tpk.packaging(this.workingProjectConfigurationPath, this.packageName, this.packageVersion, this.arch, this.artifactName, include, exclude, stripper, isSign, (ISigner)signer, this.profilesPath, this.profileName, needEmptyDirectory);
                this.setTpkPath();
                return this.data;
            }
            catch (TPKException e) {
                this.progressLog.error(e.getMessage());
                return null;
            }
        }
        return null;
    }

    private BuildInfo getBuildInfo() {
        BuildInfo buildInfo = new BuildInfo();
        boolean r = buildInfo.readBuildInfo(PathUtil.addPath((String[])new String[]{this.workingProjectConfigurationPath, "build.info"}), this.log);
        return r ? buildInfo : null;
    }

    public void setOutputPath(String tpkPath) {
        this.tpkPath = tpkPath;
    }

    public String getOutputPath() {
        return this.tpkPath;
    }

    public void setProfileName(String profile) {
        this.profileName = profile;
    }

    public void setReferencePaths(List<String> refPaths) {
        this.refPaths = refPaths;
    }

    public List<String> getReferencePaths() {
        return this.refPaths;
    }

    private void setProfilesPath() {
        this.profilesPath = this.config.getValue("profiles.path");
        if (this.profilesPath == null) {
            this.profilesPath = this.config.getValue("default.profiles.path");
        }
    }

    public void setIsStrip(boolean isStrip) {
        this.isStrip = isStrip;
    }

    private boolean validateProfilesPath() {
        if (this.profilesPath != null) {
            File profiles = new File(this.profilesPath);
            if (profiles.exists()) {
                return true;
            }
            this.progressLog.info(String.format("The path of '%s' does not exist. Update 'tizen cli-config -g %s='valid path'.", "profiles.path", "profiles.path"));
        } else {
            this.progressLog.info(String.format("The '%s' value is not found. See 'tizen cli-config -l'.", "profiles.path"));
        }
        return false;
    }

    private boolean setEnv() {
        try {
            this.workingProjectConfigurationPath = this.workingDir.getCanonicalPath();
            File parentFile = this.workingDir.getParentFile();
            if (parentFile == null) {
                this.progressLog.error("Specify proper build configuration path");
                return false;
            }
            this.projectPath = parentFile.getCanonicalPath();
            this.log.debug("Base project directory: {}", (Object)this.projectPath);
            this.cprojectPath = this.projectPath + File.separatorChar + ".cproject";
            if (!new File(this.cprojectPath).isFile()) {
                this.log.trace(this.cprojectPath + " is not existed.");
                this.progressLog.error("Specify location of the working directory. The given location should be build configuration path such as -- project/Debug.");
                this.progressLog.error("Please enter a valid location.");
                return false;
            }
            this.projectFilePath = this.projectPath + File.separatorChar + ".project";
            this.manifestPath = this.projectPath + File.separatorChar + "tizen-manifest.xml";
            File projectDefFile = new File(this.projectPath, "project_def.prop");
            if (projectDefFile.exists()) {
                Properties prop = new Properties();
                try {
                    FileInputStream inputStream = new FileInputStream(projectDefFile);
                    prop.load(inputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                this.projectType = prop.getProperty("type");
                if (this.projectType == null) {
                    this.progressLog.info("Cannot get project type");
                    throw new UnexpectedException(2, "Cannot get project type");
                }
            }
            return true;
        }
        catch (IOException e) {
            this.log.error("Error occurred during setting working directory", (Object)e.getMessage());
            return false;
        }
    }

    private void setTpkPath() {
        if (this.tpkPath == null) {
            String pkgArch = this.getPkgArchitecture();
            this.tpkPath = pkgArch == null || pkgArch.isEmpty() ? this.workingProjectConfigurationPath + File.separatorChar + this.packageName + "-" + this.packageVersion + ".tpk" : this.workingProjectConfigurationPath + File.separatorChar + this.packageName + "-" + this.packageVersion + "-" + pkgArch + ".tpk";
        }
        this.data.setTpkPath(this.tpkPath);
        this.log.debug("Package path: {}", (Object)this.tpkPath);
    }

    private String getPkgArchitecture() {
        for (String arch : BuildNativeOption.ARCHGROUP_ARM) {
            if (!arch.equals(this.arch)) continue;
            return BuildNativeOption.ARCHGROUP_ARM[0];
        }
        return this.arch;
    }

    public void setResExclude(List<String> resExclude) {
        this.data.setResExclude(resExclude);
    }

    public void setResInclude(Map<String, String> resInclude) {
        this.data.setResInclude(resInclude);
    }
}

