/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.util;

import java.io.File;
import java.util.Properties;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.util.StringUtil;
import org.tizen.ncli.core.config.NCLIConfigLoader;

public class CommandUtil {
    protected static Logger logger = LoggerFactory.getLogger(CommandUtil.class);

    public static String getConfigValue(String configKey) {
        if (configKey == null) {
            return null;
        }
        Properties local = NCLIConfigLoader.loadLocalConf();
        String localValue = local.getProperty(configKey);
        if (!StringUtil.isEmpty((CharSequence)localValue)) {
            return localValue;
        }
        Properties global = NCLIConfigLoader.loadGlobalConf();
        String globalValue = global.getProperty(configKey);
        if (!StringUtil.isEmpty((CharSequence)globalValue)) {
            return globalValue;
        }
        return null;
    }

    public static String getTildeEscapedPath(String path) {
        if (path == null) {
            return null;
        }
        String HOME = System.getProperty("user.home");
        String TILDE = "~";
        Stack<String> stack = new Stack<String>();
        for (File file = new File(path); file != null; file = file.getParentFile()) {
            String name = file.getName();
            stack.push(name);
            logger.debug(name);
        }
        if (stack.isEmpty()) {
            return path;
        }
        String firstPop = (String)stack.pop();
        if ("~".equals(firstPop)) {
            firstPop = HOME;
        }
        File mergeFile = new File(firstPop);
        while (!stack.isEmpty()) {
            mergeFile = new File(mergeFile, (String)stack.pop());
        }
        return mergeFile.getPath();
    }
}

