/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.util;

import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.sdb.command.SdbCommand;
import org.tizen.common.util.HostUtil;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.SmartDevelopmentBridge;

public class TargetUtil {
    private static final Logger log = LoggerFactory.getLogger(TargetUtil.class);
    private static TargetUtil instance = null;
    private static SmartDevelopmentBridge bridge = null;
    private static Configuration config = null;

    public static TargetUtil getDefault() {
        if (bridge == null) {
            TargetUtil.initSdb();
        }
        if (instance == null) {
            instance = new TargetUtil();
        }
        return instance;
    }

    public TargetUtil() {
        config = new Configuration();
    }

    private static void initSdb() {
        log.info("initialize sdb");
        String sdbPath = InstallPathConfig.getSDBPath();
        if (!HostUtil.exists((String)sdbPath)) {
            log.error(String.format("There is no %s.", sdbPath));
        } else {
            try {
                if (bridge == null) {
                    bridge = SmartDevelopmentBridge.createBridge((String)sdbPath);
                    bridge.startBridge();
                    bridge.waitforStart(5000L);
                    if (!bridge.getStarted()) {
                        log.error("Failed to start sdb. Read sdb log in ${tizen_sdk}/tools for details.");
                        bridge.stopBridge();
                    }
                } else {
                    log.info("sdb already initialized");
                }
            }
            catch (Throwable t) {
                log.error("Failed to start sdb");
            }
        }
    }

    public static void finalizeSmartDeviceBridge() {
        if (bridge != null) {
            log.info("finalize sdb");
            SmartDevelopmentBridge.disconnectBridge();
        }
    }

    public IDevice[] getTargets() {
        return SmartDevelopmentBridge.getBridge().getDevices();
    }

    public IDevice getTarget(String serialNumber) {
        IDevice target = null;
        log.info("set target");
        IDevice[] targets = this.getTargets();
        if (targets.length == 0) {
            System.out.println(TizenCLIMessages.NO_CONNECTED_TARGETS);
            log.error(TizenCLIMessages.NO_CONNECTED_TARGETS);
        } else if (serialNumber == null) {
            if (targets.length == 1) {
                target = targets[0];
                log.info("target is " + target);
            } else {
                System.out.println(TizenCLIMessages.MANY_CONNECTED_TARGETS);
                log.error(TizenCLIMessages.MANY_CONNECTED_TARGETS);
            }
        } else {
            boolean isExist = false;
            for (IDevice t : targets) {
                if (!serialNumber.equals(t.getSerialNumber())) continue;
                target = t;
                log.info("target is " + target);
                isExist = true;
                break;
            }
            if (!isExist) {
                System.out.println(NLS.bind((String)TizenCLIMessages.NO_NAMED_TARGETS, (Object)serialNumber));
                log.error(NLS.bind((String)TizenCLIMessages.NO_NAMED_TARGETS, (Object)serialNumber));
            }
        }
        return target;
    }

    public IDevice getTargetByName(String targetName) {
        IDevice target = null;
        log.info("set target");
        IDevice[] targets = this.getTargets();
        if (targets.length == 0) {
            System.out.println(TizenCLIMessages.NO_CONNECTED_TARGETS);
            log.error(TizenCLIMessages.NO_CONNECTED_TARGETS);
        } else if (targetName == null) {
            if (targets.length == 1) {
                target = targets[0];
                log.info("target is " + target);
            } else {
                System.out.println(TizenCLIMessages.MANY_CONNECTED_TARGETS);
                log.error(TizenCLIMessages.MANY_CONNECTED_TARGETS);
            }
        } else {
            boolean isExist = false;
            for (IDevice t : targets) {
                if (!targetName.equals(t.getDeviceName())) continue;
                target = t;
                log.info("target is " + target);
                isExist = true;
                break;
            }
            if (!isExist) {
                System.out.println(NLS.bind((String)TizenCLIMessages.NO_NAMED_TARGETS, (Object)targetName));
                log.error(NLS.bind((String)TizenCLIMessages.NO_NAMED_TARGETS, (Object)targetName));
            }
        }
        return target;
    }

    public String returnExecuteCommand(IDevice target, String command) {
        String defaultTimeout = config.getValue("default.sdb.timeout");
        int timeout = defaultTimeout == null ? 60000 : Integer.parseInt(defaultTimeout);
        SdbCommand sdbCommand = new SdbCommand(target, null, null, timeout);
        log.info("Execute " + command + " via Sdb");
        return sdbCommand.returnExecuteCommand("\"" + command + "\"");
    }
}

