/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.Command;
import org.tizen.common.core.command.file.DirectoryCopyHandlingCommand;
import org.tizen.common.core.command.prompter.FileHandlingOption;
import org.tizen.common.core.command.zip.ZipCommand;
import org.tizen.common.core.command.zip.ZipExtrCommand;
import org.tizen.core.gputil.XMLUtil;
import org.tizen.ncli.core.CommandLineExecutor;
import org.tizen.ncli.core.ConsolePrompter;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.packages.NativeProject;
import org.tizen.ncli.subcommands.packages.PackageCLICommand;
import org.tizen.ncli.subcommands.packages.PackageCLICommandData;
import org.tizen.ncli.subcommands.packages.PackageNativeCLICommand;
import org.tizen.ncli.subcommands.packages.PackageNativeCLICommandData;
import org.tizen.ncli.subcommands.packages.WebProject;
import org.tizen.ncli.subcommands.sign.SignCLICommand;
import org.tizen.ncli.util.TempDirUtil;
import org.tizen.tpklib.lib.zip.IZip;
import org.tizen.tpklib.lib.zip.ZipProvider;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@TizenSubCommand(name="package", usage="Package tizen project")
public class PackageCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="--type", aliases={"-t"}, required=true, metaVar="tpk | wgt", usage="packaging type. (Required)")
    private String type;
    @Option(name="--sign", aliases={"-s"}, usage="Specify profile name.")
    private String sign;
    @Option(name="--strip", aliases={"-S"}, metaVar="on | off", usage="on Specify whether to strip binary or not.")
    private String strip;
    @Option(name="--output", aliases={"-o"}, metaVar="path", usage="Output file paths (for re-package).")
    private String outputPath;
    @Option(name="--reference", aliases={"-r"}, metaVar="path[;...]", usage="Reference prj paths (for HybridApp package).")
    private String[] referencePaths;
    private File tempDir = null;

    private File getTempDir() {
        if (this.tempDir == null) {
            try {
                this.tempDir = TempDirUtil.createTempDirectory();
            }
            catch (IOException e) {
                e.printStackTrace();
                this.tempDir = null;
            }
        }
        return this.tempDir;
    }

    private void removeTempDir() {
        if (this.tempDir != null) {
            if (TempDirUtil.deleteDirectory(this.tempDir)) {
                this.tempDir = null;
            } else {
                this.log.trace("Could not delete temp file: {}", (Object)this.tempDir);
            }
        }
    }

    public void finalize() {
        this.removeTempDir();
    }

    private static boolean isHybridApp(File path) {
        if (!new File(path.toString() + "/tizen-manifest.xml").exists()) {
            return false;
        }
        return new File(path.toString() + "/config.xml").exists();
    }

    private static List<String> parseFilter(String src) {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ArrayList<String> filters = new ArrayList<String>();
        int len = src.length();
        char[] temp = new char[len];
        int idx = 0;
        boolean state = false;
        for (int i = 0; i < len; ++i) {
            char c = src.charAt(i);
            if (c == '\"') {
                if (!state) {
                    state = true;
                    continue;
                }
                state = false;
                continue;
            }
            if (!(state || c != ' ' && c != '\t' && c != '\r' && c != '\n')) {
                if (idx <= 0) continue;
                filters.add(new String(temp, 0, idx).trim());
                idx = 0;
                continue;
            }
            temp[idx++] = c;
        }
        if (idx > 0) {
            filters.add(new String(temp, 0, idx));
        }
        return filters.size() > 0 ? filters : null;
    }

    private void doRepackageForWgt(File path, String outputPath, List<String> refPathList, String sign) {
        CommandLineExecutor executor;
        String ECONFNOTEXIST = "ERROR : config.xml File is not exist : ";
        String EHYBRIDMAINPKG = "ERROR : hybrid package only allow Web UI package as main package : ";
        String EHYBRIDREFPKG = "ERROR : hybrid package only allow native service and widget package as reference package : ";
        String EHYBRIDREQNATIVE = "ERROR : hybrid package required native widget or native service package ";
        ArrayList<String> activeRefPathList = new ArrayList<String>();
        if (refPathList != null && !refPathList.isEmpty()) {
            executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
            int pkg_idx = 0;
            for (String refPath : refPathList) {
                File f = new File(refPath);
                if (!f.exists()) {
                    this.log.trace(refPath.toString() + " is not exists");
                    this.log.trace("Current directory: " + this.currentWorkspacePath);
                    continue;
                }
                if (f.isDirectory()) {
                    throw new UnexpectedException(2, "Not Supported.");
                }
                if (!f.isFile()) continue;
                File tempDir = this.getTempDir();
                String pktPath = tempDir.toString() + "/" + f.getName() + "-" + ++pkg_idx;
                new File(pktPath).mkdir();
                activeRefPathList.add(pktPath);
                ZipExtrCommand zipExtrCmd = new ZipExtrCommand(f.getAbsolutePath(), pktPath);
                zipExtrCmd.setExcludes(new String[]{"signature*.xml", "author-signature*.xml"});
                executor.execute(new Command[]{zipExtrCmd});
            }
        }
        if (!activeRefPathList.isEmpty()) {
            executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
            String rootPath = null;
            String wgtPath = null;
            File tempDir = this.getTempDir();
            rootPath = tempDir.toString() + "/.wgt";
            wgtPath = rootPath + "/res/wgt";
            File wgtFile = new File(wgtPath);
            if (!wgtFile.exists()) {
                wgtFile.mkdirs();
            }
            ZipExtrCommand zipExtrCmd = new ZipExtrCommand(path.getAbsolutePath(), wgtPath);
            zipExtrCmd.setExcludes(new String[]{"signature*.xml", "author-signature*.xml", "res/wgt/signature*.xml", "res/wgt/author-signature*.xml"});
            executor.execute(new Command[]{zipExtrCmd});
            String configPath = wgtPath + File.separator + "config.xml";
            File configFile = new File(configPath);
            if (!configFile.exists()) {
                this.progressLog.error(ECONFNOTEXIST + path.toString());
                throw new UnexpectedException(2, ECONFNOTEXIST + path.toString());
            }
            Document configDoc = WebProject.getDocument(configPath);
            String manifestPath = wgtPath + File.separator + "tizen-manifest.xml";
            File manifestFile = new File(manifestPath);
            if (manifestFile.exists() || !WebProject.isWebUIProject(configDoc)) {
                this.progressLog.error(EHYBRIDMAINPKG + path.toString());
                throw new UnexpectedException(2, EHYBRIDMAINPKG + path.toString());
            }
            ArrayList<File> tizenManifestList = new ArrayList<File>();
            ArrayList<String> copySrcList = new ArrayList<String>();
            ArrayList<String> copyDesList = new ArrayList<String>();
            for (String refPath : activeRefPathList) {
                File refDir = new File(refPath);
                if (PackageCLI.isHybridApp(refDir)) {
                    this.progressLog.error(EHYBRIDREFPKG + refDir.getName());
                    throw new UnexpectedException(2, EHYBRIDREFPKG + refDir.getName());
                }
                File tizenManifest = new File(refPath, "tizen-manifest.xml");
                if (tizenManifest.exists()) {
                    Document tizenManifestDoc = XMLUtil.readXML((File)tizenManifest);
                    if (tizenManifestDoc != null && NativeProject.isStandalone(tizenManifestDoc) && (NativeProject.isWidgetAppLication(tizenManifestDoc) || NativeProject.isServiceAppLication(tizenManifestDoc))) {
                        copySrcList.add(refPath);
                        tizenManifestList.add(tizenManifest);
                        copyDesList.add(rootPath);
                        continue;
                    }
                    this.progressLog.error(EHYBRIDREFPKG + refDir.getName());
                    throw new UnexpectedException(2, EHYBRIDREFPKG + refDir.getName());
                }
                File config = new File(refPath, "config.xml");
                if (!config.exists()) {
                    this.progressLog.error(EHYBRIDREFPKG + refDir.getName());
                    throw new UnexpectedException(2, EHYBRIDREFPKG + refDir.getName());
                }
                Document cDoc = WebProject.getDocument(config.toString());
                if (WebProject.isWebWidgetProject(cDoc)) {
                    copySrcList.add(refPath + File.separator + "widget");
                    WebProject.addWidgetToApp(configDoc, cDoc);
                    copyDesList.add(wgtPath + File.separator + "widget");
                    continue;
                }
                this.progressLog.error(EHYBRIDREFPKG + refDir.getName());
                throw new UnexpectedException(2, EHYBRIDREFPKG + refDir.getName());
            }
            if (tizenManifestList.isEmpty()) {
                this.progressLog.error(EHYBRIDREQNATIVE);
                throw new UnexpectedException(2, EHYBRIDREQNATIVE);
            }
            Document manifestDoc = XMLUtil.mergeXML(tizenManifestList);
            DirectoryCopyHandlingCommand dirCopyCmd = new DirectoryCopyHandlingCommand(copySrcList, copyDesList);
            dirCopyCmd.setOverwriteOption(FileHandlingOption.OVERWRITE_ALL);
            dirCopyCmd.setExcludes(new String[]{"tizen-manifest.xml", "res/wgt/config.xml"});
            executor.execute(new Command[]{dirCopyCmd});
            File configE = new File(rootPath + File.separator + "res" + File.separator + "wgt" + File.separator + "config.xml");
            File manifestE = new File(rootPath, "tizen-manifest.xml");
            if (configE.exists()) {
                configE.delete();
            }
            if (manifestE.exists()) {
                manifestE.delete();
            }
            String packageName = XMLUtil.getDOMValueNS((Document)configDoc, (String)"/:widget/tizen:application/@package");
            String version = XMLUtil.getDOMValueNS((Document)configDoc, (String)"/:widget/@version");
            XMLUtil.setDOMValueNS((Document)manifestDoc, (String)"/:manifest/@package", (String)packageName);
            XMLUtil.setDOMValueNS((Document)manifestDoc, (String)"/:manifest/@version", (String)version);
            NodeList serviceList = XMLUtil.getDOMNodesNS((Document)manifestDoc, (String)"/:manifest/:service-application");
            for (int i = 0; i < serviceList.getLength(); ++i) {
                Node node = serviceList.item(i);
                if (!(node instanceof Element)) continue;
                String appid = ((Element)node).getAttribute("exec");
                ((Element)node).setAttribute("appid", packageName + "." + appid);
            }
            NodeList widgetList = XMLUtil.getDOMNodesNS((Document)manifestDoc, (String)"/:manifest/:widget-application");
            for (int i = 0; i < widgetList.getLength(); ++i) {
                Node node = widgetList.item(i);
                if (!(node instanceof Element)) continue;
                String appid = ((Element)node).getAttribute("exec");
                ((Element)node).setAttribute("appid", packageName + "." + appid);
            }
            NodeList privilegeList = XMLUtil.getDOMNodesNS((Document)manifestDoc, (String)"/:manifest/:privileges/:privilege");
            NodeList featureList = XMLUtil.getDOMNodesNS((Document)manifestDoc, (String)"/:manifest/:feature");
            Node configRoot = XMLUtil.getDOMNodeNS((Document)configDoc, (String)"/:widget");
            if (configRoot != null) {
                NodeList configFeatures = XMLUtil.getDOMNodesNS((Document)configDoc, (String)"/:widget/:feature");
                Node lastFeature = null;
                if (configFeatures != null && configFeatures.getLength() > 0) {
                    lastFeature = configFeatures.item(configFeatures.getLength() - 1);
                }
                for (int i = 0; i < featureList.getLength(); ++i) {
                    Node node = featureList.item(i);
                    if (!(node instanceof Element)) continue;
                    String name = ((Element)node).getAttribute("name");
                    Element elm = configDoc.createElement("feature");
                    elm.setAttribute("name", name);
                    if (lastFeature == null) {
                        configRoot.appendChild(elm);
                        continue;
                    }
                    configRoot.insertBefore(elm, lastFeature);
                }
                NodeList configPrivileges = XMLUtil.getDOMNodesNS((Document)configDoc, (String)"/:widget/tizen:privilege");
                Node lastPrivilege = null;
                if (configPrivileges != null && configPrivileges.getLength() > 0) {
                    lastPrivilege = configPrivileges.item(configPrivileges.getLength() - 1);
                }
                for (int i = 0; i < privilegeList.getLength(); ++i) {
                    Node node = privilegeList.item(i);
                    if (!(node instanceof Element)) continue;
                    String priv = ((Element)node).getTextContent();
                    Element elm = configDoc.createElement("tizen:privilege");
                    elm.setAttribute("name", priv);
                    if (lastPrivilege == null) {
                        configRoot.appendChild(elm);
                        continue;
                    }
                    configRoot.insertBefore(elm, lastPrivilege);
                }
            }
            XMLUtil.writeToFile((Document)manifestDoc, (String)(rootPath + "/tizen-manifest.xml"));
            WebProject.genWidgetConfig(configDoc, wgtPath);
            XMLUtil.writeToFile((Document)configDoc, (String)(rootPath + "/config.xml"));
            if (sign != null && !sign.isEmpty()) {
                File rootFile = new File(rootPath);
                SignCLICommand signCmd = new SignCLICommand();
                signCmd.setWorkingDir(rootFile);
                signCmd.setProfileName(sign);
                signCmd.runCommand();
                File tempFile = new File(rootFile, ".manifest.tmp");
                if (tempFile.exists()) {
                    tempFile.delete();
                }
            }
            if (outputPath != null && !outputPath.isEmpty()) {
                String realoutputPath = outputPath.startsWith(".") ? this.currentWorkspacePath + "/" + outputPath : outputPath;
                this.log.trace("Output Path: " + realoutputPath.toString());
                path = new File(realoutputPath);
            }
            if (path.exists()) {
                path.delete();
            }
            ZipCommand zipCmd = new ZipCommand(rootPath, path.getAbsolutePath());
            zipCmd.setExcludes(new String[]{".manifest.tmp"});
            executor.execute(new Command[]{zipCmd});
            this.removeTempDir();
        } else {
            this.log.trace("Re-packaging wgt file {}", (Object)path.toString());
            File tempDir = this.getTempDir();
            if (tempDir == null) {
                throw new UnexpectedException(2, "Cannot get temp directory.");
            }
            CommandLineExecutor executor2 = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
            ZipExtrCommand zipExtrCmd = new ZipExtrCommand(path.getAbsolutePath(), tempDir.toString());
            executor2.execute(new Command[]{zipExtrCmd});
            if (sign != null && !sign.isEmpty()) {
                SignCLICommand signCmd = new SignCLICommand();
                signCmd.setWorkingDir(tempDir);
                signCmd.setProfileName(sign);
                signCmd.runCommand();
            }
            if (path.exists()) {
                path.delete();
            }
            ZipCommand zipCmd = new ZipCommand(tempDir.toString(), path.getAbsolutePath());
            zipCmd.setExcludes(new String[]{".manifest.tmp"});
            executor2.execute(new Command[]{zipCmd});
            this.removeTempDir();
        }
    }

    /*
     * WARNING - void declaration
     */
    private void doRepackageForTpk(File path, String outputPath, List<String> refPathList, String sign) {
        CommandLineExecutor executor;
        ArrayList<AbstractMap.SimpleEntry<String, String>> activeRefPathList = new ArrayList<AbstractMap.SimpleEntry<String, String>>();
        if (refPathList != null && !refPathList.isEmpty()) {
            executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
            int pkg_idx = 0;
            for (String refPath : refPathList) {
                ZipExtrCommand zipExtrCmd;
                File tempDir;
                File f = new File(refPath);
                if (!f.exists()) {
                    this.log.trace(refPath.toString() + " is not exists");
                    this.log.trace("Current directory: " + this.currentWorkspacePath);
                    continue;
                }
                String filename = f.getName();
                if (filename.substring(filename.length() - 4).equalsIgnoreCase(".tpk")) {
                    tempDir = this.getTempDir();
                    String string = tempDir.toString() + "/" + f.getName() + "-" + ++pkg_idx;
                    new File(string).mkdir();
                    activeRefPathList.add(new AbstractMap.SimpleEntry<String, String>(string, ".tpk"));
                    zipExtrCmd = new ZipExtrCommand(f.getAbsolutePath(), string);
                    zipExtrCmd.setExcludes(new String[]{"signature*.xml", "author-signature*.xml"});
                    executor.execute(new Command[]{zipExtrCmd});
                    continue;
                }
                if (filename.substring(filename.length() - 4).equalsIgnoreCase(".zip")) {
                    tempDir = this.getTempDir();
                    String string = tempDir.toString() + "/" + f.getName() + "-" + ++pkg_idx;
                    new File(string).mkdir();
                    activeRefPathList.add(new AbstractMap.SimpleEntry<String, String>(string, ".tpk"));
                    zipExtrCmd = new ZipExtrCommand(f.getAbsolutePath(), string);
                    zipExtrCmd.setExcludes(new String[]{"signature*.xml", "author-signature*.xml"});
                    executor.execute(new Command[]{zipExtrCmd});
                    continue;
                }
                if (!filename.substring(filename.length() - 3).equalsIgnoreCase(".so")) continue;
                tempDir = this.getTempDir();
                String string = tempDir.toString() + "/" + f.getName();
                new File(string).mkdir();
                activeRefPathList.add(new AbstractMap.SimpleEntry<String, String>(string, ".tpk"));
                ArrayList<String> copySrcList = new ArrayList<String>();
                ArrayList<String> copyDesList = new ArrayList<String>();
                copySrcList.add(f.toString());
                copyDesList.add(string + "/lib/" + f.getName());
                DirectoryCopyHandlingCommand directoryCopyHandlingCommand = new DirectoryCopyHandlingCommand(copySrcList, copyDesList);
                directoryCopyHandlingCommand.setOverwriteOption(FileHandlingOption.OVERWRITE_ALL);
                executor.execute(new Command[]{directoryCopyHandlingCommand});
            }
        }
        if (!activeRefPathList.isEmpty()) {
            executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
            String rootPath = null;
            String pktPath = null;
            if (!path.isFile()) {
                if (path.isDirectory()) {
                    throw new UnexpectedException(2, "Not Supported.");
                }
                throw new UnexpectedException(2, "Unexpected file.");
            }
            File tempDir = this.getTempDir();
            rootPath = tempDir.toString() + File.separator + ".tpk";
            new File(rootPath).mkdirs();
            pktPath = tempDir.toString() + "/" + path.getName();
            new File(pktPath).mkdir();
            ZipExtrCommand zipExtrCmd = new ZipExtrCommand(path.getAbsolutePath(), pktPath);
            zipExtrCmd.setExcludes(new String[]{"signature*.xml", "author-signature*.xml", "res/wgt/signature*.xml", "res/wgt/author-signature*.xml"});
            executor.execute(new Command[]{zipExtrCmd});
            tempDir = this.getTempDir();
            ArrayList<String> copySrcList = new ArrayList<String>();
            ArrayList<String> copyDesList = new ArrayList<String>();
            copySrcList.add(pktPath);
            copyDesList.add(rootPath);
            for (AbstractMap.SimpleEntry simpleEntry : activeRefPathList) {
                copySrcList.add((String)simpleEntry.getKey());
                copyDesList.add(tempDir.toString() + File.separatorChar + (String)simpleEntry.getValue());
            }
            DirectoryCopyHandlingCommand dirCopyCmd = new DirectoryCopyHandlingCommand(copySrcList, copyDesList);
            dirCopyCmd.setOverwriteOption(FileHandlingOption.OVERWRITE_ALL);
            dirCopyCmd.setExcludes(new String[]{"tizen-manifest.xml"});
            executor.execute(new Command[]{dirCopyCmd});
            ArrayList<File> arrayList = new ArrayList<File>();
            File f0 = new File(pktPath + "/tizen-manifest.xml");
            if (f0.exists()) {
                arrayList.add(f0);
            }
            for (AbstractMap.SimpleEntry simpleEntry : activeRefPathList) {
                File f = new File((String)simpleEntry.getKey() + "/tizen-manifest.xml");
                if (!f.exists()) continue;
                arrayList.add(f);
            }
            Document manifestDoc = XMLUtil.mergeXML(arrayList);
            XMLUtil.writeToFile((Document)manifestDoc, (String)(rootPath + "/tizen-manifest.xml"));
            if (sign != null && !sign.isEmpty()) {
                File file = new File(rootPath);
                SignCLICommand signCmd = new SignCLICommand();
                signCmd.setWorkingDir(file);
                signCmd.setProfileName(sign);
                signCmd.runCommand();
                File tempFile = new File(file, ".manifest.tmp");
                if (tempFile.exists()) {
                    tempFile.delete();
                }
            }
            if (outputPath != null && !outputPath.isEmpty()) {
                void var16_31;
                if (outputPath.startsWith(".")) {
                    String string = this.currentWorkspacePath + "/" + outputPath;
                } else {
                    String string = outputPath;
                }
                this.log.trace("Output Path: " + var16_31.toString());
                path = new File((String)var16_31);
            }
            if (path.exists()) {
                path.delete();
            }
            Object var16_33 = null;
            try {
                File file;
                File[] paths;
                File file2 = new File(rootPath + "/bin");
                if (file2.exists()) {
                    for (File fpath : paths = file2.listFiles()) {
                        this.log.trace("set perm: " + fpath.toString());
                        fpath.setExecutable(true);
                    }
                }
                if ((file = new File(rootPath + "/lib")).exists()) {
                    for (File fpath : paths = file.listFiles()) {
                        this.log.trace("set perm: " + fpath.toString());
                        fpath.setExecutable(true);
                    }
                }
                IZip zip = ZipProvider.getZipInstance();
                zip.setOutputStream((OutputStream)System.out);
                if (zip.zipping(new File(rootPath), path.getAbsolutePath(), 493)) {
                    this.log.trace("Zipping... OK\n");
                    this.progressLog.info("Package( " + path.getAbsolutePath() + " ) is created successfully.");
                } else {
                    this.log.trace("Zipping... Fail\n");
                    this.progressLog.info("Package( " + path.getAbsolutePath() + " ) is not created.");
                }
            }
            catch (Exception e) {
                this.log.trace("Zipping... Fail\n");
                this.progressLog.info("Package( " + path.getAbsolutePath() + " ) is not created.");
            }
            this.removeTempDir();
        } else {
            this.log.trace("Re-packaging wgt file {}", (Object)path.toString());
            File tempDir = this.getTempDir();
            if (tempDir == null) {
                throw new UnexpectedException(2, "Not Supported.");
            }
            CommandLineExecutor executor2 = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
            ZipExtrCommand zipExtrCmd = new ZipExtrCommand(path.getAbsolutePath(), tempDir.toString());
            executor2.execute(new Command[]{zipExtrCmd});
            if (sign != null && !sign.isEmpty()) {
                SignCLICommand signCmd = new SignCLICommand();
                signCmd.setWorkingDir(tempDir);
                signCmd.setProfileName(sign);
                signCmd.runCommand();
            }
            if (path.exists()) {
                path.delete();
            }
            ZipCommand zipCmd = new ZipCommand(tempDir.toString(), path.getAbsolutePath());
            zipCmd.setExcludes(new String[]{".manifest.tmp"});
            executor2.execute(new Command[]{zipCmd});
            this.removeTempDir();
        }
    }

    private void doPackageForWgt(File path, String outputPath, List<String> refPathList, String sign) {
        if (path.isFile()) {
            this.doRepackageForWgt(path, outputPath, refPathList, sign);
        } else if (path.isDirectory()) {
            String wgtOutPath;
            PackageCLICommandData data;
            PackageCLICommand packageCommand = new PackageCLICommand();
            packageCommand.setWorkingDir(path);
            packageCommand.setProfileName(sign);
            packageCommand.setReferencePaths(refPathList);
            if (outputPath != null && !outputPath.isEmpty()) {
                packageCommand.setOutputPath(outputPath);
            }
            if (null != (data = (PackageCLICommandData)packageCommand.runCommand()) && null != (wgtOutPath = data.getWgtPath())) {
                this.progressLog.info("Package File Location: {}", (Object)wgtOutPath);
            }
        }
    }

    private void doPackageForTpk(File path, String outputPath, List<String> refPathList, String sign) {
        if (path.isFile()) {
            this.doRepackageForTpk(path, outputPath, refPathList, sign);
        } else if (path.isDirectory()) {
            PackageNativeCLICommandData nativeData;
            List<String> resExclude = null;
            HashMap<String, String> resInclude = null;
            File projectManifestFile = new File(path.toString() + File.separator + ".." + File.separator + "tizen-manifest.xml");
            if (!projectManifestFile.exists()) {
                this.log.trace("tizen-manifest.xml does not exist");
                this.log.trace("The entered path : " + path.toString());
                this.progressLog.info("Cannot provide a package function to this project");
                throw new UnexpectedException(2, "Cannot provide a package function to this project");
            }
            File projectDefFile = new File(path.toString() + File.separator + ".." + File.separator + "project_def.prop");
            if (projectDefFile.exists()) {
                String exclude;
                List<String> temp;
                Properties prop = new Properties();
                try {
                    FileInputStream inputStream = new FileInputStream(projectDefFile);
                    prop.load(inputStream);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                String include = prop.getProperty("USER_RES_INCLUDE");
                if (include != null && !include.isEmpty() && (temp = PackageCLI.parseFilter(include)) != null) {
                    resInclude = new HashMap<String, String>();
                    for (String val : temp) {
                        resInclude.put(val, val);
                    }
                }
                if ((exclude = prop.getProperty("USER_RES_EXCLUDE")) != null && !exclude.isEmpty()) {
                    resExclude = PackageCLI.parseFilter(exclude);
                }
            } else {
                this.log.trace("project_def.prop does not exist");
                this.log.trace("The entered path : " + path.toString());
            }
            PackageNativeCLICommand nativePackageCommand = new PackageNativeCLICommand();
            nativePackageCommand.setWorkingDir(path);
            nativePackageCommand.setProfileName(sign);
            nativePackageCommand.setResExclude(resExclude);
            nativePackageCommand.setResInclude(resInclude);
            nativePackageCommand.setReferencePaths(refPathList);
            if (outputPath != null && !outputPath.isEmpty()) {
                nativePackageCommand.setOutputPath(outputPath);
            }
            if ("on".equals(this.strip)) {
                nativePackageCommand.setIsStrip(true);
            }
            if (null != (nativeData = (PackageNativeCLICommandData)nativePackageCommand.runCommand())) {
                String tpkOutPath = nativeData.getTpkPath();
                if (null != tpkOutPath) {
                    this.progressLog.info("Package File Location: {}", (Object)tpkOutPath);
                }
            } else {
                throw new UnexpectedException(2, "error occured on packaging.");
            }
        }
    }

    @Override
    public void execute() {
        this.log.trace("Execute PackageCLI...");
        if (this.help) {
            this.printUsage();
            return;
        }
        File path = this.getRealWorkingPath();
        this.log.trace("getRealWorkingPath: {}", (Object)path.toString());
        ArrayList<String> refPathList = null;
        if (this.referencePaths != null && this.referencePaths.length > 0) {
            for (String referencePath : this.referencePaths) {
                String[] refPaths;
                for (String refPath : refPaths = referencePath.split(";")) {
                    String realrefPath;
                    if (refPath.startsWith(".")) {
                        String cwd = this.currentWorkspacePath != null ? this.currentWorkspacePath.toString() : System.getProperty("user.dir");
                        realrefPath = cwd + "/" + refPath;
                    } else if (refPath.startsWith("~")) {
                        String userHome = System.getProperty("user.home");
                        realrefPath = userHome + refPath.substring(1);
                    } else {
                        realrefPath = refPath;
                    }
                    if (refPathList == null) {
                        refPathList = new ArrayList<String>();
                    }
                    refPathList.add(realrefPath);
                }
            }
        }
        if (!path.exists()) {
            this.progressLog.info("Specify location of the working directory.");
            throw new UnexpectedException(2, "Specify location of the working directory.");
        }
        if (this.type.equals("wgt")) {
            this.doPackageForWgt(path, this.outputPath, refPathList, this.sign);
        } else if (this.type.equals("tpk")) {
            this.doPackageForTpk(path, this.outputPath, refPathList, this.sign);
        }
    }
}

