/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sdb.command.receiver;

import org.tizen.common.sdb.command.receiver.CommandOutputReceiver;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.common.util.StringUtil;

public class PkgCmdReceiver
extends CommandOutputReceiver {
    private String PKGCMD_CB_KEY_ABOUT_KEY = "key";
    private String PKGCMD_CB_KEY_ABOUT_VALUE = "val";
    private String oldOutput = "";
    private static String RETURN_CB_PREFIX = "__return_cb";
    private static String RETURN_CB_START = "start";
    private static String RETURN_CB_END = "end";
    private static String RETURN_CB_INSTALL_PERCENT = "install_percent";
    private static String RETURN_CB_UNINSTALL_PERCENT = "uninstall_percent";
    private static String OUTPUT_ING = ".";

    public PkgCmdReceiver(ITizenConsoleManager console) {
        super(console);
    }

    @Override
    public void processNewLines(String[] lines) {
        String[] stringArray = lines;
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String output = this.getMeaningfulOutput(line, this.oldOutput);
            if (this.console != null && output != null && !output.isEmpty()) {
                this.console.print(output);
                this.oldOutput = output;
            }
            this.commandOutput.append(line);
            this.commandOutput.append(System.getProperty("line.separator"));
            ++n2;
        }
        this.endLine = lines[lines.length - 1];
    }

    private String getMeaningfulOutput(String output, String lastMeaningfulOutput) {
        String meaningfulOutput = null;
        String[] elements = StringUtil.split(output, " ");
        if (output.startsWith(RETURN_CB_PREFIX)) {
            String key = this.getValue(elements, this.PKGCMD_CB_KEY_ABOUT_KEY);
            String value = this.getValue(elements, this.PKGCMD_CB_KEY_ABOUT_VALUE);
            meaningfulOutput = RETURN_CB_START.equals(key) ? String.valueOf(key) + " process (" + this.getValue(elements, this.PKGCMD_CB_KEY_ABOUT_VALUE) + ")\n" : (RETURN_CB_END.equals(key) ? "\n" + key + " process (" + this.getValue(elements, this.PKGCMD_CB_KEY_ABOUT_VALUE) + ")\n" : (RETURN_CB_INSTALL_PERCENT.equals(key) ? OUTPUT_ING : (RETURN_CB_UNINSTALL_PERCENT.equals(key) ? OUTPUT_ING : "\n" + key + " : " + value + "\n")));
        } else {
            meaningfulOutput = String.valueOf(output) + "\n";
        }
        return meaningfulOutput;
    }

    private String getValue(String[] elements, String key) {
        String result = null;
        String[] stringArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            if (element.startsWith(key)) {
                String[] list = StringUtil.split(element, "[");
                result = StringUtil.trimCharacter(list[1], ']');
                break;
            }
            ++n2;
        }
        return result;
    }
}

