/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.File;
import java.io.IOException;
import org.kohsuke.args4j.Option;
import org.tizen.common.project.util.ProjectValidationUtil;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.createweb.CreateWebProjectCommand;
import org.tizen.ncli.subcommands.createweb.CreateWebProjectCommandData;

@TizenSubCommand(name="web-project", usage="Create the tizen web project")
public class CreateWebProjectCLI
extends AbstractCLI {
    @Option(name="--type", aliases={"-t"}, required=true, metaVar="predefined template name", usage="Specify template name. (Required)")
    private String templateName;
    @Option(name="--name", aliases={"-n"}, metaVar="project name", usage="Specify project name.")
    private String projectName;
    @Option(name="--profile", aliases={"-p"}, required=true, metaVar="profile name", usage="Specify profile name. (Required)")
    private String profileName;

    @Override
    public void execute() {
        if (this.help) {
            this.printUsage();
            return;
        }
        CreateWebProjectCommand webCommand = new CreateWebProjectCommand();
        CreateWebProjectCommandData data = webCommand.getData();
        if (this.profileName != null) {
            data.setProfileName(this.profileName);
        }
        if (this.templateName != null) {
            webCommand.setTemplateName(this.templateName);
            webCommand.setProjectName(this.templateName);
        }
        if (this.projectName != null) {
            boolean ret = this.IsValidProjectName();
            if (!ret) {
                throw new UnexpectedException(2, "invalid project name.");
            }
            webCommand.setProjectName(this.projectName);
        }
        try {
            webCommand.setOutputName(this.getRealWorkingPath().getCanonicalPath() + File.separatorChar + webCommand.getProjectName());
            CreateWebProjectCommandData finalData = (CreateWebProjectCommandData)webCommand.runCommand();
            if (finalData != null) {
                this.progressLog.info("Project Location: {}", (Object)finalData.getOutputName());
            }
        }
        catch (IOException e) {
            this.log.error(TizenCLIMessages.CR_CANNOT_CREATE_OUTDIR);
            throw new UnexpectedException(2, TizenCLIMessages.CR_CANNOT_CREATE_OUTDIR);
        }
    }

    private boolean IsValidProjectName() {
        if (!ProjectValidationUtil.isValidNameLength((String)this.projectName)) {
            this.progressLog.info("Project naming rule : The project name must be longer than 2 characters");
            return false;
        }
        if (!ProjectValidationUtil.isValidName((String)this.projectName)) {
            this.progressLog.info("Project naming rule : Invalid character used in the project name");
            return false;
        }
        if (!ProjectValidationUtil.isValidNameForAppID((String)this.projectName)) {
            this.progressLog.info("Package naming rule : Invalid character used in the project name as a appid");
            return false;
        }
        return true;
    }
}

