/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.target;

import java.io.IOException;
import org.eclipse.osgi.util.NLS;
import org.tizen.ncli.core.CLIConstant;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.target.Run;
import org.tizen.ncli.subcommands.target.SdbAppCmdAPI;
import org.tizen.ncli.util.TargetUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.exception.SdbCommandRejectedException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.receiver.MultiLineReceiver;

public class RunCLICommand
extends AbstractSubCommand<Run> {
    private IDevice target = null;
    private String pkgid = null;
    private String appName = null;
    private String appType = null;
    private String appId = null;
    private String appNameCommand = "/usr/bin/pkginfo --pkg %s | grep -i '^Label[ \\t]*:'";
    private String appIdCommand = "/usr/bin/pkginfo --pkg %s | grep -i '^mainappid[ \\t]*:'";
    private String appTypeCommand = "/usr/bin/pkginfo --pkg %s | grep -i '^Type[ \\t]*:'";
    private String runNativeAppCommand = "/usr/bin/launch_app %s";
    private String runNativeAppCommandWithAppLauncher = "/usr/bin/app_launcher -s %s";
    private String killNativeAppCommand = "/usr/bin/pkgcmd -k -n %s";
    private String runWebAppCommand = "/usr/bin/wrt-launcher --s %s.%s --t 60000";
    private String runWebAppCommandWithAppLauncher = "/usr/bin/app_launcher -s %s.%s";

    @Override
    protected Run call() {
        block11: {
            if (this.target == null) {
                this.progressLog.info(TizenCLIMessages.CANNOT_GET_TARGET);
                throw new UnexpectedException(2, TizenCLIMessages.CANNOT_GET_TARGET);
            }
            if (this.pkgid == null) {
                this.progressLog.info(NLS.bind((String)TizenCLIMessages.CANNOT_GET_OPTION, (Object)"pkgid"));
                throw new UnexpectedException(2, NLS.bind((String)TizenCLIMessages.CANNOT_GET_OPTION, (Object)"pkgid"));
            }
            SdbAppCmdAPI acapi = new SdbAppCmdAPI(this.target);
            if (acapi.isAvailable()) {
                MultiLineReceiver mlReceiver = new MultiLineReceiver(){

                    public void processNewLines(String[] lines) {
                        for (String line : lines) {
                            line = line.trim();
                            RunCLICommand.this.log.info(line);
                            RunCLICommand.this.progressLog.info(line);
                        }
                    }
                };
                try {
                    if (acapi.runPackage(this.pkgid, (IShellOutputReceiver)mlReceiver)) {
                        this.progressLog.info(TizenCLIMessages.RUN_SUCCESS_PACKAGE);
                        break block11;
                    }
                    this.progressLog.info(NLS.bind((String)TizenCLIMessages.RUN_FAIL_PACKAGE, (Object)this.pkgid));
                }
                catch (IOException e) {
                    this.progressLog.info(NLS.bind((String)TizenCLIMessages.RUN_FAIL_PACKAGE, (Object)this.pkgid));
                }
            } else {
                if (this.target.isSecureProtocol()) {
                    this.appNameCommand = "/usr/bin/pkginfo --pkg %s | grep -i '^Label[ \\t]*:'";
                    this.appIdCommand = "/usr/bin/pkginfo --pkg %s | grep -i '^mainappid[ \\t]*:'";
                    this.appTypeCommand = "/usr/bin/pkginfo --pkg %s | grep -i '^Type[ \\t]*:'";
                    this.runWebAppCommand = "/usr/bin/wrt-launcher --s %s.%s --t 60000";
                }
                this.appName = this.getAppName();
                this.appType = this.getAppType();
                this.appId = this.getAppId();
                if (this.appName == null || this.appType == null) {
                    this.progressLog.info(TizenCLIMessages.RUN_FAIL_CANNOT_FIND_APP_NAME);
                    throw new UnexpectedException(2, TizenCLIMessages.RUN_FAIL_CANNOT_FIND_APP_NAME);
                }
                if (this.runApp()) {
                    this.progressLog.info(TizenCLIMessages.RUN_SUCCESS_PACKAGE);
                } else {
                    this.progressLog.info(NLS.bind((String)TizenCLIMessages.RUN_FAIL_PACKAGE, (Object)this.appId));
                    throw new UnexpectedException(2, NLS.bind((String)TizenCLIMessages.RUN_FAIL_PACKAGE, (Object)this.appId));
                }
            }
        }
        return null;
    }

    public void setTarget(String targetSerialId) {
        this.target = TargetUtil.getDefault().getTarget(targetSerialId);
        this.log.debug("[target]: " + (this.target == null ? "null" : targetSerialId));
    }

    public void setTargetByName(String targetName) {
        this.target = TargetUtil.getDefault().getTargetByName(targetName);
        this.log.debug("[target]: " + (this.target == null ? "null" : targetName));
    }

    public void setPackageId(String pkgid) {
        this.pkgid = pkgid;
        this.log.debug("[pkgid]: " + (pkgid == null ? "null" : pkgid));
    }

    private String getAppName() {
        this.log.trace("=get app name=");
        String appName = null;
        String returnStr = null;
        String appNameCmd = String.format(this.appNameCommand, this.pkgid);
        this.log.debug("[get app name command]: " + appNameCmd);
        returnStr = TargetUtil.getDefault().returnExecuteCommand(this.target, appNameCmd);
        if (returnStr.length() > 0) {
            String[] returnStrs = returnStr.split(" ");
            appName = returnStrs[returnStrs.length - 1];
            this.progressLog.info("[Name]: " + appName);
        } else {
            this.log.error("Can not get app type");
        }
        return appName;
    }

    private String getAppType() {
        this.log.trace("=get app type=");
        String appType = null;
        String returnStr = null;
        String appTypeCmd = String.format(this.appTypeCommand, this.pkgid);
        this.log.debug("[get app type command]: " + appTypeCmd);
        returnStr = TargetUtil.getDefault().returnExecuteCommand(this.target, appTypeCmd);
        if (returnStr.length() > 0) {
            String[] returnStrs = returnStr.split(" ");
            appType = returnStrs[returnStrs.length - 1];
            if (!(appType.contains(CLIConstant.NATIVE_TPK_EXT) || CLIConstant.NATIVE_RPM_EXT.equals(appType) || CLIConstant.WEB_PKG_EXT.equals(appType))) {
                appType = null;
            } else {
                this.progressLog.info("[Type]: " + appType);
            }
        } else {
            this.log.error("Can not get app type");
        }
        return appType;
    }

    private String getAppId() {
        this.log.trace("=get app name=");
        String appId = null;
        String returnStr = null;
        String appNameCmd = String.format(this.appIdCommand, this.pkgid);
        this.log.debug("[get app name command]: " + appNameCmd);
        returnStr = TargetUtil.getDefault().returnExecuteCommand(this.target, appNameCmd);
        if (returnStr.length() > 0) {
            String[] returnStrs = returnStr.split(" ");
            appId = returnStrs[returnStrs.length - 1];
            this.progressLog.info("[appId]: " + appId);
        } else {
            this.log.error("Can not get app type");
        }
        return appId;
    }

    private boolean runApp() {
        String[] tokens;
        boolean result = false;
        this.log.info("=run app=");
        this.progressLog.info(TizenCLIMessages.RUN_LAUNCHING_PACKAGE);
        String success = null;
        String runCommand = null;
        String returnResult = null;
        boolean isAppLauncherAvailable = false;
        try {
            isAppLauncherAvailable = !this.target.getPlatformInfo().getPlatformVersion().matches("[12]\\..*");
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            return result;
        }
        catch (SdbCommandRejectedException e) {
            e.printStackTrace();
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return result;
        }
        if (this.appType.contains(CLIConstant.NATIVE_TPK_EXT) || CLIConstant.NATIVE_RPM_EXT.equals(this.appType)) {
            String killCommand = String.format(this.killNativeAppCommand, this.appId);
            returnResult = TargetUtil.getDefault().returnExecuteCommand(this.target, killCommand);
            if (returnResult == null) {
                this.progressLog.error("Command excution failed!");
                return result;
            }
            runCommand = isAppLauncherAvailable ? String.format(this.runNativeAppCommandWithAppLauncher, this.appId) : String.format(this.runNativeAppCommand, this.appId);
            success = "... successfully launched";
        } else if (isAppLauncherAvailable) {
            runCommand = String.format(this.runWebAppCommandWithAppLauncher, this.pkgid, this.appName);
            success = "... successfully launched";
        } else {
            runCommand = String.format(this.runWebAppCommand, this.pkgid, this.appName);
            success = "result: launched";
        }
        this.log.debug("[Run Command]]: " + runCommand);
        returnResult = TargetUtil.getDefault().returnExecuteCommand(this.target, runCommand);
        if (returnResult == null) {
            this.progressLog.error("Command execution failed");
            return result;
        }
        this.log.info(returnResult);
        this.progressLog.info("--------------------");
        this.progressLog.info("Platform log view");
        this.progressLog.info("--------------------");
        this.progressLog.info(returnResult);
        for (String token : tokens = returnResult.split("\n")) {
            if (!token.contains(success)) continue;
            result = true;
            break;
        }
        return result;
    }
}

