/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import java.io.File;
import java.util.List;
import org.kohsuke.args4j.Option;
import org.kohsuke.args4j.spi.StringOptionHandler;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.sign.GenerateCertificateCommand;
import org.tizen.ncli.subcommands.sign.GenerateCertificateCommandData;
import org.tizen.ncli.util.ValidationResult;

@TizenSubCommand(name="certificate", usage="Generate certificate")
public class GenerateCertificateCLI
extends AbstractCLI {
    @Option(name="--alias", aliases={"-a"}, required=true, metaVar="Alias", handler=StringOptionHandler.class, usage="Set the alias. (Required)")
    private String alias;
    @Option(name="--password", aliases={"-p"}, required=true, metaVar="Password", handler=StringOptionHandler.class, usage="Set the password. (Required)")
    private String password;
    @Option(name="--country", aliases={"-c"}, metaVar="Country", handler=StringOptionHandler.class, usage="Specify country code with two letters.")
    private String country;
    @Option(name="--state", aliases={"-s"}, metaVar="State", handler=StringOptionHandler.class, usage="Set the state.")
    private String state;
    @Option(name="--city", aliases={"-ct"}, metaVar="City", handler=StringOptionHandler.class, usage="Set the city.")
    private String city;
    @Option(name="--organization", aliases={"-o"}, metaVar="Organization", handler=StringOptionHandler.class, usage="Set the organization.")
    private String organization;
    @Option(name="--unit", aliases={"-u"}, metaVar="Organization Unit", handler=StringOptionHandler.class, usage="Set the organization unit.")
    private String unit;
    @Option(name="--name", aliases={"-n"}, metaVar="Name", handler=StringOptionHandler.class, usage="Set the name.")
    private String name;
    @Option(name="--email", aliases={"-e"}, metaVar="E-mail", handler=StringOptionHandler.class, usage="Set the email.")
    private String email;
    @Option(name="--filename", aliases={"-f"}, metaVar="File name", handler=StringOptionHandler.class, usage="Set the filename.")
    private String filename;

    @Override
    public void execute() {
        this.log.trace("Start certificate generation.");
        if (this.help) {
            this.log.trace("Enabled the help option");
            this.printUsage();
            return;
        }
        this.log.trace("[Argument] Alias: {}, Password: {}", (Object)this.alias, (Object)this.password);
        this.log.trace("[Argument] Filename: {}", (Object)this.filename);
        this.log.trace("[Argument] Country: {}", (Object)this.country);
        this.log.trace("[Argument] State: {}", (Object)this.state);
        this.log.trace("[Argument] City: {}", (Object)this.city);
        this.log.trace("[Argument] Organization: {}", (Object)this.organization);
        this.log.trace("[Argument] Organization Unit: {}", (Object)this.unit);
        this.log.trace("[Argument] Email: {}", (Object)this.email);
        this.log.trace("[Argument] Name: {}", (Object)this.name);
        this.checkDefaultWorkingDir();
        File cwdFile = this.getRealWorkingPath();
        this.progressLog.info("Working path: {}", (Object)this.getRealWorkingPath().getPath());
        if (!cwdFile.isDirectory()) {
            this.progressLog.error("No exist a specified working directory.");
            throw new UnexpectedException(2, "No exist a specified working directory.");
        }
        this.checkDefaultFilename();
        GenerateCertificateCommandData data = this.createData();
        boolean bValidated = data.validate(this.getRealWorkingPath());
        List<ValidationResult> resultList = data.getValidatedResult();
        if (this.hasValidationResultWith(ValidationResult.Status.ERROR, resultList)) {
            for (ValidationResult result : resultList) {
                this.progressLog.error(result.getMessage());
            }
            throw new UnexpectedException(2, "if have an error, halt.");
        }
        if (this.hasValidationResultWith(ValidationResult.Status.WARN, resultList)) {
            for (ValidationResult result : resultList) {
                this.progressLog.warn(result.getMessage());
            }
        }
        if (bValidated) {
            GenerateCertificateCommand command = new GenerateCertificateCommand(data);
            command.setWorkingDir(cwdFile);
            command.runCommand();
        }
        this.log.trace("Finish certificate generation.");
    }

    private boolean hasValidationResultWith(ValidationResult.Status status, List<ValidationResult> resultList) {
        for (ValidationResult result : resultList) {
            if (!status.equals((Object)result.getStatus())) continue;
            return true;
        }
        return false;
    }

    protected void checkDefaultWorkingDir() {
        if (this.workingDir == null) {
            String userDataPath = InstallPathConfig.getUserDataPath();
            this.workingDir = new File(new File(userDataPath, "keystore"), "author");
            this.progressLog.warn("No path option. Will be generated on '{}'.", (Object)this.workingDir);
            if (!this.workingDir.isDirectory()) {
                if (this.workingDir.mkdirs()) {
                    this.progressLog.info("Created the working directory.");
                } else {
                    this.progressLog.warn("Cannot create the working directory.");
                }
            }
        }
        this.log.trace("Current working directory: {}", (Object)this.workingDir);
    }

    protected void checkDefaultFilename() {
        if (this.filename == null) {
            this.filename = "author";
            this.progressLog.warn("No filename option. Default filename like '{}' is used.", (Object)this.filename);
        }
    }

    protected GenerateCertificateCommandData createData() {
        GenerateCertificateCommandData data = new GenerateCertificateCommandData(this.filename, this.password, this.alias, this.password);
        data.setCity(this.city);
        data.setCountry(this.country);
        data.setEmail(this.email);
        data.setName(this.name);
        data.setOrganization(this.organization);
        data.setUnit(this.unit);
        data.setState(this.state);
        return data;
    }
}

