/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.target;

import java.io.IOException;
import org.eclipse.osgi.util.NLS;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.ncli.exceptions.UnexpectedException;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.target.SdbAppCmdAPI;
import org.tizen.ncli.subcommands.target.Uninstall;
import org.tizen.ncli.util.TargetUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;

public class UninstallCLICommand
extends AbstractSubCommand<Uninstall> {
    private IDevice target = null;
    private String pkgid = null;
    private String uninstallCommand = TizenPlatformConstants.PKG_TOOL + " -q -u -n %s";
    private String removableCommand = TizenPlatformConstants.PKG_TOOL_ROAPP_CHECK_COMMAND;
    private String isRemovable = TizenPlatformConstants.RWAPP_RESULT;
    private String isUnremovable = TizenPlatformConstants.ROAPP_RESULT;

    @Override
    protected Uninstall call() {
        if (this.target == null) {
            this.progressLog.info(TizenCLIMessages.CANNOT_GET_TARGET);
            throw new UnexpectedException(2, TizenCLIMessages.CANNOT_GET_TARGET);
        }
        if (this.pkgid == null) {
            this.progressLog.info(NLS.bind((String)TizenCLIMessages.CANNOT_GET_OPTION, (Object)"pkgid"));
            throw new UnexpectedException(2, NLS.bind((String)TizenCLIMessages.CANNOT_GET_OPTION, (Object)"pkgid"));
        }
        SdbAppCmdAPI acapi = new SdbAppCmdAPI(this.target);
        if (acapi.isAvailable()) {
            MultiLineReceiver mlReceiver = new MultiLineReceiver(){

                public void processNewLines(String[] lines) {
                    for (String line : lines) {
                        line = line.trim();
                        UninstallCLICommand.this.log.info(line);
                        UninstallCLICommand.this.progressLog.info(line);
                    }
                }
            };
            try {
                if (!acapi.uninstallPackage(this.pkgid, (IShellOutputReceiver)mlReceiver)) {
                    this.progressLog.info(TizenCLIMessages.UNINST_FAIL_PACKAGE);
                }
            }
            catch (IOException e) {
                this.progressLog.info(TizenCLIMessages.UNINST_FAIL_PACKAGE);
            }
        } else if (this.isRemovablePackage()) {
            this.uninstallPackage();
        } else {
            this.progressLog.info(TizenCLIMessages.UNINST_FAIL_INVALID_PACKAGE);
            throw new UnexpectedException(2, TizenCLIMessages.UNINST_FAIL_INVALID_PACKAGE);
        }
        return null;
    }

    public void setTarget(String targetSerialId) {
        this.target = TargetUtil.getDefault().getTarget(targetSerialId);
        this.log.debug("[target]: " + (this.target == null ? "null" : targetSerialId));
    }

    public void setTargetByName(String targetName) {
        this.target = TargetUtil.getDefault().getTargetByName(targetName);
        this.log.debug("[target]: " + (this.target == null ? "null" : targetName));
    }

    public void setPkgid(String pkgid) {
        this.pkgid = pkgid;
        this.log.debug("[pkgid]: " + (pkgid == null ? "null" : pkgid));
    }

    private boolean isRemovablePackage() {
        this.log.debug("=check removable package=");
        boolean result = false;
        String returnResult = null;
        if (this.target.isSecureProtocol()) {
            this.removableCommand = TizenPlatformConstants.PKG_TOOL_ROAPP_CHECK_COMMAND;
        }
        String removableCmd = String.format(this.removableCommand, this.pkgid);
        this.log.debug("[check removable command]: " + removableCmd);
        returnResult = TargetUtil.getDefault().returnExecuteCommand(this.target, removableCmd);
        if (returnResult.contains(this.isRemovable)) {
            result = true;
        } else if (returnResult.contains(this.isUnremovable)) {
            this.progressLog.info(TizenCLIMessages.UNINST_UNREMOVABLE_PACKAGE);
        } else {
            this.progressLog.info(TizenCLIMessages.UNINST_UNEXIST_PACKAGE);
        }
        return result;
    }

    private String uninstallPackage() {
        this.log.debug("=uninstall package=");
        String result = null;
        if (this.target.isSecureProtocol()) {
            this.uninstallCommand = "appuninstall %s";
        }
        String uninstallCmd = String.format(this.uninstallCommand, this.pkgid);
        this.log.debug("[Uninstall Command]]: " + uninstallCmd);
        result = TargetUtil.getDefault().returnExecuteCommand(this.target, uninstallCmd);
        this.log.info(result);
        this.progressLog.info("--------------------");
        this.progressLog.info("Platform log view");
        this.progressLog.info("--------------------");
        this.progressLog.info(result);
        return result;
    }
}

