/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.ide.shell;

import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.ncli.core.TizenSubCommand;
import org.tizen.ncli.ide.shell.AbstractCLI;
import org.tizen.ncli.subcommands.build.buildapp.BuildAppCLICommand;
import org.tizen.ncli.subcommands.build.buildapp.BuildAppData;

@TizenSubCommand(name="build-app", usage="Build and package Tizen native/web projects.")
public class BuildAppCLI
extends AbstractCLI {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Option(name="-f", aliases={"--script-file"}, metaVar="<script file>", usage="Specify the path of multi-project script file.")
    private String scriptPath;
    @Option(name="-s", aliases={"--sign"}, metaVar="<security-profile>", usage="Specify a security-profile name.")
    private String sign;
    @Option(name="-o", aliases={"--output"}, metaVar="<path>", usage="Specify the output file paths.")
    private String outputPath;
    @Option(name="-t", aliases={"--target"}, metaVar="<description>", usage="Specify the build targets.")
    private String[] targets;
    @Option(name="-m", aliases={"--method"}, metaVar="<description>", usage="Specify the build method.")
    private String[] methods;
    @Option(name="-b", aliases={"--build"}, metaVar="<description>", usage="Specify the build description.")
    private String[] builds;
    @Option(name="-p", aliases={"--package"}, metaVar="<description>", usage="Specify the package description.")
    private String[] packages;
    @Option(name="-d", aliases={"--define"}, metaVar="<macro>", usage="Define the macro for ABS script file.")
    private String[] defines;

    @Override
    public int execute() {
        this.log.trace("Execute BuildNativeCLI...");
        BuildAppCLICommand command = new BuildAppCLICommand();
        command.setWorkingDir(this.getRealWorkingPath());
        command.setScriptPath(this.scriptPath);
        command.setSignProfile(this.sign);
        command.setOutputPath(this.outputPath);
        command.setTargetDescs(this.targets);
        command.setMethodDescs(this.methods);
        command.setBuildDescs(this.builds);
        command.setPackageDescs(this.packages);
        command.setMacros(this.defines);
        BuildAppData data = (BuildAppData)((Object)command.runCommand());
        if (data == null) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean needPrintTime() {
        return true;
    }
}

