<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:tizen="http://tizen.org/ns/widgets"
                              xmlns:widget="http://www.w3.org/ns/widgets"
                              xmlns:manifest="http://tizen.org/ns/packages">
    <xsl:output encoding="UTF-8" indent="yes" method="xml" />

    <!-- native manifest name space -->
    <xsl:param name="manifest" select="'http://tizen.org/ns/packages'"/>

    <!-- Regard app having 'manifest' element located first as main app.
         Main app can be UI-app or watch-app or IME. -->
    <xsl:template match="/">
        <xsl:apply-templates select="/root/manifest/manifest:manifest[1]"/>
    </xsl:template>

    <!-- root template -->
    <xsl:template match="/root/manifest/manifest:manifest">
        <xsl:text>&#xa;</xsl:text>
          <xsl:copy>
              <xsl:apply-templates select="@*"/>
              <xsl:apply-templates select="manifest:profile"/>
              <xsl:apply-templates select="manifest:watch-application"/>
              <xsl:apply-templates select="//manifest:ui-application"/>
            <xsl:apply-templates select="//manifest:service-application"/>
            <xsl:apply-templates select="//manifest:widget-application"/>
            <xsl:if test="//manifest:privileges/manifest:privilege">
            <xsl:text>&#xa;    </xsl:text>
                <xsl:element name="privileges" namespace="{$manifest}">
                    <xsl:apply-templates select="//manifest:privileges/manifest:privilege"/>
                <xsl:text>&#xa;    </xsl:text>
                </xsl:element>
            </xsl:if>
            <xsl:apply-templates select="//manifest:feature"/>
        </xsl:copy>
    </xsl:template>

    <!--  copy 'profile' element -->
    <xsl:template match="manifest:profile">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!-- copy 'ui-application' element -->
    <xsl:template match="manifest:ui-application">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!-- copy 'watch-application' element -->
    <xsl:template match="manifest:watch-application ">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!--  copy 'service-application' element -->
    <xsl:template match="manifest:service-application">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!--  copy 'widget-application' element -->
    <xsl:template match="manifest:widget-application">
        <xsl:text>&#xa;    </xsl:text>
        <xsl:copy>
            <xsl:apply-templates select="@*|node()" />
        </xsl:copy>
    </xsl:template>

    <!--  merge 'privilege' element -->
    <xsl:key name="GroupByPrivilege" match="manifest:privilege" use="text()"/>
    <xsl:template match="manifest:privilege">
        <xsl:if test="generate-id()=generate-id(key('GroupByPrivilege', text())[1])">
            <xsl:text>&#xa;        </xsl:text>
            <xsl:copy>
                <xsl:apply-templates select="@*|node()" />
            </xsl:copy>
        </xsl:if>
    </xsl:template>

    <!--  merge 'feature' element -->
    <xsl:key name="GroupByFeautre" match="manifest:feature" use="@name"/>
    <xsl:template match="manifest:feature">
        <xsl:if test="generate-id()=generate-id(key('GroupByFeautre', @name)[1])">
            <xsl:text>&#xa;    </xsl:text>
            <xsl:copy>
                <xsl:apply-templates select="@*|node()" />
            </xsl:copy>
        </xsl:if>
    </xsl:template>

    <!-- copy elements and attributes -->
    <xsl:template match="@*|node()">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:template>
</xsl:stylesheet>