/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildapp;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.CharBuffer;
import java.util.Map;
import org.slf4j.Logger;
import org.tizen.core.gputil.MacroUtil;
import org.tizen.ncli.subcommands.build.buildapp.BuildScriptData;
import org.tizen.ncli.subcommands.build.buildapp.BuildScriptParser;

public class BuildScriptFileParser {
    private static void parseWorkspace(BuildScriptData buildScript, JsonObject workspace) {
        BuildScriptParser.parseWorkspace(buildScript, workspace);
    }

    private static void parseProjects(BuildScriptData buildScript, JsonArray projects) {
        if (projects != null) {
            int cnt = projects.size();
            for (int i = 0; i < cnt; ++i) {
                JsonObject project = projects.get(i).getAsJsonObject();
                BuildScriptParser.parseProject(buildScript, project);
            }
        }
    }

    private static void parseMethods(BuildScriptData buildScript, JsonArray methods) {
        if (methods != null) {
            int cnt = methods.size();
            for (int i = 0; i < cnt; ++i) {
                JsonElement elem = methods.get(i);
                if (elem == null || elem.isJsonNull()) continue;
                JsonObject method = elem.getAsJsonObject();
                BuildScriptParser.parseMethod(buildScript, method);
            }
        }
    }

    private static void parseBuilds(BuildScriptData buildScript, JsonArray builds) {
        if (builds != null) {
            int cnt = builds.size();
            for (int i = 0; i < cnt; ++i) {
                JsonObject build = builds.get(i).getAsJsonObject();
                BuildScriptParser.parseBuild(buildScript, build);
            }
        }
    }

    private static void parsePackages(BuildScriptData buildScript, JsonArray packages) {
        if (packages != null) {
            int cnt = packages.size();
            for (int i = 0; i < cnt; ++i) {
                JsonObject pkg = packages.get(i).getAsJsonObject();
                BuildScriptParser.parsePackage(buildScript, pkg);
            }
        }
    }

    public static BuildScriptData analizeBuildScript(BuildScriptData buildScript, String scriptPath, String workspacePath, Map<String, String> macros, Logger log) {
        JsonObject rootObject;
        try {
            String fileStr;
            CharBuffer charBuf = null;
            FileInputStream fileStream = new FileInputStream(scriptPath);
            int size = ((InputStream)fileStream).available();
            if (size > 0) {
                InputStreamReader reader = new InputStreamReader(fileStream);
                charBuf = CharBuffer.allocate(size);
                ((Reader)reader).read(charBuf);
                ((Reader)reader).close();
            }
            ((InputStream)fileStream).close();
            if (charBuf != null) {
                charBuf.flip();
                fileStr = charBuf.toString();
                if (macros != null && !macros.isEmpty()) {
                    fileStr = MacroUtil.processMacro((String)fileStr, macros);
                }
            } else {
                log.error("Emptry ABS script file.");
                return null;
            }
            rootObject = new JsonParser().parse(fileStr).getAsJsonObject();
        }
        catch (JsonIOException | JsonSyntaxException | IOException e) {
            log.error(e.getMessage());
            return null;
        }
        if (buildScript == null) {
            buildScript = new BuildScriptData();
        }
        JsonObject workspace = rootObject.getAsJsonObject("workspace");
        BuildScriptFileParser.parseWorkspace(buildScript, workspace);
        if (workspacePath != null) {
            buildScript.getWorkspace().setWorkspacePath(workspacePath);
        } else if (buildScript.getWorkspace().getWorkspacePath() == null) {
            workspacePath = new File(scriptPath).getParent();
            buildScript.getWorkspace().setWorkspacePath(workspacePath);
        }
        JsonArray projects = rootObject.getAsJsonArray("project");
        BuildScriptFileParser.parseProjects(buildScript, projects);
        JsonArray methods = rootObject.getAsJsonArray("method");
        BuildScriptFileParser.parseMethods(buildScript, methods);
        JsonArray builds = rootObject.getAsJsonArray("build");
        BuildScriptFileParser.parseBuilds(buildScript, builds);
        JsonArray packages = rootObject.getAsJsonArray("package");
        BuildScriptFileParser.parsePackages(buildScript, packages);
        return buildScript;
    }

    public static BuildScriptData analizeBuildScript(String scriptPath, String workspacePath, Map<String, String> macros, Logger log) {
        return BuildScriptFileParser.analizeBuildScript(null, scriptPath, workspacePath, macros, log);
    }
}

