/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildnative;

import java.io.File;
import org.eclipse.osgi.util.NLS;
import org.tizen.ncli.ide.messages.TizenCLIMessages;

public class BuildNativeOption {
    public static final String BIN_EXT = "";
    public static final String PLATFORM = "platform";
    public static final String ROOTSTRAPS = "rootstraps";
    public static final String CPROJECT_EXT = ".cproject";
    public static final String PROJECT_EXT = ".project";
    public static final String TPROJECT_EXT = ".tproject";
    public static final String HEADLESS_CMD = "%s" + File.separatorChar + "%s -nosplash --launcher.suppressErrors -application org.eclipse.cdt.managedbuilder.core.headlessbuild " + "-import %s " + "-build %s " + "-data %s " + "-Ea CLI=true " + "-T org.tizen.nativecore.tool.sbi.gnu.c.compiler sbi.gnu.c.compiler.option=%s " + "-T org.tizen.nativecore.tool.sbi.gnu.cpp.compiler sbi.gnu.cpp.compiler.option=%s";
    public static final String SDK_TOOL_PATH = "tools";
    public static final String SBI_HOME_PATH = "tools" + File.separator + "smart-build-interface";
    public static final String BUILDDIR = "Build";
    public static final String PROJECT_MANIFEST = "tizen-manifest.xml";
    public static final String PROJECT_PROP = "project_def.prop";
    public static final String PROJECT_PROP_APPNAME = "APPNAME";
    public static final String PROJECT_PROP_TYPE = "type";
    public static final String PROJECT_PROP_PROFILE = "profile";
    public static final String PROJECT_PROP_RES_EXCLUDE = "USER_RES_EXCLUDE";
    public static final String PROJECT_PROP_RES_INCLUDE = "USER_RES_INCLUDE";
    public static final String BUILD_PROP = "build_def.prop";
    public static final String[][] CPROJECT_CRITERIA = new String[][]{{"C++ Compiler", "sbi.gnu.cpp.compiler.option"}, {"C Compiler", "sbi.gnu.c.compiler.option"}};
    public static final String[] ARCHGROUP_X86 = new String[]{"86", "x86", "i386", "ia32", "i586", "i686"};
    public static final String[] ARCHGROUP_ARM = new String[]{"arm", "ARMv7-a", "armel", "armv7l"};

    public static boolean isSameArchType(String arch1, String arch2) {
        if (BuildNativeOption.isX86Arch(arch1)) {
            return BuildNativeOption.isX86Arch(arch2);
        }
        if (BuildNativeOption.isArmArch(arch1)) {
            return BuildNativeOption.isArmArch(arch2);
        }
        return false;
    }

    public static boolean isX86Arch(String arch) {
        for (String a : ARCHGROUP_X86) {
            if (!a.equals(arch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isArmArch(String arch) {
        for (String a : ARCHGROUP_ARM) {
            if (!a.equals(arch)) continue;
            return true;
        }
        return false;
    }

    public static String getPlatformName(String path) {
        int beginIndex = path.indexOf(PLATFORM) + PLATFORM.length() + 2;
        int endIndex = path.indexOf(ROOTSTRAPS);
        return (String)path.subSequence(beginIndex, endIndex - 1);
    }

    static enum BuildNativeRequiredOption {
        architecture("architecture", new String[]{"x86", "arm", "x86_64", "aarch64"}, "default.build.architecture"),
        compiler("compiler", new String[]{"gcc", "gcc-version", "llvm", "llvm-version"}, "default.build.compiler"),
        configuration("configuration", new String[]{"Debug", "Release", "Dynamic Analyzer"}, "default.build.configuration");

        private String name;
        private String value;
        private String[] candidates;
        private String key;
        private String noValueMessage;

        private BuildNativeRequiredOption(String name, String[] candidates, String key) {
            this.name = name;
            this.candidates = candidates;
            this.key = key;
            this.noValueMessage = NLS.bind((String)TizenCLIMessages.BN_CANNOT_FIND_DEFAULT_INFO_CONFIG, (Object)key);
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String[] getCandidates() {
            return this.candidates;
        }

        public String getKey() {
            return this.key;
        }

        public String getErrorMessage() {
            return this.noValueMessage;
        }
    }
}

