/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildapp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BuildScriptData {
    public WorkspaceEntry workspace = new WorkspaceEntry();
    public List<ProjectEntry> projectList = null;
    public List<BuildEntry> buildList = null;
    public List<PackageEntry> packageList = null;
    public Map<String, BuildMethodEntry> buildMethodMap = null;

    public void addProject(ProjectEntry projEntry) {
        if (this.projectList == null) {
            this.projectList = new ArrayList<ProjectEntry>();
        }
        this.projectList.add(projEntry);
    }

    public List<ProjectEntry> getProjects() {
        return this.projectList;
    }

    public List<String> genAllProjectNames() {
        if (this.projectList == null || this.projectList.isEmpty()) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (ProjectEntry build : this.projectList) {
            String name = build.getName();
            if (name == null || !name.isEmpty()) continue;
            names.add(name);
        }
        return names.isEmpty() ? null : names;
    }

    public ProjectEntry getProjectEntry(String target) {
        if (this.projectList != null) {
            for (ProjectEntry proj : this.projectList) {
                if (proj.getName() == null || !proj.getName().equals(target)) continue;
                return proj;
            }
        }
        return null;
    }

    public void addBuildMethod(BuildMethodEntry methodEntry) {
        if (this.buildMethodMap == null) {
            this.buildMethodMap = new HashMap<String, BuildMethodEntry>();
        }
        this.buildMethodMap.put(methodEntry.getName(), methodEntry);
    }

    public Map<String, BuildMethodEntry> getBuildMethodMap() {
        return this.buildMethodMap;
    }

    public void addBuild(BuildEntry buildEntry) {
        if (this.buildList == null) {
            this.buildList = new ArrayList<BuildEntry>();
        }
        this.buildList.add(buildEntry);
    }

    public List<BuildEntry> getBuilds() {
        return this.buildList;
    }

    public List<String> genAllBuildNames() {
        if (this.buildList == null || this.buildList.isEmpty()) {
            return null;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (BuildEntry build : this.buildList) {
            String name = build.getName();
            if (name == null || !name.isEmpty() || !name.equals("_default_") || !name.equals("_override_")) continue;
            names.add(name);
        }
        return names.isEmpty() ? null : names;
    }

    public BuildEntry getBuildEntry(String target) {
        if (this.buildList != null) {
            for (BuildEntry build : this.buildList) {
                if (build.getName() == null || !build.getName().equals(target)) continue;
                return build;
            }
        }
        return null;
    }

    public void addPackage(PackageEntry packageEntry) {
        if (packageEntry.getName() == null || packageEntry.getName().isEmpty()) {
            return;
        }
        if (this.packageList == null) {
            this.packageList = new ArrayList<PackageEntry>();
        } else {
            int idx = -1;
            int cnt = this.packageList.size();
            for (int i = 0; i < cnt; ++i) {
                PackageEntry pkg = this.packageList.get(i);
                if (!pkg.getName().equals(packageEntry.getName())) continue;
                idx = i;
                break;
            }
            if (idx >= 0) {
                this.packageList.remove(idx);
            }
        }
        this.packageList.add(packageEntry);
    }

    public List<PackageEntry> getPackageList() {
        return this.packageList;
    }

    public WorkspaceEntry getWorkspace() {
        return this.workspace;
    }

    public static class BuildEntry {
        private String name;
        private List<String> targets;
        private List<String> buildMethods;
        private String arch;
        private List<String> predefines;
        private String output;
        private int jobs;
        private String buildscript;

        public BuildEntry(String name, List<String> targets, List<String> buildMethods, String arch, String output) {
            this.name = name;
            this.targets = targets;
            this.buildMethods = buildMethods;
            this.arch = arch;
            this.output = output;
        }

        public BuildEntry() {
            this(null, null, null, null, null);
        }

        public BuildEntry(BuildEntry buildEntry) {
            if (buildEntry == null) {
                return;
            }
            this.name = buildEntry.name;
            if (buildEntry.targets != null && !buildEntry.targets.isEmpty()) {
                this.targets = new ArrayList<String>();
                this.targets.addAll(buildEntry.targets);
            }
            if (buildEntry.buildMethods != null && !buildEntry.buildMethods.isEmpty()) {
                this.buildMethods = new ArrayList<String>();
                this.buildMethods.addAll(buildEntry.buildMethods);
            }
            this.arch = buildEntry.arch;
            this.output = buildEntry.output;
            this.buildscript = buildEntry.buildscript;
            this.jobs = buildEntry.jobs;
        }

        public void merge(BuildEntry buildEntry, boolean isReplaceName) {
            if (buildEntry == null) {
                return;
            }
            if (isReplaceName && buildEntry.name != null) {
                this.name = buildEntry.name;
            }
            if (buildEntry.targets != null && !buildEntry.targets.isEmpty()) {
                if (this.targets == null) {
                    this.targets = new ArrayList<String>();
                }
                this.targets.addAll(buildEntry.targets);
            }
            if (buildEntry.buildMethods != null && !buildEntry.buildMethods.isEmpty()) {
                if (this.buildMethods == null) {
                    this.buildMethods = new ArrayList<String>();
                }
                this.buildMethods.addAll(buildEntry.buildMethods);
            }
            if (buildEntry.arch != null) {
                this.arch = buildEntry.arch;
            }
            if (buildEntry.predefines != null && !buildEntry.predefines.isEmpty()) {
                if (this.predefines == null) {
                    this.predefines = new ArrayList<String>();
                }
                this.predefines.addAll(buildEntry.predefines);
            }
            if (buildEntry.output != null) {
                this.output = buildEntry.output;
            }
            if (buildEntry.buildscript != null) {
                this.buildscript = buildEntry.buildscript;
            }
            if (buildEntry.jobs != 0) {
                this.jobs = buildEntry.jobs;
            }
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public List<String> getTargetList() {
            return this.targets;
        }

        public List<String> getBuildMethodList() {
            return this.buildMethods;
        }

        public String getArchitecture() {
            return this.arch;
        }

        public void setArchitecture(String arch) {
            this.arch = arch;
        }

        public String getOutputPath() {
            return this.output;
        }

        public void setOutputPath(String outputPath) {
            this.output = outputPath;
        }

        public void addTargetProject(String targetProject) {
            if (this.targets == null) {
                this.targets = new ArrayList<String>();
            }
            if (!this.targets.contains(targetProject)) {
                this.targets.add(targetProject);
            }
        }

        public void addTargetProjectAll(List<String> targetProjects) {
            for (String target : targetProjects) {
                this.addTargetProject(target);
            }
        }

        public void addBuildMethod(String buildMethod) {
            if (this.buildMethods == null) {
                this.buildMethods = new ArrayList<String>();
            }
            if (!this.buildMethods.contains(buildMethod)) {
                this.buildMethods.add(buildMethod);
            }
        }

        public void addBuildMethodAll(List<String> buildMethods) {
            for (String build : buildMethods) {
                this.addBuildMethod(build);
            }
        }

        public void addPredefine(String predefine) {
            if (this.predefines == null) {
                this.predefines = new ArrayList<String>();
            }
            this.predefines.add(predefine);
        }

        public void addPredefineAll(String[] predefine) {
            for (String def : predefine) {
                this.addPredefine(def);
            }
        }

        public List<String> getPredefines() {
            return this.predefines;
        }

        public int getMultitaskJobs() {
            return this.jobs;
        }

        public void setMultitaskJobs(int jobs) {
            this.jobs = jobs;
        }

        public String getBuildScriptPath() {
            return this.buildscript;
        }

        public void setBuildScriptPath(String buildscript) {
            this.buildscript = buildscript;
        }
    }

    public static class BuildMethodEntry {
        private String name;
        private List<Rootstrap> rootstraps;
        private String toolchain;
        private List<String> buildConfigs;
        private List<String> predefines;

        public BuildMethodEntry(String name, List<Rootstrap> rootstraps, String toolchain, List<String> buildConfigs) {
            this.name = name;
            this.rootstraps = rootstraps;
            this.toolchain = toolchain;
            this.buildConfigs = buildConfigs;
        }

        public BuildMethodEntry() {
            this(null, null, null, null);
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public String getToolchain() {
            return this.toolchain;
        }

        public void setToolchain(String toolchain) {
            this.toolchain = toolchain;
        }

        public List<String> getBuildConfigs() {
            return this.buildConfigs;
        }

        public void addBuildConfig(String buildConfig) {
            if (this.buildConfigs == null) {
                this.buildConfigs = new ArrayList<String>();
            }
            this.buildConfigs.add(buildConfig);
        }

        public List<Rootstrap> getRootstrapList() {
            return this.rootstraps;
        }

        public void addRootstrap(String id, String platform, String arch) {
            if (this.rootstraps == null) {
                this.rootstraps = new ArrayList<Rootstrap>();
            }
            this.rootstraps.add(new Rootstrap(id, platform, arch));
        }

        public void addPredefine(String predefine) {
            if (this.predefines == null) {
                this.predefines = new ArrayList<String>();
            }
            this.predefines.add(predefine);
        }

        public void addPredefineAll(String[] predefine) {
            for (String def : predefine) {
                this.addPredefine(def);
            }
        }

        public List<String> getPredefines() {
            return this.predefines;
        }

        private static void putMethodList(List<Rootstrap> mList, Rootstrap m) {
            for (Rootstrap m2 : mList) {
                if (!m.equals(m2)) continue;
                return;
            }
            mList.add(m);
        }

        private static List<Rootstrap> mergeRootstraps(List<Rootstrap> srcMethods) {
            if (srcMethods == null || srcMethods.isEmpty()) {
                return null;
            }
            ArrayList<Rootstrap> methods = new ArrayList<Rootstrap>();
            ArrayList<Rootstrap> methods0 = new ArrayList<Rootstrap>();
            for (Rootstrap m : srcMethods) {
                if (m.isManditory()) {
                    BuildMethodEntry.putMethodList(methods, m);
                    continue;
                }
                if (methods0.isEmpty()) {
                    methods0.add(m);
                    continue;
                }
                ArrayList<Rootstrap> methods2 = new ArrayList<Rootstrap>();
                Rootstrap m3 = null;
                for (Rootstrap m2 : methods0) {
                    m3 = m2.merge(m);
                    if (!m3.isManditory()) continue;
                    BuildMethodEntry.putMethodList(methods, m3);
                }
                if (m3 != null && !m3.isManditory()) {
                    BuildMethodEntry.putMethodList(methods2, m3);
                }
                methods0.addAll(methods2);
            }
            if (methods.isEmpty()) {
                methods = methods0;
            }
            return methods;
        }

        public void mergeAllRootstraps() {
            this.rootstraps = BuildMethodEntry.mergeRootstraps(this.rootstraps);
        }

        public static class Rootstrap {
            public String id;
            public String platform;
            public String arch;

            public Rootstrap(String id, String platform, String arch) {
                this.id = id;
                this.platform = platform;
                this.arch = arch;
            }

            public int getType() {
                if (this.id != null && !this.id.isEmpty()) {
                    return 4;
                }
                int v = 0;
                if (this.platform != null && !this.platform.isEmpty()) {
                    ++v;
                }
                if (this.arch != null && !this.arch.isEmpty()) {
                    v += 2;
                }
                return v;
            }

            public boolean isManditory() {
                int t = this.getType();
                return t == 3 || t == 4;
            }

            public boolean isEmpty() {
                return this.getType() == 0;
            }

            public boolean equals(Rootstrap a) {
                int t2;
                int t1 = this.getType();
                if (t1 != (t2 = a.getType())) {
                    return false;
                }
                if (t1 == 4) {
                    return this.id.equals(a.id);
                }
                if (t1 == 1) {
                    return this.platform.equals(a.platform);
                }
                if (t1 == 2) {
                    return this.arch.equals(a.arch);
                }
                if (t1 == 3) {
                    return this.platform.equals(a.platform) && this.arch.equals(a.arch);
                }
                return false;
            }

            public Rootstrap merge(Rootstrap m) {
                int type1 = this.getType();
                int type2 = m.getType();
                if (type1 == 0 && type2 == 0) {
                    return null;
                }
                if (type1 >= 3 || type2 >= 3) {
                    if (type1 != 0) {
                        return this;
                    }
                    if (!(type2 == 0 || type1 != 0 && this.equals(m))) {
                        return m;
                    }
                } else {
                    if (type1 == type2) {
                        if (type1 == 1 && !this.platform.equals(m.platform)) {
                            return m;
                        }
                        if (type2 == 2 && !this.arch.equals(m.arch)) {
                            return m;
                        }
                        return this;
                    }
                    if (type1 == 1 && type2 == 2) {
                        return new Rootstrap(null, this.platform, m.arch);
                    }
                    if (type1 == 2 && type2 == 1) {
                        return new Rootstrap(null, m.platform, this.arch);
                    }
                }
                return null;
            }
        }
    }

    public static class PackageEntry {
        private String name;
        private String type;
        private boolean validate = true;
        private List<String> targets;
        private List<String> predefines;
        private String output;

        public PackageEntry(String name, String type, boolean validate, List<String> targets, String profile, String arch, String output) {
            this.name = name;
            this.type = type;
            this.validate = validate;
            this.targets = targets;
            this.output = output;
        }

        public PackageEntry() {
            this(null, null, true, null, null, null, null);
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setPackageType(String type) {
            this.type = type;
        }

        public String getPackageType() {
            return this.type;
        }

        public boolean getValidate() {
            return this.validate;
        }

        public List<String> getTargetList() {
            return this.targets;
        }

        public String getOutputPath() {
            return this.output;
        }

        public void addTarget(String target) {
            if (this.targets == null) {
                this.targets = new ArrayList<String>();
            }
            this.targets.add(target);
        }

        public void addTargetAll(Collection<String> targetList) {
            if (this.targets == null) {
                this.targets = new ArrayList<String>();
            }
            this.targets.addAll(targetList);
        }

        public void addPredefine(String predefine) {
            if (this.predefines == null) {
                this.predefines = new ArrayList<String>();
            }
            this.predefines.add(predefine);
        }

        public void addPredefineAll(String[] predefine) {
            for (String def : predefine) {
                this.addPredefine(def);
            }
        }

        public List<String> getPredefines() {
            return this.predefines;
        }
    }

    public static class ProjectEntry {
        private String name;
        private String projectPath;
        private String type;
        private boolean validate = true;
        private boolean ownBuild = false;
        private List<String> dependencies;
        private List<String> predefines;

        public ProjectEntry(String name, String projectPath, String type, boolean validate, boolean ownBuild, List<String> dependencies) {
            this.name = name;
            this.projectPath = projectPath;
            this.type = type;
            this.validate = validate;
            this.ownBuild = ownBuild;
            this.dependencies = dependencies;
        }

        public ProjectEntry() {
            this(null, null, null, true, false, null);
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setProjectPath(String projectPath) {
            this.projectPath = projectPath;
        }

        public String getProjectPath() {
            return this.projectPath;
        }

        public String getType() {
            return this.type;
        }

        public boolean getValidate() {
            return this.validate;
        }

        public boolean getOwnBuild() {
            return this.ownBuild;
        }

        public List<String> getDependencies() {
            return this.dependencies;
        }

        public void addDependencyProject(String dependencyProject) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList<String>();
            }
            this.dependencies.add(dependencyProject);
        }

        public void addDependencyProjectAll(String[] dependencyProject) {
            for (String dep : dependencyProject) {
                this.addDependencyProject(dep);
            }
        }

        public void addPredefine(String predefine) {
            if (this.predefines == null) {
                this.predefines = new ArrayList<String>();
            }
            this.predefines.add(predefine);
        }

        public void addPredefineAll(String[] predefine) {
            for (String def : predefine) {
                this.addPredefine(def);
            }
        }

        public List<String> getPredefines() {
            return this.predefines;
        }
    }

    public static class WorkspaceEntry {
        private String workspacePath;
        private String outputPath;

        public void setWorkspacePath(String workspacePath) {
            this.workspacePath = workspacePath;
        }

        public String getWorkspacePath() {
            return this.workspacePath;
        }

        public void setOutputPath(String outputPath) {
            this.outputPath = outputPath;
        }

        public String getOutputPath() {
            return this.outputPath;
        }
    }
}

