/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.build.buildnative;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.slf4j.Logger;
import org.tizen.ncli.subcommands.build.BuildMethodData;

public class BuildInfo
extends BuildMethodData {
    private String projType;

    public BuildInfo() {
    }

    public BuildInfo(String profileName, String profileVersion, String id, String architecture, String projType) {
        super(profileName, profileVersion, architecture, null, null, null, null, 0, null);
        this.projType = projType;
    }

    public String getProjectType() {
        return this.projType;
    }

    public void setProjectType(String projType) {
        this.projType = projType;
    }

    public void writeBuildInfo(String buildInfoPath, Logger log) {
        File propFile;
        Properties props = new Properties();
        if (this.getProfileName() != null) {
            props.put("profile", this.getProfileName());
        }
        if (this.getProfileVersion() != null) {
            props.put("profile-version", this.getProfileVersion());
        }
        if (this.getArchitecture() != null) {
            props.put("architecture", this.getArchitecture());
        }
        if (this.getToolchain() != null) {
            props.put("toolchain", this.getToolchain());
        }
        if (this.getBuildConfig() != null) {
            props.put("config", this.getBuildConfig());
        }
        if (this.getProjectType() != null) {
            props.put("type", this.getProjectType());
        }
        if ((propFile = new File(buildInfoPath)).exists()) {
            propFile.delete();
        }
        try {
            propFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        FileOutputStream outStream = null;
        try {
            outStream = new FileOutputStream(buildInfoPath);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        try {
            props.store(outStream, "Build information");
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    public boolean readBuildInfo(String buildInfoPath, Logger log) {
        File buildInfoFile = new File(buildInfoPath);
        if (!buildInfoFile.exists()) {
            return false;
        }
        FileInputStream inStream = null;
        try {
            inStream = new FileInputStream(buildInfoFile);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        Properties props = new Properties();
        try {
            props.load(inStream);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        this.setProjectType(props.getProperty("type"));
        this.setProfileName(props.getProperty("profile"));
        this.setProfileVersion(props.getProperty("profile-version"));
        this.setBuildConfig(props.getProperty("config"));
        this.setToolchain(props.getProperty("toolchain"));
        this.setArchitecture(props.getProperty("architecture"));
        return true;
    }
}

