/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ncli.subcommands.sign;

import java.io.File;
import java.io.InputStreamReader;
import org.eclipse.osgi.util.NLS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.Command;
import org.tizen.common.sign.command.ReadSigningProfileFileCommand;
import org.tizen.common.sign.command.SignCommand;
import org.tizen.common.sign.preferences.SigningProfile;
import org.tizen.common.sign.preferences.SigningProfileItem;
import org.tizen.common.util.StringUtil;
import org.tizen.ncli.config.Configuration;
import org.tizen.ncli.core.CommandLineExecutor;
import org.tizen.ncli.core.ConsolePrompter;
import org.tizen.ncli.ide.messages.TizenCLIMessages;
import org.tizen.ncli.subcommands.AbstractSubCommand;
import org.tizen.ncli.subcommands.sign.Sign;

public class SignCLICommand
extends AbstractSubCommand<Sign> {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private Configuration config = new Configuration();
    private String profilesPath;
    private String profileName;

    @Override
    protected Sign call() {
        this.setProfilesPath();
        if (this.validateProfilesPath()) {
            CommandLineExecutor executor = new CommandLineExecutor(new ConsolePrompter(System.out, new InputStreamReader(System.in)));
            ReadSigningProfileFileCommand readProfile = new ReadSigningProfileFileCommand(this.profilesPath, this.profileName);
            executor.execute(new Command[]{readProfile});
            this.log.info("Profiles file[{}] is read", (Object)this.profilesPath);
            SigningProfile profile = readProfile.getProfile();
            if (profile == null) {
                System.out.println(NLS.bind((String)TizenCLIMessages.SIGN_NO_PROFILES, (Object)this.profileName, (Object)this.profilesPath));
                return null;
            }
            for (int i = 0; i <= 2; ++i) {
                SigningProfileItem item = profile.getProfileItem(i);
                if (item == null || StringUtil.isEmpty((CharSequence)item.getKeyLocation())) continue;
                String msg = i == 0 ? "Author certficate: " : "Distributor" + i + " certificate : ";
                System.out.println(msg + item.getKeyLocation());
            }
            SignCommand command = new SignCommand(this.workingDir.getAbsolutePath(), profile);
            if (new File(this.workingDir, "res/res.xml").exists()) {
                command.setSlicingMode(true);
            }
            executor.execute(new Command[]{command});
        }
        return null;
    }

    public void setProfileName(String profile) {
        this.profileName = profile;
    }

    private void setProfilesPath() {
        this.profilesPath = this.config.getValue("profiles.path");
        if (this.profilesPath == null) {
            this.profilesPath = this.config.getValue("default.profiles.path");
        }
    }

    private boolean validateProfilesPath() {
        boolean result = false;
        if (this.profilesPath != null) {
            File profiles = new File(this.profilesPath);
            if (profiles.exists()) {
                result = true;
            } else {
                System.out.println(NLS.bind((String)TizenCLIMessages.SIGN_NO_PROFILES, (Object)this.profilesPath));
            }
        } else {
            System.out.println(TizenCLIMessages.SIGN_NO_CONFIG_PROFILES);
        }
        return result;
    }
}

