/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.core.application;

public enum ProfileAppType {
    NATIVE(0, "NATIVE_IDE"),
    WEB(1, "WEB_IDE"),
    PLATFORM(2, "PLATFORM_IDE");

    private int stateCode;
    private String stateName;

    private ProfileAppType(int stateCode, String stateName) {
        this.stateCode = stateCode;
        this.stateName = stateName;
    }

    public String getStateName() {
        return this.stateName;
    }

    public String toString() {
        return this.name();
    }

    public int getStateCode() {
        return this.stateCode;
    }

    public static ProfileAppType getAppTypeToCode(int stateCode) {
        ProfileAppType[] profileAppTypeArray = ProfileAppType.values();
        int n = profileAppTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProfileAppType type = profileAppTypeArray[n2];
            if (type.getStateCode() == stateCode) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static ProfileAppType getAppTypeToName(String appType) {
        ProfileAppType[] profileAppTypeArray = ProfileAppType.values();
        int n = profileAppTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProfileAppType type = profileAppTypeArray[n2];
            if (type.name().toLowerCase().equals(appType.toLowerCase())) {
                return type;
            }
            ++n2;
        }
        return null;
    }

    public static ProfileAppType getAppTypeToStateName(String appType) {
        ProfileAppType[] profileAppTypeArray = ProfileAppType.values();
        int n = profileAppTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProfileAppType type = profileAppTypeArray[n2];
            if (type.stateName.toLowerCase().equals(appType.toLowerCase())) {
                return type;
            }
            ++n2;
        }
        return null;
    }
}

