/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.verrari.template;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class TemplateTransformer {
    public static final String REGEX_LINECOMMENT = "(\\$\\#).*";
    public static final String REGEX_TRANSFORM = "(\\$\\$\\{)(.*?)(\\})";
    public static final String REGEX_FUNCTION = "(\\$\\@\\{)(.*?)(\\})";
    public static final String REGEX_INCLUDE = "(\\$\\$include)(.*?)(\\})";
    public static final String REGEX_IF = "(\\$\\$if)(.*?)(\\})";
    public static final String REGEX_ELSEIF = "(\\$\\$elseif)(.*?)(\\})";
    public static final String REGEX_ELSE = "(\\$\\$else)";
    public static final String REGEX_ENDIF = "(\\$\\$endif)";

    public String templateTranslate(String contents) {
        return this.translateIf(this.translateFunction(this.translateInclude(this.translateTransform(this.translateLineComment(contents)))));
    }

    public String translateLineComment(String contents) {
        Pattern pattern = Pattern.compile(REGEX_LINECOMMENT);
        Matcher matcher = pattern.matcher(contents);
        return matcher.replaceAll("");
    }

    public abstract String translateTransform(String var1);

    public abstract String translateFunction(String var1);

    public abstract String translateInclude(String var1);

    public abstract String translateIf(String var1);
}

