#!/bin/bash
TIZEN_SDK_INSTALL_PATH=${INSTALLED_PATH}
TOOLS_PATH=${TIZEN_SDK_INSTALL_PATH}/tools
CLI_PATH=${TOOLS_PATH}/ide/bin
CLI_LOG_FILE=../ncli.log

TIZEN_COMPLETION_SCRIPT=${CLI_PATH}/tizen-autocomplete
TIZEN_COMPLETION_LINK_PATH=${CLI_PATH}/tizen
TIZEN_NEWCLI_SH=${CLI_PATH}/tizen.sh
SOURCE_TIZEN_COMPLETION="source ${TIZEN_COMPLETION_SCRIPT}"

CLI_LIB_PATH=${TOOLS_PATH}/ide/lib-ncli
LOG_CONFIG_PATH=${TOOLS_PATH}/ide/conf-ncli
LOG4J_CONFIG=${LOG_CONFIG_PATH}/log4j-progress.xml

BASH_RC=~/.bashrc

sed -i "s:LOG_CONFIG_PATH:\"${LOG_CONFIG_PATH}\":g" ${TIZEN_COMPLETION_SCRIPT}
sed -i "s:CLI_LIB_PATH:\"${CLI_LIB_PATH}\":g" ${TIZEN_COMPLETION_SCRIPT}
sed -i "s:CLI_LOG_FILE:\"${CLI_LOG_FILE}\":g" ${LOG4J_CONFIG}

#ln -s ${TIZEN_NEWCLI_SH} ${TIZEN_COMPLETION_LINK_PATH}
chmod 755 ${TIZEN_NEWCLI_SH}
chmod 755 ${TIZEN_COMPLETION_LINK_PATH}

if [ -f "${BASH_RC}" ]; then
    if [ -z "$(grep "${SOURCE_TIZEN_COMPLETION}" "${BASH_RC}")" ]; then
        echo -e "${SOURCE_TIZEN_COMPLETION}" >> "${BASH_RC}"
    fi
else
    echo -e "${SOURCE_TIZEN_COMPLETION}" >> "${BASH_RC}"
fi

exit 0

